/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.library;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javolution.util.FastMap;
import org.mobicents.smsc.library.CorrelationIdValue;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SriResponseValue;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.library.TargetAddressContainer;
import org.mobicents.smsc.library.UpdateMessagesInProcessListener;

public class SmsSetCache {
    public static int SMSSET_MSG_PRO_SEGMENT_LIMIT = 50;
    public static int SMSSET_FREE_SEGMENT_CNT = 100;
    private int processingSmsSetTimeout;
    private int correlationIdLiveTime;
    private int sriResponseLiveTime;
    private int deliveredMsgLiveTime;
    private boolean isStarted = false;
    private FastMap<TargetAddress, TargetAddressContainer> lstSmsSetUnderAtomicOper = new FastMap();
    private AtomicInteger activityCount = new AtomicInteger(0);
    private FastMap<String, SmsSet> lstSmsSetInProcessing = new FastMap();
    private FastMap<String, SmsSet> lstSmsSetWithBigMessageCount = new FastMap();
    private UpdateMessagesInProcessListener smscStatAggregator;
    private FastMap<String, CorrelationIdValue> correlationIdCache1 = new FastMap();
    private FastMap<String, CorrelationIdValue> correlationIdCache2 = new FastMap();
    private Object correlationIdCacheSync = new Object();
    private FastMap<String, SriResponseValue> sriRespCache1 = new FastMap();
    private FastMap<String, SriResponseValue> sriRespCache2 = new FastMap();
    private Object sriRespCacheSync = new Object();
    private FastMap<Long, Sms> deliveredMsgCache1 = new FastMap();
    private FastMap<Long, Sms> deliveredMsgCache2 = new FastMap();
    private Object deliveredMsgCacheSync = new Object();
    private FastMap<String, Long> deliveredRemoteMsgIdCache1 = new FastMap();
    private FastMap<String, Long> deliveredRemoteMsgIdCache2 = new FastMap();
    private Object deliveredRemoteMsgIdCacheSync = new Object();
    private ScheduledExecutorService executor;
    private static SmsSetCache singeltone = new SmsSetCache();

    private SmsSetCache() {
    }

    public static SmsSetCache getInstance() {
        return singeltone;
    }

    public static void start(int correlationIdLiveTime, int sriResponseLiveTime, int deliveredMsgLiveTime) {
        SmsSetCache ssc = SmsSetCache.getInstance();
        ssc.correlationIdLiveTime = correlationIdLiveTime;
        ssc.sriResponseLiveTime = sriResponseLiveTime;
        ssc.deliveredMsgLiveTime = deliveredMsgLiveTime;
        ssc.executor = Executors.newScheduledThreadPool(1);
        ssc.isStarted = true;
        SmsSetCache smsSetCache = ssc;
        smsSetCache.getClass();
        CacheManTask t = smsSetCache.new CacheManTask();
        ssc.executor.schedule(t, (long)correlationIdLiveTime, TimeUnit.SECONDS);
        SmsSetCache smsSetCache2 = ssc;
        smsSetCache2.getClass();
        CacheManTask_SRI_Resp t2 = smsSetCache2.new CacheManTask_SRI_Resp();
        ssc.executor.schedule(t2, (long)sriResponseLiveTime, TimeUnit.SECONDS);
        SmsSetCache smsSetCache3 = ssc;
        smsSetCache3.getClass();
        CacheManTask_Delivered_Msg t3 = smsSetCache3.new CacheManTask_Delivered_Msg();
        ssc.executor.schedule(t3, (long)deliveredMsgLiveTime, TimeUnit.SECONDS);
        SmsSetCache smsSetCache4 = ssc;
        smsSetCache4.getClass();
        CacheManTask_Delivered_RemoteMsgId t4 = smsSetCache4.new CacheManTask_Delivered_RemoteMsgId();
        ssc.executor.schedule(t4, (long)deliveredMsgLiveTime, TimeUnit.SECONDS);
    }

    public static void stop() {
        SmsSetCache ssc = SmsSetCache.getInstance();
        ssc.isStarted = false;
        ssc.executor.shutdown();
    }

    public void setUpdateMessagesInProcessListener(UpdateMessagesInProcessListener smscStatAggregator) {
        this.smscStatAggregator = smscStatAggregator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetAddress addSmsSet(TargetAddress ta) {
        FastMap<TargetAddress, TargetAddressContainer> fastMap = this.lstSmsSetUnderAtomicOper;
        synchronized (fastMap) {
            TargetAddressContainer cont = (TargetAddressContainer)this.lstSmsSetUnderAtomicOper.get((Object)ta);
            if (cont != null) {
                ++cont.count;
                return cont.targetAddress;
            }
            cont = new TargetAddressContainer();
            this.lstSmsSetUnderAtomicOper.put((Object)ta, (Object)cont);
            cont.count = 1;
            cont.targetAddress = ta;
            return ta;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSmsSet(TargetAddress ta) {
        FastMap<TargetAddress, TargetAddressContainer> fastMap = this.lstSmsSetUnderAtomicOper;
        synchronized (fastMap) {
            TargetAddressContainer cont = (TargetAddressContainer)this.lstSmsSetUnderAtomicOper.get((Object)ta);
            if (cont != null && --cont.count <= 0) {
                this.lstSmsSetUnderAtomicOper.remove((Object)ta);
            }
        }
    }

    public void incrementActivityCount() {
        this.activityCount.incrementAndGet();
    }

    public void decrementActivityCount() {
        this.activityCount.decrementAndGet();
    }

    public int getActivityCount() {
        return this.activityCount.get();
    }

    public SmsSet getProcessingSmsSet(String targetId) {
        return (SmsSet)this.lstSmsSetInProcessing.get((Object)targetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmsSet addProcessingSmsSet(String targetId, SmsSet smsSet, int processingSmsSetTimeout) {
        this.processingSmsSetTimeout = processingSmsSetTimeout;
        FastMap<String, SmsSet> fastMap = this.lstSmsSetInProcessing;
        synchronized (fastMap) {
            SmsSet res = (SmsSet)this.lstSmsSetInProcessing.put((Object)targetId, (Object)smsSet);
            if (this.smscStatAggregator != null) {
                this.smscStatAggregator.updateMaxMessagesInProcess(this.lstSmsSetInProcessing.size());
                this.smscStatAggregator.updateMinMessagesInProcess(this.lstSmsSetInProcessing.size());
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSmsSetWithBigMessageCount(String targetId, SmsSet smsSet) {
        FastMap<String, SmsSet> fastMap = this.lstSmsSetInProcessing;
        synchronized (fastMap) {
            this.lstSmsSetWithBigMessageCount.put((Object)targetId, (Object)smsSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SmsSet removeProcessingSmsSet(String targetId) {
        FastMap<String, SmsSet> fastMap = this.lstSmsSetInProcessing;
        synchronized (fastMap) {
            SmsSet smsSet = (SmsSet)this.lstSmsSetInProcessing.remove((Object)targetId);
            this.lstSmsSetWithBigMessageCount.remove((Object)targetId);
            if (this.smscStatAggregator != null) {
                this.smscStatAggregator.updateMaxMessagesInProcess(this.lstSmsSetInProcessing.size());
                this.smscStatAggregator.updateMinMessagesInProcess(this.lstSmsSetInProcessing.size());
            }
            return smsSet;
        }
    }

    public int getProcessingSmsSetSize() {
        try {
            int res = this.lstSmsSetInProcessing.size();
            FastMap.Entry n = this.lstSmsSetWithBigMessageCount.head();
            FastMap.Entry end = this.lstSmsSetWithBigMessageCount.tail();
            while ((n = n.getNext()) != end && n != null) {
                res += ((SmsSet)n.getValue()).getSmsCountWithoutDelivered();
            }
            return res;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getLstSmsSetWithBigMessageCountState() {
        if (this.lstSmsSetWithBigMessageCount.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        FastMap.Entry n = this.lstSmsSetWithBigMessageCount.head();
        FastMap.Entry end = this.lstSmsSetWithBigMessageCount.tail();
        while ((n = n.getNext()) != end && n != null) {
            SmsSet smsSet = (SmsSet)n.getValue();
            sb.append(smsSet.getTargetId());
            sb.append(" - ");
            sb.append(smsSet.getSmsCount());
            sb.append(" - ");
            sb.append(smsSet.getSmsCountWithoutDelivered());
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void garbadeCollectProcessingSmsSet() {
        FastMap<String, SmsSet> fastMap = this.lstSmsSetInProcessing;
        synchronized (fastMap) {
            Date limit = new Date(new Date().getTime() - (long)(this.processingSmsSetTimeout * 1000));
            ArrayList toDel = new ArrayList();
            for (Map.Entry entry : this.lstSmsSetInProcessing.entrySet()) {
                if (!((SmsSet)entry.getValue()).getLastUpdateTime().before(limit)) continue;
                toDel.add(entry.getKey());
            }
            for (String key : toDel) {
                this.lstSmsSetInProcessing.remove((Object)key);
            }
            toDel = new ArrayList();
            for (Map.Entry entry : this.lstSmsSetWithBigMessageCount.entrySet()) {
                if (!((SmsSet)entry.getValue()).getLastUpdateTime().before(limit)) continue;
                toDel.add(entry.getKey());
            }
            for (String key : toDel) {
                this.lstSmsSetWithBigMessageCount.remove((Object)key);
            }
            if (this.smscStatAggregator != null) {
                this.smscStatAggregator.updateMaxMessagesInProcess(this.lstSmsSetInProcessing.size());
                this.smscStatAggregator.updateMinMessagesInProcess(this.lstSmsSetInProcessing.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearProcessingSmsSet() {
        FastMap<String, SmsSet> fastMap = this.lstSmsSetInProcessing;
        synchronized (fastMap) {
            this.lstSmsSetInProcessing.clear();
            this.lstSmsSetWithBigMessageCount.clear();
            if (this.smscStatAggregator != null) {
                this.smscStatAggregator.updateMaxMessagesInProcess(this.lstSmsSetInProcessing.size());
                this.smscStatAggregator.updateMinMessagesInProcess(this.lstSmsSetInProcessing.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putCorrelationIdCacheElement(CorrelationIdValue elem, int correlationIdLiveTime) throws Exception {
        this.correlationIdLiveTime = correlationIdLiveTime;
        Object object = this.correlationIdCacheSync;
        synchronized (object) {
            this.correlationIdCache1.put((Object)elem.getCorrelationID(), (Object)elem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CorrelationIdValue getCorrelationIdCacheElement(String correlationID) throws Exception {
        Object object = this.correlationIdCacheSync;
        synchronized (object) {
            CorrelationIdValue res = (CorrelationIdValue)this.correlationIdCache1.get((Object)correlationID);
            if (res == null) {
                res = (CorrelationIdValue)this.correlationIdCache2.get((Object)correlationID);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putSriResponseValue(SriResponseValue elem, int sriResponseLiveTime) throws Exception {
        this.sriResponseLiveTime = sriResponseLiveTime;
        if (sriResponseLiveTime > 0) {
            Object object = this.sriRespCacheSync;
            synchronized (object) {
                this.sriRespCache1.put((Object)elem.getTargetID(), (Object)elem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SriResponseValue getSriResponseValue(String targetID) throws Exception {
        if (this.sriResponseLiveTime == 0) {
            return null;
        }
        Object object = this.sriRespCacheSync;
        synchronized (object) {
            SriResponseValue res = (SriResponseValue)this.sriRespCache1.get((Object)targetID);
            if (res == null) {
                res = (SriResponseValue)this.sriRespCache2.get((Object)targetID);
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDeliveredMsgValue(Sms sms, int deliveredMsgLiveTime) {
        this.deliveredMsgLiveTime = deliveredMsgLiveTime;
        if (deliveredMsgLiveTime > 0) {
            Object object = this.deliveredMsgCacheSync;
            synchronized (object) {
                this.deliveredMsgCache1.put((Object)sms.getMessageId(), (Object)sms);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sms getDeliveredMsgValue(Long messageId) {
        if (this.deliveredMsgLiveTime == 0) {
            return null;
        }
        Object object = this.deliveredMsgCacheSync;
        synchronized (object) {
            Sms res = (Sms)this.deliveredMsgCache1.get((Object)messageId);
            if (res == null) {
                res = (Sms)this.deliveredMsgCache2.get((Object)messageId);
            }
            return res;
        }
    }

    public static String generateRemoteMsgIdKey(String remoteMessageId, String destId) {
        StringBuilder sb = new StringBuilder();
        sb.append(remoteMessageId);
        sb.append("_");
        sb.append(destId);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putDeliveredRemoteMsgIdValue(String remoteMessageId, String destId, Long messageId, int deliveredMsgLiveTime) {
        this.deliveredMsgLiveTime = deliveredMsgLiveTime;
        if (deliveredMsgLiveTime > 0) {
            Object object = this.deliveredRemoteMsgIdCacheSync;
            synchronized (object) {
                this.deliveredRemoteMsgIdCache1.put((Object)SmsSetCache.generateRemoteMsgIdKey(remoteMessageId, destId), (Object)messageId);
            }
        }
    }

    public int getXxxxx() {
        return this.deliveredRemoteMsgIdCache1.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getDeliveredRemoteMsgIdValue(String remoteMessageId, String destId) {
        if (this.deliveredMsgLiveTime == 0) {
            return null;
        }
        String key = SmsSetCache.generateRemoteMsgIdKey(remoteMessageId, destId);
        Object object = this.deliveredRemoteMsgIdCacheSync;
        synchronized (object) {
            Long res = (Long)this.deliveredRemoteMsgIdCache1.get((Object)key);
            if (res == null) {
                res = (Long)this.deliveredRemoteMsgIdCache2.get((Object)key);
            }
            return res;
        }
    }

    private class CacheManTask_Delivered_RemoteMsgId
    implements Runnable {
        private CacheManTask_Delivered_RemoteMsgId() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SmsSetCache.this.deliveredRemoteMsgIdCache2 = SmsSetCache.this.deliveredRemoteMsgIdCache1;
                SmsSetCache.this.deliveredRemoteMsgIdCache1 = new FastMap();
            }
            finally {
                if (SmsSetCache.this.isStarted) {
                    CacheManTask_Delivered_RemoteMsgId t = new CacheManTask_Delivered_RemoteMsgId();
                    int time = SmsSetCache.this.deliveredMsgLiveTime;
                    if (time <= 0) {
                        time = 60;
                    }
                    SmsSetCache.this.executor.schedule(t, (long)time, TimeUnit.SECONDS);
                }
            }
        }
    }

    private class CacheManTask_Delivered_Msg
    implements Runnable {
        private CacheManTask_Delivered_Msg() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SmsSetCache.this.deliveredMsgCache2 = SmsSetCache.this.deliveredMsgCache1;
                SmsSetCache.this.deliveredMsgCache1 = new FastMap();
            }
            finally {
                if (SmsSetCache.this.isStarted) {
                    CacheManTask_Delivered_Msg t = new CacheManTask_Delivered_Msg();
                    int time = SmsSetCache.this.deliveredMsgLiveTime;
                    if (time <= 0) {
                        time = 60;
                    }
                    SmsSetCache.this.executor.schedule(t, (long)time, TimeUnit.SECONDS);
                }
            }
        }
    }

    private class CacheManTask_SRI_Resp
    implements Runnable {
        private CacheManTask_SRI_Resp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SmsSetCache.this.sriRespCache2 = SmsSetCache.this.sriRespCache1;
                SmsSetCache.this.sriRespCache1 = new FastMap();
            }
            finally {
                if (SmsSetCache.this.isStarted) {
                    CacheManTask_SRI_Resp t = new CacheManTask_SRI_Resp();
                    int time = SmsSetCache.this.sriResponseLiveTime;
                    if (time <= 0) {
                        time = 60;
                    }
                    SmsSetCache.this.executor.schedule(t, (long)time, TimeUnit.SECONDS);
                }
            }
        }
    }

    private class CacheManTask
    implements Runnable {
        private CacheManTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                SmsSetCache.this.correlationIdCache2 = SmsSetCache.this.correlationIdCache1;
                SmsSetCache.this.correlationIdCache1 = new FastMap();
            }
            finally {
                if (SmsSetCache.this.isStarted) {
                    CacheManTask t = new CacheManTask();
                    SmsSetCache.this.executor.schedule(t, (long)SmsSetCache.this.correlationIdLiveTime, TimeUnit.SECONDS);
                }
            }
        }
    }
}

