/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.library;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.mobicents.protocols.ss7.map.api.service.sms.LocationInfoWithLMSI;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.SmType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSetCache;

public class SmsSet
implements Serializable {
    private static final long serialVersionUID = -627234093407300864L;
    private int destAddrTon;
    private int destAddrNpi;
    private String destAddr;
    private int networkId;
    private String destClusterName;
    private String destSystemId;
    private String destEsmeName;
    private String imsi;
    private LocationInfoWithLMSI locationInfoWithLMSI;
    private String correlationId;
    private Date dueDate;
    private int dueDelay;
    private int inSystem;
    private Date inSystemDate;
    private ErrorCode status;
    private SmType type;
    private Date lastDelivery;
    private boolean alertingSupported;
    private boolean processingStarted = false;
    private List<Segment> segmList = new ArrayList<Segment>();
    private long markedSmsAsDelivered = 0L;
    private Date lastUpdateTime = new Date();
    private ArrayList<Sms> sendingMessagePool = new ArrayList();

    public String getTargetId() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.destAddr);
        sb.append("_");
        sb.append(this.destAddrTon);
        sb.append("_");
        sb.append(this.destAddrNpi);
        sb.append("_");
        sb.append(this.networkId);
        return sb.toString();
    }

    public int getDestAddrTon() {
        return this.destAddrTon;
    }

    public void setDestAddrTon(int destAddrTon) {
        this.destAddrTon = destAddrTon;
    }

    public int getDestAddrNpi() {
        return this.destAddrNpi;
    }

    public void setDestAddrNpi(int destAddrNpi) {
        this.destAddrNpi = destAddrNpi;
    }

    public String getDestAddr() {
        return this.destAddr;
    }

    public void setDestAddr(String destAddr) {
        this.destAddr = destAddr;
    }

    public int getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    public String getDestClusterName() {
        return this.destClusterName;
    }

    public void setDestClusterName(String destClusterName) {
        this.destClusterName = destClusterName;
    }

    public String getDestSystemId() {
        return this.destSystemId;
    }

    public void setDestSystemId(String destSystemId) {
        this.destSystemId = destSystemId;
    }

    public String getDestEsmeName() {
        return this.destEsmeName;
    }

    public void setDestEsmeName(String destEsmeName) {
        this.destEsmeName = destEsmeName;
    }

    public String getImsi() {
        return this.imsi;
    }

    public void setImsi(String imsi) {
        this.imsi = imsi;
    }

    public LocationInfoWithLMSI getLocationInfoWithLMSI() {
        return this.locationInfoWithLMSI;
    }

    public void setLocationInfoWithLMSI(LocationInfoWithLMSI locationInfoWithLMSI) {
        this.locationInfoWithLMSI = locationInfoWithLMSI;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public int getDueDelay() {
        return this.dueDelay;
    }

    public void setDueDelay(int dueDelay) {
        this.dueDelay = dueDelay;
    }

    public void updateDueDelay(int dueDelay) {
        if (this.dueDelay > dueDelay) {
            this.dueDelay = dueDelay;
        }
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public int getInSystem() {
        return this.inSystem;
    }

    public void setInSystem(int inSystem) {
        this.inSystem = inSystem;
    }

    public Date getInSystemDate() {
        return this.inSystemDate;
    }

    public void setInSystemDate(Date inSystemDate) {
        this.inSystemDate = inSystemDate;
    }

    public ErrorCode getStatus() {
        return this.status;
    }

    public void setStatus(ErrorCode status) {
        this.status = status;
    }

    public SmType getType() {
        return this.type;
    }

    public void setType(SmType type) {
        this.type = type;
    }

    public Date getLastDelivery() {
        return this.lastDelivery;
    }

    public void setLastDelivery(Date lastDelivery) {
        this.lastDelivery = lastDelivery;
    }

    public boolean isAlertingSupported() {
        return this.alertingSupported;
    }

    public void setAlertingSupported(boolean alertingSupported) {
        this.alertingSupported = alertingSupported;
    }

    public void clearSmsList() {
        this.segmList.clear();
    }

    public void addSms(Sms sms) {
        int i1 = this.segmList.size();
        if (i1 == 0) {
            this.segmList.add(new Segment());
            ++i1;
        }
        Segment segm = this.segmList.get(i1 - 1);
        segm.smsList.add(sms);
        ++segm.cnt;
        sms.setSmsSet(this);
    }

    public void addSmsSet(SmsSet smsSet) {
        this.updateLastUpdateTime();
        ArrayList<Sms> al = smsSet.segmList.get((int)0).smsList;
        int i1 = this.segmList.size();
        if (i1 == 0) {
            Segment segm = new Segment();
            segm.smsList = al;
            segm.cnt = al.size();
            this.segmList.add(segm);
            for (int i2 = 0; i2 < al.size(); ++i2) {
                Sms smsx = al.get(i2);
                smsx.setSmsSet(this);
            }
        } else if (this.segmList.get((int)(i1 - 1)).smsList.size() + al.size() > SmsSetCache.SMSSET_MSG_PRO_SEGMENT_LIMIT) {
            for (int i2 = 0; i2 < al.size(); ++i2) {
                Sms smsx = al.get(i2);
                if (this.checkSmsPresent(smsx)) {
                    al.remove(i2);
                    --i2;
                    continue;
                }
                smsx.setSmsSet(this);
            }
            if (al.size() > 0) {
                Segment segm = new Segment();
                segm.smsList = al;
                segm.cnt = al.size();
                this.segmList.add(segm);
            }
        } else {
            Segment segm = this.segmList.get(i1 - 1);
            ArrayList<Sms> al2 = segm.smsList;
            for (int i2 = 0; i2 < al.size(); ++i2) {
                Sms smsx = smsSet.getSms(i2);
                if (this.checkSmsPresent(smsx)) continue;
                smsx.setSmsSet(this);
                al2.add(smsx);
                ++segm.cnt;
            }
        }
        if (this.segmList.size() > 1) {
            SmsSetCache.getInstance().registerSmsSetWithBigMessageCount(this.getTargetId(), this);
        }
    }

    public void resortSms() {
        int i1 = this.segmList.size();
        if (i1 > 0) {
            ArrayList<Sms> al = this.segmList.get((int)(i1 - 1)).smsList;
            Collections.sort(al, new SmsComparator());
        }
    }

    public Sms getSms(long index) {
        List<Segment> lst = this.segmList;
        int segmCnt = lst.size();
        long indexCur = index;
        for (int i1 = 0; i1 < segmCnt; ++i1) {
            Segment segm = lst.get(i1);
            if (indexCur < segm.cnt) {
                ArrayList<Sms> al = segm.smsList;
                if (al != null) {
                    return al.get((int)indexCur);
                }
                return null;
            }
            indexCur -= segm.cnt;
        }
        return null;
    }

    public void markSmsAsDelivered(long index) {
        Segment segm;
        int i1;
        this.markedSmsAsDelivered = index + 1L;
        List<Segment> lst = this.segmList;
        int segmCnt = lst.size();
        long cumCnt = 0L;
        int intNum = 0;
        for (i1 = 0; i1 < segmCnt; ++i1) {
            segm = lst.get(i1);
            if (index >= (cumCnt += segm.cnt)) continue;
            intNum = i1;
            break;
        }
        for (i1 = 0; i1 < intNum; ++i1) {
            segm = lst.get(i1);
            if (segm.smsList == null) continue;
            segm.smsList = null;
        }
        if (intNum >= SmsSetCache.SMSSET_FREE_SEGMENT_CNT) {
            ArrayList<Segment> lst2 = new ArrayList<Segment>();
            long cnt = 0L;
            for (int i12 = 0; i12 < intNum; ++i12) {
                cnt += lst.get((int)i12).cnt;
            }
            Segment segm2 = new Segment();
            segm2.cnt = cnt;
            segm2.smsList = null;
            lst2.add(segm2);
            for (int i13 = intNum; i13 < segmCnt; ++i13) {
                lst2.add(lst.get(i13));
            }
            this.segmList = lst2;
        }
    }

    public long getSmsCount() {
        List<Segment> lst = this.segmList;
        int segmCnt = lst.size();
        long res = 0L;
        for (int i1 = 0; i1 < segmCnt; ++i1) {
            Segment segm = lst.get(i1);
            res += segm.cnt;
        }
        return res;
    }

    public int getSmsCountWithoutDelivered() {
        int res = (int)(this.getSmsCount() - this.markedSmsAsDelivered);
        if (res > 0) {
            return res;
        }
        return 0;
    }

    public List<Sms> getRawListLastSegment() {
        int i1 = this.segmList.size();
        if (i1 > 0) {
            ArrayList<Sms> al = this.segmList.get((int)(i1 - 1)).smsList;
            return new ArrayList<Sms>(al);
        }
        return new ArrayList<Sms>();
    }

    public boolean checkSmsPresent(Sms sms) {
        List<Segment> lst = this.segmList;
        int segmCnt = lst.size();
        for (int i1 = 0; i1 < segmCnt; ++i1) {
            Segment segm = lst.get(i1);
            ArrayList<Sms> al = segm.smsList;
            if (al == null) continue;
            int mCnt = al.size();
            for (int i2 = 0; i2 < mCnt; ++i2) {
                Sms smsa = al.get(i2);
                if (!smsa.getDbId().equals(sms.getDbId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isProcessingStarted() {
        return this.processingStarted;
    }

    public void setProcessingStarted() {
        this.processingStarted = true;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void updateLastUpdateTime() {
        this.lastUpdateTime = new Date();
    }

    public void clearSendingPool() {
        this.sendingMessagePool.clear();
    }

    public void addMessageToSendingPool(Sms sms) {
        this.sendingMessagePool.add(sms);
    }

    public Sms getMessageFromSendingPool(int number) {
        return this.sendingMessagePool.get(number);
    }

    public int getSendingPoolMsgCount() {
        return this.sendingMessagePool.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SmsSet [destAddrTon=");
        sb.append(this.destAddrTon);
        sb.append(", destAddrNpi=");
        sb.append(this.destAddrNpi);
        sb.append(", destAddr=");
        sb.append(this.destAddr);
        sb.append(", networkId=");
        sb.append(this.networkId);
        sb.append(", destClusterName=");
        sb.append(this.destClusterName);
        sb.append(", destSystemId=");
        sb.append(this.destSystemId);
        sb.append(", destEsmeId=");
        sb.append(this.destEsmeName);
        sb.append(", imsi=");
        sb.append(this.imsi);
        sb.append(", locationInfoWithLMSI=");
        sb.append(this.locationInfoWithLMSI);
        sb.append(", correlationId=");
        sb.append(this.correlationId);
        sb.append(", inSystem=");
        sb.append(this.inSystem);
        sb.append(", inSystemDate=");
        sb.append(this.inSystemDate);
        sb.append(", dueDate=");
        sb.append(this.dueDate);
        sb.append(", dueDelay=");
        sb.append(this.dueDelay);
        sb.append(", status=");
        sb.append((Object)this.status);
        sb.append(", type=");
        sb.append((Object)this.type);
        sb.append(", lastDelivery=");
        sb.append(this.lastDelivery);
        sb.append(", alertingSupported=");
        sb.append(this.alertingSupported);
        sb.append(", markedSmsAsDelivered=");
        sb.append(this.markedSmsAsDelivered);
        sb.append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.destAddrTon;
        result = 31 * result + this.destAddrNpi;
        result = 31 * result + this.networkId;
        result = 31 * result + (this.destAddr == null ? 0 : this.destAddr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SmsSet other = (SmsSet)obj;
        if (this.destAddrTon != other.destAddrTon) {
            return false;
        }
        if (this.destAddrNpi != other.destAddrNpi) {
            return false;
        }
        if (this.networkId != other.networkId) {
            return false;
        }
        return !(this.destAddr == null ? other.destAddr != null : !this.destAddr.equals(other.destAddr));
    }

    public class Segment {
        protected long cnt;
        protected ArrayList<Sms> smsList = new ArrayList();
    }

    public class SmsComparator
    implements Comparator<Sms> {
        @Override
        public int compare(Sms a1, Sms a2) {
            if (a1.getMessageId() == a2.getMessageId()) {
                return 0;
            }
            if (a1.getMessageId() < a2.getMessageId()) {
                return -1;
            }
            return 1;
        }
    }
}

