/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.library;

import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.tlv.TlvConvertException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import org.mobicents.protocols.ss7.indicator.GlobalTitleIndicator;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.NumberingPlan;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.map.api.datacoding.NationalLanguageIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.api.smstpdu.ConcatenatedShortMessagesIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeader;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeaderElement;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.smstpdu.NationalLanguageLockingShiftIdentifierImpl;
import org.mobicents.protocols.ss7.map.smstpdu.NationalLanguageSingleShiftIdentifierImpl;
import org.mobicents.protocols.ss7.map.smstpdu.UserDataHeaderImpl;
import org.mobicents.protocols.ss7.map.smstpdu.UserDataImpl;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0001;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmscProcessingException;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.mproc.DeliveryReceiptData;
import org.mobicents.smsc.mproc.impl.DeliveryReceiptDataImpl;
import org.mobicents.smsc.smpp.GenerateType;

public class MessageUtil {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyy-mm-dd hh:mm:ss");
    public static final String DELIVERY_ACK_ID = "id:";
    public static final String DELIVERY_ACK_SUB = " sub:";
    public static final String DELIVERY_ACK_DLVRD = " dlvrd:";
    public static final String DELIVERY_ACK_SUBMIT_DATE = " submit date:";
    public static final String DELIVERY_ACK_DONE_DATE = " done date:";
    public static final String DELIVERY_ACK_STAT = " stat:";
    public static final String DELIVERY_ACK_ERR = " err:";
    public static final String DELIVERY_ACK_TEXT = " text:";
    public static final String DELIVERY_ACK_STATE_DELIVERED = "DELIVRD";
    public static final String DELIVERY_ACK_STATE_UNDELIVERABLE = "UNDELIV";
    public static final String DELIVERY_ACK_STATE_ENROUTE = "ENROUTE";
    public static final byte ESME_DELIVERY_ACK = 4;
    public static final SimpleDateFormat DELIVERY_ACK_DATE_FORMAT = new SimpleDateFormat("yyMMddHHmm");

    public static String stackTraceToString() {
        StringBuilder sb = new StringBuilder();
        Thread thread = Thread.currentThread();
        StackTraceElement[] arr = thread.getStackTrace();
        if (arr != null) {
            for (int i1 = 2; i1 < arr.length; ++i1) {
                StackTraceElement element = arr[i1];
                sb.append(element.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static Date parseDate(String val) throws ParseException {
        return DATE_FORMAT.parse(val);
    }

    public static String formatDate(Date val) throws ParseException {
        return DATE_FORMAT.format(val);
    }

    public static Date parseSmppDate(String val) throws ParseException {
        Date res;
        if (val == null || val.length() == 0) {
            return null;
        }
        if (val.length() != 16) {
            throw new ParseException("Absolute or relative time formats must be 16 characters length", 0);
        }
        char sign = val.charAt(15);
        if (sign == 'R') {
            String yrS = val.substring(0, 2);
            String mnS = val.substring(2, 4);
            String dyS = val.substring(4, 6);
            String hrS = val.substring(6, 8);
            String miS = val.substring(8, 10);
            String scS = val.substring(10, 12);
            int yr = Integer.parseInt(yrS);
            int mn = Integer.parseInt(mnS);
            int dy = Integer.parseInt(dyS);
            int hr = Integer.parseInt(hrS);
            int mi = Integer.parseInt(miS);
            int sc = Integer.parseInt(scS);
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(1, yr);
            c.add(2, mn);
            c.add(5, dy);
            c.add(10, hr);
            c.add(12, mi);
            c.add(13, sc);
            res = c.getTime();
        } else {
            String s2 = val.substring(12, 13);
            String s3 = val.substring(13, 15);
            String yrS = val.substring(0, 2);
            String mnS = val.substring(2, 4);
            String dyS = val.substring(4, 6);
            String hrS = val.substring(6, 8);
            String miS = val.substring(8, 10);
            String scS = val.substring(10, 12);
            int yr = Integer.parseInt(yrS);
            int mn = Integer.parseInt(mnS);
            int dy = Integer.parseInt(dyS);
            int hr = Integer.parseInt(hrS);
            int mi = Integer.parseInt(miS);
            int sc = Integer.parseInt(scS);
            Date date = new Date(yr + 100, mn - 1, dy, hr, mi, sc);
            int dSec = Integer.parseInt(s2);
            int tZone = Integer.parseInt(s3);
            int curTimezoneOffset = date.getTimezoneOffset();
            switch (sign) {
                case '+': {
                    res = new Date(date.getTime() + (long)(dSec * 100) - (long)(tZone * 15 * 60 * 1000) - (long)(curTimezoneOffset * 60 * 1000));
                    break;
                }
                case '-': {
                    res = new Date(date.getTime() + (long)(dSec * 100) + (long)(tZone * 15 * 60 * 1000) - (long)(curTimezoneOffset * 60 * 1000));
                    break;
                }
                case 'R': {
                    res = new Date(new Date().getTime() + date.getTime() + (long)(dSec * 100));
                    break;
                }
                default: {
                    throw new ParseException("16-th character must be '+' or '-' for absolute time format or 'R' for relative time format", 16);
                }
            }
        }
        return res;
    }

    public static String printSmppAbsoluteDate(Date date, int timezoneOffset) {
        char sign;
        StringBuilder sb = new StringBuilder();
        int year = date.getYear() - 100;
        int month = date.getMonth() + 1;
        int day = date.getDate();
        int hour = date.getHours();
        int min = date.getMinutes();
        int sec = date.getSeconds();
        Date d1 = new Date(year + 100, month - 1, day, hour, min, sec);
        int tSec = (int)(date.getTime() - d1.getTime()) / 100;
        MessageUtil.addDateToStringBuilder(sb, year, month, day, hour, min, sec);
        if (tSec > 9) {
            tSec = 9;
        }
        if (tSec < 0) {
            tSec = 0;
        }
        sb.append(tSec);
        int tz = timezoneOffset / 15;
        if (tz < 0) {
            sign = '-';
            tz = -tz;
        } else {
            sign = '+';
        }
        if (tz < 10) {
            sb.append("0");
        }
        sb.append(tz);
        sb.append(sign);
        return sb.toString();
    }

    public static String printSmppRelativeDate(int years, int months, int days, int hours, int minutes, int seconds) {
        StringBuilder sb = new StringBuilder();
        MessageUtil.addDateToStringBuilder(sb, years, months, days, hours, minutes, seconds);
        sb.append("000R");
        return sb.toString();
    }

    public static void applyValidityPeriod(Sms sms, Date validityPeriod, boolean fromEsme, int maxValidityPeriodHours, int defaultValidityPeriodHours) throws SmscProcessingException {
        Date maxValidityPeriod;
        Date now = new Date();
        if (validityPeriod == null) {
            validityPeriod = MessageUtil.addHours(now, defaultValidityPeriodHours);
        }
        if (validityPeriod.after(maxValidityPeriod = MessageUtil.addHours(now, maxValidityPeriodHours))) {
            validityPeriod = maxValidityPeriod;
        }
        if (validityPeriod.before(now)) {
            validityPeriod = maxValidityPeriod;
        }
        sms.setValidityPeriod(validityPeriod);
    }

    public static void applyScheduleDeliveryTime(Sms sms, Date scheduleDeliveryTime) throws SmscProcessingException {
        if (scheduleDeliveryTime == null) {
            return;
        }
        Date maxSchDelTime = MessageUtil.addHours(sms.getValidityPeriod(), -3);
        if (scheduleDeliveryTime.after(maxSchDelTime)) {
            throw new SmscProcessingException("Schedule delivery time is before 3 hours before than validity period expiration", 97, 34, null);
        }
        sms.setScheduleDeliveryTime(scheduleDeliveryTime);
    }

    public static Date addHours(Date time, int hours) {
        long tm = time.getTime();
        return new Date(tm += (long)(hours * 3600 * 1000));
    }

    public static int computeFirstDueDelay(int firstDueDelay) {
        return firstDueDelay;
    }

    public static int computeNextDueDelay(int prevDueDelay, int secondDueDelay, int dueDelayMultiplicator, int maxDueDelay) {
        if (prevDueDelay == 0) {
            return secondDueDelay;
        }
        int res = prevDueDelay * dueDelayMultiplicator / 100;
        if (res > maxDueDelay) {
            res = maxDueDelay;
        }
        return res;
    }

    public static int computeDueDelaySubscriberBusy(int subscriberBusyDueDelay) {
        return subscriberBusyDueDelay;
    }

    public static Date computeDueDate(int dueDelay) {
        Date d = new Date(System.currentTimeMillis() + (long)(dueDelay * 1000));
        return d;
    }

    public static int getMaxSolidMessageBytesLength(DataCodingScheme dataCodingScheme) {
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
            return 160;
        }
        return 140;
    }

    public static int getMaxSegmentedMessageBytesLength(DataCodingScheme dataCodingScheme) {
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
            return 152;
        }
        return 132;
    }

    public static int getMaxSolidMessageCharsLength(DataCodingScheme dataCodingScheme) {
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
            return 160;
        }
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM8) {
            return 140;
        }
        return 70;
    }

    public static int getMaxSegmentedMessageCharsLength(DataCodingScheme dataCodingScheme) {
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
            return 152;
        }
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM8) {
            return 132;
        }
        return 66;
    }

    public static int getMaxSolidMessageBytesLength() {
        return 140;
    }

    public static int getMaxSegmentedMessageBytesLength() {
        return 132;
    }

    public static UserDataHeader getNationalLanguageIdentifierUdh(int nationalLanguageLockingShift, int nationalLanguageSingleShift) {
        UserDataHeaderImpl udh = null;
        if (nationalLanguageSingleShift > 0 || nationalLanguageLockingShift > 0) {
            NationalLanguageSingleShiftIdentifierImpl informationElement;
            NationalLanguageIdentifier nli;
            udh = new UserDataHeaderImpl();
            if (nationalLanguageSingleShift > 0) {
                nli = NationalLanguageIdentifier.getInstance((int)nationalLanguageSingleShift);
                informationElement = new NationalLanguageSingleShiftIdentifierImpl(nli);
                udh.addInformationElement((UserDataHeaderElement)informationElement);
            }
            if (nationalLanguageLockingShift > 0) {
                nli = NationalLanguageIdentifier.getInstance((int)nationalLanguageLockingShift);
                informationElement = new NationalLanguageLockingShiftIdentifierImpl(nli);
                udh.addInformationElement((UserDataHeaderElement)informationElement);
            }
        }
        return udh;
    }

    public static int getMessageLengthInBytes(DataCodingScheme dataCodingScheme, String msg, UserDataHeader udh) {
        int charCount = msg.length();
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM7) {
            int msgLenInChars = UserDataImpl.checkEncodedDataLengthInChars((String)msg, (UserDataHeader)udh);
            return GSMCharset.septetsToOctets((int)msgLenInChars);
        }
        if (dataCodingScheme.getCharacterSet() == CharacterSet.GSM8) {
            return charCount;
        }
        return charCount * 2;
    }

    private static void addDateToStringBuilder(StringBuilder sb, int year, int month, int day, int hour, int min, int sec) {
        if (year < 10) {
            sb.append("0");
        }
        sb.append(year);
        if (month < 10) {
            sb.append("0");
        }
        sb.append(month);
        if (day < 10) {
            sb.append("0");
        }
        sb.append(day);
        if (hour < 10) {
            sb.append("0");
        }
        sb.append(hour);
        if (min < 10) {
            sb.append("0");
        }
        sb.append(min);
        if (sec < 10) {
            sb.append("0");
        }
        sb.append(sec);
    }

    public static Date checkScheduleDeliveryTime(ArrayList<Sms> lstTempFailured, Date newDueDate) {
        Date minDate = null;
        for (Sms sms : lstTempFailured) {
            if (sms.getScheduleDeliveryTime() != null) {
                if (minDate == null) {
                    minDate = sms.getScheduleDeliveryTime();
                    continue;
                }
                if (!minDate.after(sms.getScheduleDeliveryTime())) continue;
                minDate = sms.getScheduleDeliveryTime();
                continue;
            }
            if (minDate != null) continue;
            minDate = newDueDate;
        }
        if (minDate != null && newDueDate.before(minDate)) {
            newDueDate = minDate;
        }
        return newDueDate;
    }

    public static String checkDataCodingSchemeSupport(int dcs) {
        DataCodingSchemeImpl dataCodingScheme = new DataCodingSchemeImpl(dcs);
        if (dataCodingScheme.getCharacterSet() != CharacterSet.GSM7 && dataCodingScheme.getCharacterSet() != CharacterSet.UCS2 && dataCodingScheme.getCharacterSet() != CharacterSet.GSM8) {
            return "Only GSM7, GSM8 and USC2 are supported";
        }
        if (dataCodingScheme.getIsCompressed()) {
            return "Compressed message are not supported";
        }
        return null;
    }

    public static boolean isReceiptOnSuccess(int registeredDelivery) {
        int code = registeredDelivery & 3;
        return code == 1 || code == 3;
    }

    public static boolean isReceiptOnFailure(int registeredDelivery) {
        int code = registeredDelivery & 3;
        return code == 1 || code == 2;
    }

    public static boolean isReceiptIntermediate(int registeredDelivery) {
        int code = registeredDelivery & 0x10;
        return code == 16;
    }

    public static Sms createReceiptSms(Sms sms, boolean delivered, TargetAddress ta, boolean origNetworkIdForReceipts, String extraString) {
        return MessageUtil.createReceiptSms(sms, delivered, ta, origNetworkIdForReceipts, extraString, false);
    }

    public static Sms createReceiptSms(Sms sms, boolean delivered, TargetAddress ta, boolean origNetworkIdForReceipts) {
        return MessageUtil.createReceiptSms(sms, delivered, ta, origNetworkIdForReceipts, null, false);
    }

    public static Sms createReceiptSms(Sms sms, boolean delivered, TargetAddress ta, boolean origNetworkIdForReceipts, String extraString, boolean tempFailure) {
        Sms receipt = MessageUtil.createReceiptSms(sms, delivered, extraString, tempFailure);
        SmsSet backSmsSet = new SmsSet();
        backSmsSet.setDestAddr(ta.getAddr());
        backSmsSet.setDestAddrNpi(ta.getAddrNpi());
        backSmsSet.setDestAddrTon(ta.getAddrTon());
        if (origNetworkIdForReceipts) {
            backSmsSet.setNetworkId(sms.getOrigNetworkId());
        } else {
            backSmsSet.setNetworkId(sms.getSmsSet().getNetworkId());
        }
        backSmsSet.addSms(receipt);
        return receipt;
    }

    public static Sms createReceiptSms(Sms sms, boolean delivered) {
        return MessageUtil.createReceiptSms(sms, delivered, null);
    }

    public static Sms createReceiptSms(Sms sms, boolean delivered, String extraString) {
        return MessageUtil.createReceiptSms(sms, delivered, extraString, false);
    }

    public static Sms createReceiptSms(Sms sms, boolean delivered, String extraString, boolean tempFailure) {
        Sms receipt = new Sms();
        receipt.setDbId(UUID.randomUUID());
        receipt.setSourceAddr(sms.getSmsSet().getDestAddr());
        receipt.setSourceAddrNpi(sms.getSmsSet().getDestAddrNpi());
        receipt.setSourceAddrTon(sms.getSmsSet().getDestAddrTon());
        receipt.setSubmitDate(sms.getSubmitDate());
        receipt.setMessageId(sms.getMessageId());
        Date validityPeriod = MessageUtil.addHours(new Date(), 24);
        receipt.setValidityPeriod(validityPeriod);
        String rcpt = MessageUtil.createDeliveryReceiptMessage(sms.getMessageIdText(), sms.getSubmitDate(), new Timestamp(System.currentTimeMillis()), sms.getSmsSet().getStatus(), sms.getShortMessageText(), delivered, extraString, tempFailure);
        receipt.setDataCoding(0);
        receipt.setShortMessageText(rcpt);
        receipt.setEsmClass(4 | sms.getEsmClass() & 3);
        return receipt;
    }

    public static String createDeliveryReceiptMessage(String messageId, Date submitDate, Date deliveryDate, ErrorCode errorCode, String origMsgText, boolean delivered, String extraString, boolean tempFailure) {
        StringBuffer sb = new StringBuffer();
        sb.append(DELIVERY_ACK_ID);
        sb.append(messageId);
        sb.append(DELIVERY_ACK_SUB);
        sb.append("001");
        sb.append(DELIVERY_ACK_DLVRD);
        if (delivered) {
            sb.append("001");
        } else {
            sb.append("000");
        }
        sb.append(DELIVERY_ACK_SUBMIT_DATE);
        sb.append(DELIVERY_ACK_DATE_FORMAT.format(submitDate));
        sb.append(DELIVERY_ACK_DONE_DATE);
        sb.append(DELIVERY_ACK_DATE_FORMAT.format(deliveryDate));
        sb.append(DELIVERY_ACK_STAT);
        if (delivered) {
            sb.append(DELIVERY_ACK_STATE_DELIVERED);
            sb.append(DELIVERY_ACK_ERR);
            sb.append("000");
        } else {
            if (!tempFailure) {
                sb.append(DELIVERY_ACK_STATE_UNDELIVERABLE);
            } else {
                sb.append(DELIVERY_ACK_STATE_ENROUTE);
            }
            sb.append(DELIVERY_ACK_ERR);
            sb.append(errorCode != null ? errorCode.getCodeText() : "null");
        }
        sb.append(DELIVERY_ACK_TEXT);
        sb.append(MessageUtil.getFirst20CharOfSMS(origMsgText));
        if (extraString != null) {
            sb.append(extraString);
        }
        return sb.toString();
    }

    public static String createMessageIdString(long messageId) {
        return String.format("%010d", messageId);
    }

    private static String getFirst20CharOfSMS(String first20CharOfSms) {
        if (first20CharOfSms == null) {
            return "";
        }
        if (first20CharOfSms.length() > 20) {
            first20CharOfSms = first20CharOfSms.substring(0, 20);
        }
        return first20CharOfSms;
    }

    public static boolean isDeliveryReceipt(Sms sms) {
        int esmeClass = sms.getEsmClass();
        int messageType = esmeClass & 0x3C;
        return messageType == 4;
    }

    public static boolean isDeliveryReceiptRequest(Sms sms) {
        int registeredDelivery = sms.getRegisteredDelivery();
        int receiptRequest = registeredDelivery & 0x13;
        return receiptRequest != 0;
    }

    public static DeliveryReceiptData parseDeliveryReceipt(String msg) {
        if (msg == null || msg.length() < 102) {
            return null;
        }
        DeliveryReceiptDataImpl deliveryReceiptData = new DeliveryReceiptDataImpl();
        String idKey = msg.substring(0, 3);
        String idVal = msg.substring(3, 13);
        String submittedKey = msg.substring(13, 18);
        String submittedVal = msg.substring(18, 21);
        String deliveredKey = msg.substring(21, 28);
        String deliveredVal = msg.substring(28, 31);
        String submitDateKey = msg.substring(31, 44);
        String submitDateVal = msg.substring(44, 54);
        String doneDateKey = msg.substring(54, 65);
        String doneDateVal = msg.substring(65, 75);
        String statusKey = msg.substring(75, 81);
        String statusVal = msg.substring(81, 88);
        String errorKey = msg.substring(88, 93);
        String errorVal = msg.substring(93, 96);
        String textKey = msg.substring(96, 102);
        String textVal = msg.substring(102);
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmm");
        if (idKey.equals(DELIVERY_ACK_ID)) {
            try {
                deliveryReceiptData.setMessageId(idVal);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (submittedKey.equals(DELIVERY_ACK_SUB)) {
            try {
                int msgSubmitted = Integer.parseInt(submittedVal);
                deliveryReceiptData.setMsgSubmitted(msgSubmitted);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (deliveredKey.equals(DELIVERY_ACK_DLVRD)) {
            try {
                int msgDelivered = Integer.parseInt(deliveredVal);
                deliveryReceiptData.setMsgDelivered(msgDelivered);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (submitDateKey.equals(DELIVERY_ACK_SUBMIT_DATE)) {
            try {
                Date submitDate = sdf.parse(submitDateVal);
                deliveryReceiptData.setSubmitDate(submitDate);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (doneDateKey.equals(DELIVERY_ACK_DONE_DATE)) {
            try {
                Date doneDate = sdf.parse(doneDateVal);
                deliveryReceiptData.setDoneDate(doneDate);
            }
            catch (ParseException e) {
                // empty catch block
            }
        }
        if (statusKey.equals(DELIVERY_ACK_STAT)) {
            deliveryReceiptData.setStatus(statusVal);
        }
        if (errorKey.equals(DELIVERY_ACK_ERR)) {
            try {
                int error = Integer.parseInt(errorVal);
                deliveryReceiptData.setError(error);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (textKey.toLowerCase().equals(DELIVERY_ACK_TEXT)) {
            deliveryReceiptData.setText(textVal);
        }
        return deliveryReceiptData;
    }

    public static void createNewSmsSetForSms(Sms sms) {
        SmsSet smsSet = new SmsSet();
        smsSet.setDestAddr(sms.getSmsSet().getDestAddr());
        smsSet.setDestAddrNpi(sms.getSmsSet().getDestAddrNpi());
        smsSet.setDestAddrTon(sms.getSmsSet().getDestAddrTon());
        smsSet.setCorrelationId(sms.getSmsSet().getCorrelationId());
        smsSet.setNetworkId(sms.getSmsSet().getNetworkId());
        smsSet.addSms(sms);
    }

    public static boolean isSmsNotLastSegment(Sms sms) {
        boolean isPartial = false;
        Tlv sarMsgRefNum = sms.getTlvSet().getOptionalParameter((short)524);
        Tlv sarTotalSegments = sms.getTlvSet().getOptionalParameter((short)526);
        Tlv sarSegmentSeqnum = sms.getTlvSet().getOptionalParameter((short)527);
        if ((sms.getEsmClass() & 0x40) != 0) {
            int udhLen;
            byte[] shortMessage = sms.getShortMessageBin();
            if (shortMessage != null && shortMessage.length > 2 && (udhLen = (shortMessage[0] & 0xFF) + 1) <= shortMessage.length) {
                byte[] udhData = new byte[udhLen];
                System.arraycopy(shortMessage, 0, udhData, 0, udhLen);
                UserDataHeaderImpl userDataHeader = new UserDataHeaderImpl(udhData);
                ConcatenatedShortMessagesIdentifier csm = userDataHeader.getConcatenatedShortMessagesIdentifier();
                if (csm != null) {
                    int mSCount = csm.getMesageSegmentCount();
                    int mSNumber = csm.getMesageSegmentNumber();
                    if (mSNumber < mSCount) {
                        isPartial = true;
                    }
                }
            }
        } else if (sarMsgRefNum != null && sarTotalSegments != null && sarSegmentSeqnum != null) {
            try {
                short mSCount = sarTotalSegments.getValueAsUnsignedByte();
                short mSNumber = sarSegmentSeqnum.getValueAsUnsignedByte();
                if (mSNumber < mSCount) {
                    isPartial = true;
                }
            }
            catch (TlvConvertException e) {
                // empty catch block
            }
        }
        return isPartial;
    }

    public static boolean isStoreAndForward(Sms sms) {
        int messagingMode = sms.getEsmClass() & 3;
        return messagingMode == 0 || messagingMode == 3;
    }

    public static boolean isTransactional(Sms sms) {
        int messagingMode = sms.getEsmClass() & 3;
        return messagingMode == 2;
    }

    public static boolean isNeedWriteArchiveMessage(Sms sms, GenerateType generateType) {
        if (MessageUtil.isStoreAndForward(sms)) {
            return generateType.isStoreAndForward();
        }
        if (MessageUtil.isTransactional(sms)) {
            return generateType.isTransactional();
        }
        return generateType.isDatagramm();
    }

    public static NumberingPlan getSccpNumberingPlan(int npi) {
        NumberingPlan np = NumberingPlan.ISDN_TELEPHONY;
        switch (npi) {
            case 1: {
                np = NumberingPlan.ISDN_TELEPHONY;
            }
        }
        return np;
    }

    public static NatureOfAddress getSccpNatureOfAddress(int ton) {
        NatureOfAddress na = NatureOfAddress.INTERNATIONAL;
        switch (ton) {
            case 1: {
                na = NatureOfAddress.INTERNATIONAL;
                break;
            }
            case 2: {
                na = NatureOfAddress.NATIONAL;
            }
        }
        return na;
    }

    public static SccpAddress getSccpAddress(ParameterFactory sccpParameterFact, String address, int ton, int npi, int ssn, GlobalTitleIndicator gti, int translationType) {
        GlobalTitle0001 gt;
        NumberingPlan np = MessageUtil.getSccpNumberingPlan(npi);
        NatureOfAddress na = MessageUtil.getSccpNatureOfAddress(ton);
        switch (gti) {
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_ENCODING_SCHEME_AND_NATURE_OF_ADDRESS: {
                gt = sccpParameterFact.createGlobalTitle(address, translationType, np, null, na);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_NUMBERING_PLAN_AND_ENCODING_SCHEME: {
                gt = sccpParameterFact.createGlobalTitle(address, translationType, np, null);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_NATURE_OF_ADDRESS_INDICATOR_ONLY: {
                gt = sccpParameterFact.createGlobalTitle(address, na);
                break;
            }
            case GLOBAL_TITLE_INCLUDES_TRANSLATION_TYPE_ONLY: {
                gt = sccpParameterFact.createGlobalTitle(address, translationType);
                break;
            }
            default: {
                gt = sccpParameterFact.createGlobalTitle(address, translationType, np, null, na);
            }
        }
        return sccpParameterFact.createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, (GlobalTitle)gt, 0, ssn);
    }
}

