/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.library;

import java.util.EnumSet;

public enum MessageState {
    SCHEDULED(0),
    ENROUTE(1),
    DELIVERED(2),
    EXPIRED(3),
    DELETED(4),
    UNDELIVERABLE(5),
    ACCEPTED(6),
    UNKNOWN(7),
    REJECTED(8),
    SKIPPED(9);

    private int code;
    private static final EnumSet<MessageState> ENUM_SET;

    private MessageState(int v) {
        this.code = v;
    }

    public int getCode() {
        return this.code;
    }

    public static MessageState fromInt(int code) {
        for (MessageState el : ENUM_SET) {
            if (el.code != code) continue;
            return el;
        }
        throw new IllegalArgumentException("The '" + code + "' is not a valid value!");
    }

    static {
        ENUM_SET = EnumSet.allOf(MessageState.class);
    }
}

