/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.library;

import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;
import org.mobicents.smsc.library.Sms;

public class CdrGenerator {
    private static final Logger logger = Logger.getLogger(CdrGenerator.class);
    public static final String CDR_SEPARATOR = ",";
    public static final String CDR_SUCCESS = "success";
    public static final String CDR_PARTIAL = "partial";
    public static final String CDR_FAILED = "failed";
    public static final String CDR_FAILED_IMSI = "failed_imsi";
    public static final String CDR_TEMP_FAILED = "temp_failed";
    public static final String CDR_OCS_REJECTED = "ocs_rejected";
    public static final String CDR_MPROC_REJECTED = "mproc_rejected";
    public static final String CDR_MPROC_DROPPED = "mproc_dropped";
    public static final String CDR_MPROC_DROP_PRE_DELIVERY = "mproc_drop_pre_delivery";
    public static final String CDR_SUCCESS_ESME = "success_esme";
    public static final String CDR_PARTIAL_ESME = "partial_esme";
    public static final String CDR_FAILED_ESME = "failed_esme";
    public static final String CDR_TEMP_FAILED_ESME = "temp_failed_esme";
    public static final String CDR_SUCCESS_SIP = "success_sip";
    public static final String CDR_PARTIAL_SIP = "partial_sip";
    public static final String CDR_FAILED_SIP = "failed_sip";
    public static final String CDR_TEMP_FAILED_SIP = "temp_failed_sip";
    public static final String CDR_SUCCESS_NO_REASON = "";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS Z");

    public static void generateCdr(String message) {
        logger.debug((Object)message);
    }

    public static void generateCdr(Sms smsEvent, String status, String reason, boolean generateReceiptCdr, boolean generateCdr) {
        if (!generateCdr) {
            return;
        }
        if (!generateReceiptCdr && smsEvent.isMcDeliveryReceipt()) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(DATE_FORMAT.format(smsEvent.getSubmitDate())).append(CDR_SEPARATOR).append(smsEvent.getSourceAddr()).append(CDR_SEPARATOR).append(smsEvent.getSourceAddrTon()).append(CDR_SEPARATOR).append(smsEvent.getSourceAddrNpi()).append(CDR_SEPARATOR).append(smsEvent.getSmsSet().getDestAddr()).append(CDR_SEPARATOR).append(smsEvent.getSmsSet().getDestAddrTon()).append(CDR_SEPARATOR).append(smsEvent.getSmsSet().getDestAddrNpi()).append(CDR_SEPARATOR).append(status).append(CDR_SEPARATOR).append(smsEvent.getOrigSystemId()).append(CDR_SEPARATOR).append(smsEvent.getMessageId()).append(CDR_SEPARATOR).append(smsEvent.getSmsSet().getLocationInfoWithLMSI() != null ? smsEvent.getSmsSet().getLocationInfoWithLMSI().getNetworkNodeNumber().getAddress() : null).append(CDR_SEPARATOR).append(smsEvent.getSmsSet().getImsi()).append(CDR_SEPARATOR).append(smsEvent.getSmsSet().getCorrelationId()).append(CDR_SEPARATOR).append(CdrGenerator.getFirst20CharOfSMS(smsEvent.getShortMessageText())).append(CDR_SEPARATOR).append(reason);
        CdrGenerator.generateCdr(sb.toString());
    }

    private static String getFirst20CharOfSMS(String first20CharOfSms) {
        if (first20CharOfSms == null) {
            return CDR_SUCCESS_NO_REASON;
        }
        if (first20CharOfSms.length() > 20) {
            first20CharOfSms = first20CharOfSms.substring(0, 20);
        }
        return first20CharOfSms;
    }
}

