/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.cassandra;

import com.datastax.driver.core.PreparedStatement;
import org.mobicents.smsc.cassandra.DBOperations;

public class PreparedStatementCollection {
    private DBOperations dbOperation;
    private String tName;
    private boolean shortMessageNewStringFormat;
    private boolean addedCorrId;
    private boolean addedNetworkId;
    private boolean addedOrigNetworkId;
    private boolean addedPacket1;
    protected PreparedStatement createDueSlotForTargetId;
    protected PreparedStatement getDueSlotForTargetId;
    protected PreparedStatement createRecordCurrent;
    protected PreparedStatement getRecordData;
    protected PreparedStatement getRecordData2;
    protected PreparedStatement updateInSystem;
    protected PreparedStatement updateAlertingSupport;
    protected PreparedStatement createRecordArchive;
    protected PreparedStatement createRecordArchiveMesId;
    protected PreparedStatement getRecordArchiveMesId;
    protected PreparedStatement createRecordArchiveDlvMesId;
    protected PreparedStatement getRecordArchiveDlvMesId;
    protected PreparedStatement getRecordArchive;

    public PreparedStatementCollection(DBOperations dbOperation, String tName, int ttlCurrent, int ttlArchive) {
        String s1;
        this.dbOperation = dbOperation;
        this.tName = tName;
        try {
            this.shortMessageNewStringFormat = false;
            s1 = "select \"MESSAGE_TEXT\" FROM \"SLOT_MESSAGES_TABLE" + tName + "\" limit 1;";
            dbOperation.session.execute(s1);
            this.shortMessageNewStringFormat = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.addedCorrId = false;
            s1 = "select \"CORR_ID\" FROM \"SLOT_MESSAGES_TABLE" + tName + "\" limit 1;";
            dbOperation.session.execute(s1);
            this.addedCorrId = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.addedNetworkId = false;
            s1 = "select \"NETWORK_ID\" FROM \"SLOT_MESSAGES_TABLE" + tName + "\" limit 1;";
            dbOperation.session.execute(s1);
            this.addedNetworkId = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.addedOrigNetworkId = false;
            s1 = "select \"ORIG_NETWORK_ID\" FROM \"SLOT_MESSAGES_TABLE" + tName + "\" limit 1;";
            dbOperation.session.execute(s1);
            this.addedOrigNetworkId = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.addedPacket1 = false;
            s1 = "select \"ORIGINATOR_SCCP_ADDRESS\" FROM \"SLOT_MESSAGES_TABLE" + tName + "\" limit 1;";
            dbOperation.session.execute(s1);
            this.addedPacket1 = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            s1 = this.getFillUpdateFields();
            String s11 = this.getFillUpdateFields_Archive();
            String s2 = this.getFillUpdateFields2();
            String s22 = this.getFillUpdateFields2_Archive();
            String s3a = ttlCurrent > 0 ? "USING TTL " + ttlCurrent : "";
            String s3b = ttlArchive > 0 ? "USING TTL " + ttlArchive : "";
            String sa = "INSERT INTO \"DST_SLOT_TABLE" + tName + "\" (\"" + "TARGET_ID" + "\", \"" + "DUE_SLOT" + "\") VALUES (?, ?) " + s3a + ";";
            this.createDueSlotForTargetId = dbOperation.session.prepare(sa);
            sa = "SELECT \"DUE_SLOT\" FROM \"DST_SLOT_TABLE" + tName + "\" where \"" + "TARGET_ID" + "\"=?;";
            this.getDueSlotForTargetId = dbOperation.session.prepare(sa);
            sa = "INSERT INTO \"SLOT_MESSAGES_TABLE" + tName + "\" (" + s1 + ") VALUES (" + s2 + ") " + s3a + ";";
            this.createRecordCurrent = dbOperation.session.prepare(sa);
            sa = "SELECT * FROM \"SLOT_MESSAGES_TABLE" + tName + "\" where \"" + "DUE_SLOT" + "\"=?;";
            this.getRecordData = dbOperation.session.prepare(sa);
            sa = "SELECT * FROM \"SLOT_MESSAGES_TABLE" + tName + "\" where \"" + "DUE_SLOT" + "\"=? and \"" + "TARGET_ID" + "\"=?;";
            this.getRecordData2 = dbOperation.session.prepare(sa);
            sa = "UPDATE \"SLOT_MESSAGES_TABLE" + tName + "\" " + s3a + " SET \"" + "IN_SYSTEM" + "\"=?, \"" + "SMSC_UUID" + "\"=? where \"" + "DUE_SLOT" + "\"=? and \"" + "TARGET_ID" + "\"=? and \"" + "ID" + "\"=?;";
            this.updateInSystem = dbOperation.session.prepare(sa);
            sa = "UPDATE \"SLOT_MESSAGES_TABLE" + tName + "\" " + s3a + " SET \"" + "ALERTING_SUPPORTED" + "\"=? where \"" + "DUE_SLOT" + "\"=? and \"" + "TARGET_ID" + "\"=? and \"" + "ID" + "\"=?;";
            this.updateAlertingSupport = dbOperation.session.prepare(sa);
            sa = "INSERT INTO \"MESSAGES" + tName + "\" (" + s1 + s11 + ") VALUES (" + s2 + s22 + ") " + s3b + ";";
            this.createRecordArchive = dbOperation.session.prepare(sa);
            sa = "INSERT INTO \"MES_ID" + tName + "\" (\"" + "MESSAGE_ID" + "\", \"" + "ADDR_DST_DIGITS" + "\", \"" + "ID" + "\") VALUES (?, ?, ?);";
            this.createRecordArchiveMesId = dbOperation.session.prepare(sa);
            sa = "SELECT \"ADDR_DST_DIGITS\", \"ID\" FROM \"MES_ID" + tName + "\" where \"" + "MESSAGE_ID" + "\"=?;";
            this.getRecordArchiveMesId = dbOperation.session.prepare(sa);
            sa = "INSERT INTO \"DLV_MES_ID" + tName + "\" (\"" + "REMOTE_MESSAGE_ID" + "\", \"" + "DEST_ID" + "\", \"" + "MESSAGE_ID" + "\") VALUES (?, ?, ?);";
            this.createRecordArchiveDlvMesId = dbOperation.session.prepare(sa);
            sa = "SELECT \"MESSAGE_ID\" FROM \"DLV_MES_ID" + tName + "\" where \"" + "REMOTE_MESSAGE_ID" + "\"=? and \"" + "DEST_ID" + "\"=?;";
            this.getRecordArchiveDlvMesId = dbOperation.session.prepare(sa);
            sa = "SELECT * FROM \"MESSAGES" + tName + "\" where \"" + "ADDR_DST_DIGITS" + "\"=? and \"" + "ID" + "\"=?;";
            this.getRecordArchive = dbOperation.session.prepare(sa);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String getTName() {
        return this.tName;
    }

    public boolean getShortMessageNewStringFormat() {
        return this.shortMessageNewStringFormat;
    }

    public boolean getAddedCorrId() {
        return this.addedCorrId;
    }

    public boolean getAddedNetworkId() {
        return this.addedNetworkId;
    }

    public boolean getAddedOrigNetworkId() {
        return this.addedOrigNetworkId;
    }

    public boolean getAddedPacket1() {
        return this.addedPacket1;
    }

    private String getFillUpdateFields() {
        StringBuilder sb = new StringBuilder();
        sb.append("\"");
        sb.append("ID");
        sb.append("\", \"");
        sb.append("TARGET_ID");
        if (this.addedNetworkId) {
            sb.append("\", \"");
            sb.append("NETWORK_ID");
        }
        if (this.addedOrigNetworkId) {
            sb.append("\", \"");
            sb.append("ORIG_NETWORK_ID");
        }
        sb.append("\", \"");
        sb.append("DUE_SLOT");
        sb.append("\", \"");
        sb.append("IN_SYSTEM");
        sb.append("\", \"");
        sb.append("SMSC_UUID");
        sb.append("\", \"");
        sb.append("ADDR_DST_DIGITS");
        sb.append("\", \"");
        sb.append("ADDR_DST_TON");
        sb.append("\", \"");
        sb.append("ADDR_DST_NPI");
        sb.append("\", \"");
        sb.append("ADDR_SRC_DIGITS");
        sb.append("\", \"");
        sb.append("ADDR_SRC_TON");
        sb.append("\", \"");
        sb.append("ADDR_SRC_NPI");
        sb.append("\", \"");
        sb.append("DUE_DELAY");
        sb.append("\", \"");
        sb.append("SM_STATUS");
        sb.append("\", \"");
        sb.append("ALERTING_SUPPORTED");
        sb.append("\", \"");
        sb.append("MESSAGE_ID");
        sb.append("\", \"");
        sb.append("MO_MESSAGE_REF");
        sb.append("\", \"");
        sb.append("ORIG_ESME_NAME");
        sb.append("\", \"");
        sb.append("ORIG_SYSTEM_ID");
        sb.append("\", \"");
        sb.append("SUBMIT_DATE");
        sb.append("\", \"");
        sb.append("DELIVERY_DATE");
        sb.append("\", \"");
        sb.append("SERVICE_TYPE");
        sb.append("\", \"");
        sb.append("ESM_CLASS");
        sb.append("\", \"");
        sb.append("PROTOCOL_ID");
        sb.append("\", \"");
        sb.append("PRIORITY");
        sb.append("\", \"");
        sb.append("REGISTERED_DELIVERY");
        sb.append("\", \"");
        sb.append("REPLACE");
        sb.append("\", \"");
        sb.append("DATA_CODING");
        sb.append("\", \"");
        sb.append("DEFAULT_MSG_ID");
        sb.append("\", \"");
        sb.append("MESSAGE");
        sb.append("\", \"");
        if (this.shortMessageNewStringFormat) {
            sb.append("MESSAGE_TEXT");
            sb.append("\", \"");
            sb.append("MESSAGE_BIN");
            sb.append("\", \"");
        }
        sb.append("SCHEDULE_DELIVERY_TIME");
        sb.append("\", \"");
        sb.append("VALIDITY_PERIOD");
        sb.append("\", \"");
        sb.append("DELIVERY_COUNT");
        sb.append("\", \"");
        sb.append("OPTIONAL_PARAMETERS");
        sb.append("\", \"");
        sb.append("IMSI");
        if (this.addedCorrId) {
            sb.append("\", \"");
            sb.append("CORR_ID");
        }
        if (this.addedPacket1) {
            sb.append("\", \"");
            sb.append("ORIGINATOR_SCCP_ADDRESS");
            sb.append("\", \"");
            sb.append("STATUS_REPORT_REQUEST");
            sb.append("\", \"");
            sb.append("DELIVERY_ATTEMPT");
            sb.append("\", \"");
            sb.append("USER_DATA");
            sb.append("\", \"");
            sb.append("EXTRA_DATA");
            sb.append("\", \"");
            sb.append("EXTRA_DATA_2");
            sb.append("\", \"");
            sb.append("EXTRA_DATA_3");
            sb.append("\", \"");
            sb.append("EXTRA_DATA_4");
        }
        sb.append("\"");
        return sb.toString();
    }

    private String getFillUpdateFields_Archive() {
        StringBuilder sb = new StringBuilder();
        sb.append(", \"");
        sb.append("NNN_DIGITS");
        sb.append("\", \"");
        sb.append("NNN_AN");
        sb.append("\", \"");
        sb.append("NNN_NP");
        sb.append("\", \"");
        sb.append("SM_TYPE");
        sb.append("\"");
        return sb.toString();
    }

    private String getFillUpdateFields2() {
        int cnt = this.shortMessageNewStringFormat ? 36 : 34;
        if (this.addedCorrId) {
            ++cnt;
        }
        if (this.addedNetworkId) {
            ++cnt;
        }
        if (this.addedOrigNetworkId) {
            ++cnt;
        }
        if (this.addedPacket1) {
            cnt += 8;
        }
        StringBuilder sb = new StringBuilder();
        boolean i2 = false;
        for (int i1 = 0; i1 < cnt; ++i1) {
            if (!i2) {
                i2 = true;
            } else {
                sb.append(", ");
            }
            sb.append("?");
        }
        return sb.toString();
    }

    private String getFillUpdateFields2_Archive() {
        int cnt = 4;
        StringBuilder sb = new StringBuilder();
        for (int i1 = 0; i1 < cnt; ++i1) {
            sb.append(", ?");
        }
        return sb.toString();
    }
}

