/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.exceptions.InvalidQueryException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.map.api.smstpdu.CharacterSet;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.cassandra.PreparedStatementCollection;
import org.mobicents.smsc.cassandra.SmsRoutingRuleType;
import org.mobicents.smsc.library.DbSmsRoutingRule;
import org.mobicents.smsc.library.ErrorCode;
import org.mobicents.smsc.library.MessageState;
import org.mobicents.smsc.library.MessageUtil;
import org.mobicents.smsc.library.QuerySmResponse;
import org.mobicents.smsc.library.SmType;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.smpp.TlvSet;

public class DBOperations {
    private static final Logger logger = Logger.getLogger(DBOperations.class);
    public static final String TLV_SET = "tlvSet";
    public static final UUID emptyUuid = UUID.nameUUIDFromBytes(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    public static final int IN_SYSTEM_UNSENT = 0;
    public static final int IN_SYSTEM_INPROCESS = 1;
    public static final int IN_SYSTEM_SENT = 2;
    public static final int CURRENT_DUE_SLOT = 0;
    public static final int NEXT_MESSAGE_ID = 1;
    public static final int NEXT_CORRELATION_ID = 2;
    public static final long MAX_MESSAGE_ID = 10000000000L;
    public static final long MESSAGE_ID_LAG = 1000L;
    public static final long DUE_SLOT_WRITING_POSSIBILITY_DELAY = 10L;
    private static final DBOperations instance = new DBOperations();
    private Cluster cluster;
    protected Session session;
    private boolean multiTableModel = true;
    private int slotMSecondsTimeArea = 1000;
    private int dataTableDaysTimeArea = 1;
    private Date slotOrigDate = new Date(100, 0, 1);
    private int ttlCurrent = 0;
    private int ttlArchive = 0;
    private int millisecDueSlotWritingTimeout = 5000;
    private int dueSlotForwardStoring;
    private int dueSlotReviseOnSmscStart;
    private int processingSmsSetTimeout;
    private long currentDueSlot = 0L;
    private long messageId = 0L;
    private UUID currentSessionUUID;
    private FastMap<String, PreparedStatementCollection> dataTableRead = new FastMap();
    private FastMap<Long, DueSlotWritingElement> dueSlotWritingArray = new FastMap();
    private PreparedStatement selectCurrentSlotTable;
    private PreparedStatement updateCurrentSlotTable;
    private PreparedStatement getSmppSmsRoutingRule;
    private PreparedStatement getSipSmsRoutingRule;
    private PreparedStatement updateSmppSmsRoutingRule;
    private PreparedStatement updateSipSmsRoutingRule;
    private PreparedStatement deleteSmppSmsRoutingRule;
    private PreparedStatement deleteSipSmsRoutingRule;
    private PreparedStatement getSmppSmsRoutingRulesRange;
    private PreparedStatement getSmppSmsRoutingRulesRange2;
    private PreparedStatement getSipSmsRoutingRulesRange;
    private PreparedStatement getSipSmsRoutingRulesRange2;
    private Date pcsDate;
    private PreparedStatementCollection[] savedPsc;
    private volatile boolean started = false;
    private boolean databaseAvailable = false;

    protected DBOperations() {
    }

    public static DBOperations getInstance() {
        return instance;
    }

    public static void setBoundStatementDate(BoundStatement boundStatement, String columnName, Date date) {
        boundStatement.setTimestamp(columnName, date);
    }

    public static Date getRowDate(Row row, String columnName) {
        return row.getTimestamp(columnName);
    }

    public static ProtocolVersion getProtocolVersion(Cluster cluster) {
        return cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
    }

    public boolean isStarted() {
        return this.started;
    }

    public boolean isDatabaseAvailable() {
        return this.databaseAvailable;
    }

    protected Cluster getCluster() {
        return this.cluster;
    }

    protected Session getSession() {
        return this.session;
    }

    public void start(String hosts, int port, String keyspace, int secondsForwardStoring, int reviseSecondsOnSmscStart, int processingSmsSetTimeout) throws Exception {
        if (this.started) {
            throw new Exception("DBOperations already started");
        }
        if (secondsForwardStoring < 3) {
            secondsForwardStoring = 3;
        }
        this.dueSlotForwardStoring = secondsForwardStoring * 1000 / this.slotMSecondsTimeArea;
        this.dueSlotReviseOnSmscStart = reviseSecondsOnSmscStart * 1000 / this.slotMSecondsTimeArea;
        this.processingSmsSetTimeout = processingSmsSetTimeout;
        this.pcsDate = null;
        this.currentSessionUUID = UUID.randomUUID();
        Cluster.Builder builder = Cluster.builder();
        try {
            String[] cassHostsArray = hosts.split(",");
            builder.addContactPoints(cassHostsArray);
            builder.withPort(port);
            this.cluster = builder.build().init();
        }
        catch (Exception e) {
            logger.error((Object)String.format("Failure of connecting to cassandra database. : host=%s, port=%d. SMSC GW will work without database support\n", hosts, port), (Throwable)e);
            this.started = true;
            return;
        }
        ProtocolVersion protVersion = DBOperations.getProtocolVersion(this.cluster);
        if (protVersion == ProtocolVersion.V1) {
            logger.error((Object)"We do not support more cassandra database 1.2. You need to install cassandra database V2.0, 2.1 or 3.0");
            this.started = true;
            return;
        }
        this.databaseAvailable = true;
        Metadata metadata = this.cluster.getMetadata();
        logger.info((Object)String.format("Connected to cluster: %s\n", metadata.getClusterName()));
        for (Host host : metadata.getAllHosts()) {
            logger.info((Object)String.format("Datacenter: %s; Host: %s; Rack: %s\n", host.getDatacenter(), host.getAddress(), host.getRack()));
        }
        this.session = this.cluster.connect();
        this.session.execute("USE \"" + keyspace + "\"");
        this.checkCurrentSlotTableExists();
        String sa = "SELECT \"NEXT_SLOT\" FROM \"CURRENT_SLOT_TABLE\" where \"ID\"=?;";
        this.selectCurrentSlotTable = this.session.prepare(sa);
        sa = "INSERT INTO \"CURRENT_SLOT_TABLE\" (\"ID\", \"NEXT_SLOT\") VALUES (?, ?);";
        this.updateCurrentSlotTable = this.session.prepare(sa);
        this.getSmppSmsRoutingRule = this.session.prepare("select * from \"SMPP_SMS_ROUTING_RULE_2\" where \"ADDRESS\"=? and \"NETWORK_ID\"=?;");
        this.getSipSmsRoutingRule = this.session.prepare("select * from \"SIP_SMS_ROUTING_RULE_2\" where \"ADDRESS\"=? and \"NETWORK_ID\"=?;");
        this.updateSmppSmsRoutingRule = this.session.prepare("INSERT INTO \"SMPP_SMS_ROUTING_RULE_2\" (\"ADDRESS\", \"NETWORK_ID\", \"CLUSTER_NAME\") VALUES (?, ?, ?);");
        this.updateSipSmsRoutingRule = this.session.prepare("INSERT INTO \"SIP_SMS_ROUTING_RULE_2\" (\"ADDRESS\", \"NETWORK_ID\", \"CLUSTER_NAME\") VALUES (?, ?, ?);");
        this.deleteSmppSmsRoutingRule = this.session.prepare("delete from \"SMPP_SMS_ROUTING_RULE_2\" where \"ADDRESS\"=? and \"NETWORK_ID\"=?;");
        this.deleteSipSmsRoutingRule = this.session.prepare("delete from \"SIP_SMS_ROUTING_RULE_2\" where \"ADDRESS\"=? and \"NETWORK_ID\"=?;");
        int row_count = 100;
        this.getSmppSmsRoutingRulesRange = this.session.prepare("select * from \"SMPP_SMS_ROUTING_RULE_2\" where token(\"ADDRESS\") >= token(?) LIMIT " + row_count + ";");
        this.getSmppSmsRoutingRulesRange2 = this.session.prepare("select * from \"SMPP_SMS_ROUTING_RULE_2\"  LIMIT " + row_count + ";");
        this.getSipSmsRoutingRulesRange = this.session.prepare("select * from \"SIP_SMS_ROUTING_RULE_2\" where token(\"ADDRESS\") >= token(?) LIMIT " + row_count + ";");
        this.getSipSmsRoutingRulesRange2 = this.session.prepare("select * from \"SIP_SMS_ROUTING_RULE_2\"  LIMIT " + row_count + ";");
        try {
            this.currentDueSlot = this.c2_getCurrentSlotTable(0);
            if (this.currentDueSlot == 0L) {
                long l1 = this.c2_getDueSlotForTime(new Date());
                this.c2_setCurrentDueSlot(l1);
            } else {
                this.c2_setCurrentDueSlot(this.currentDueSlot - (long)this.dueSlotReviseOnSmscStart);
            }
            this.messageId = this.c2_getCurrentSlotTable(1);
            this.messageId += 1000L;
            this.c2_setCurrentSlotTable(1, this.messageId);
        }
        catch (Exception e1) {
            String msg = "Failed reading a currentDueSlot !";
            throw new PersistenceException(msg, e1);
        }
        this.started = true;
    }

    public void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.cluster != null && !this.cluster.isClosed()) {
            Metadata metadata = this.cluster.getMetadata();
            this.cluster.close();
            logger.info((Object)String.format("Disconnected from cluster: %s\n", metadata.getClusterName()));
        }
        this.started = false;
    }

    public long getSlotMSecondsTimeArea() {
        return this.slotMSecondsTimeArea;
    }

    public long c2_getDueSlotForTime(Date time) {
        long a2 = time.getTime();
        long a1 = this.slotOrigDate.getTime();
        long diff = a2 - a1;
        long res = diff / (long)this.slotMSecondsTimeArea;
        return res;
    }

    public Date c2_getTimeForDueSlot(long dueSlot) {
        long a1 = this.slotOrigDate.getTime() + dueSlot * (long)this.slotMSecondsTimeArea;
        Date date = new Date(a1);
        return date;
    }

    public long c2_getCurrentDueSlot() {
        return this.currentDueSlot;
    }

    public void c2_setCurrentDueSlot(long newDueSlot) throws PersistenceException {
        this.currentDueSlot = newDueSlot;
        this.c2_setCurrentSlotTable(0, newDueSlot);
    }

    public synchronized long c2_getNextMessageId() {
        ++this.messageId;
        if (this.messageId >= 10000000000L) {
            this.messageId = 1L;
        }
        if (this.messageId % 1000L == 0L && this.databaseAvailable) {
            try {
                this.c2_setCurrentSlotTable(1, this.messageId);
            }
            catch (PersistenceException e) {
                logger.error((Object)("Exception when storing next messageId to the database: " + e.getMessage()), (Throwable)e);
            }
        }
        return this.messageId;
    }

    protected long c2_getCurrentSlotTable(int key) throws PersistenceException {
        long res2;
        block0: {
            PreparedStatement ps = this.selectCurrentSlotTable;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{key});
            ResultSet res = this.session.execute((Statement)boundStatement);
            res2 = 0L;
            Iterator i$ = res.iterator();
            if (!i$.hasNext()) break block0;
            Row row = (Row)i$.next();
            res2 = row.getLong(0);
        }
        return res2;
    }

    private void c2_setCurrentSlotTable(int key, long newVal) throws PersistenceException {
        try {
            PreparedStatement ps = this.updateCurrentSlotTable;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{key, newVal});
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed writing a c2_setCurrenrSlotTable !";
            throw new PersistenceException(msg, e1);
        }
    }

    public long c2_getIntimeDueSlot() {
        return this.c2_getDueSlotForTime(new Date());
    }

    public long c2_getDueSlotForNewSms() {
        long res = this.c2_getIntimeDueSlot() + (long)this.dueSlotForwardStoring;
        return res;
    }

    public long c2_checkDueSlotWritingPossibility(long dueSlot) {
        long first = this.c2_getCurrentDueSlot() + 10L;
        if (dueSlot < first) {
            return first;
        }
        return dueSlot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void c2_registerDueSlotWriting(long dueSlot) {
        FastMap<Long, DueSlotWritingElement> fastMap = this.dueSlotWritingArray;
        synchronized (fastMap) {
            Long ll = dueSlot;
            DueSlotWritingElement el = (DueSlotWritingElement)this.dueSlotWritingArray.get((Object)ll);
            if (el == null) {
                el = new DueSlotWritingElement(ll);
                this.dueSlotWritingArray.put((Object)ll, (Object)el);
                el.writingCount = 1;
            } else {
                ++el.writingCount;
            }
            el.lastStartDate = new Date();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void c2_unregisterDueSlotWriting(long dueSlot) {
        FastMap<Long, DueSlotWritingElement> fastMap = this.dueSlotWritingArray;
        synchronized (fastMap) {
            Long ll = dueSlot;
            DueSlotWritingElement el = (DueSlotWritingElement)this.dueSlotWritingArray.get((Object)ll);
            if (el != null) {
                --el.writingCount;
                if (el.writingCount == 0) {
                    this.dueSlotWritingArray.remove((Object)ll);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean c2_checkDueSlotNotWriting(long dueSlot) {
        FastMap<Long, DueSlotWritingElement> fastMap = this.dueSlotWritingArray;
        synchronized (fastMap) {
            Long ll = dueSlot;
            DueSlotWritingElement el = (DueSlotWritingElement)this.dueSlotWritingArray.get((Object)ll);
            if (el != null) {
                Date d1 = el.lastStartDate;
                Date d2 = new Date();
                long diff = d2.getTime() - d1.getTime();
                if (diff > (long)this.millisecDueSlotWritingTimeout) {
                    logger.warn((Object)"Timeout in millisecDueSlotWritingTimeout element");
                    this.dueSlotWritingArray.remove((Object)ll);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    protected String getTableName(long dueSlot) {
        Date dt = this.c2_getTimeForDueSlot(dueSlot);
        return this.getTableName(dt);
    }

    protected String getTableName(Date dt) {
        if (this.multiTableModel) {
            StringBuilder sb = new StringBuilder();
            sb.append("_");
            sb.append(dt.getYear() + 1900);
            sb.append("_");
            int mn = dt.getMonth() + 1;
            if (mn >= 10) {
                sb.append(mn);
            } else {
                sb.append("0");
                sb.append(mn);
            }
            if (this.dataTableDaysTimeArea >= 1 && this.dataTableDaysTimeArea < 30) {
                int dy = dt.getDate();
                int fNum = this.dataTableDaysTimeArea == 1 ? dy / this.dataTableDaysTimeArea : dy / this.dataTableDaysTimeArea + 1;
                sb.append("_");
                if (fNum >= 10) {
                    sb.append(fNum);
                } else {
                    sb.append("0");
                    sb.append(fNum);
                }
            }
            return sb.toString();
        }
        return "";
    }

    public PreparedStatementCollection[] c2_getPscList() throws PersistenceException {
        Date dt = new Date();
        if (!this.isStarted()) {
            return new PreparedStatementCollection[0];
        }
        if (this.pcsDate != null && dt.getDate() == this.pcsDate.getDate()) {
            return this.savedPsc;
        }
        this.createPscList();
        return this.savedPsc;
    }

    private void createPscList() throws PersistenceException {
        Date dt = new Date();
        Date dtt = new Date(dt.getTime() + 86400000L);
        String s1 = this.getTableName(dt);
        String s2 = this.getTableName(dtt);
        PreparedStatementCollection[] res = !s2.equals(s1) ? new PreparedStatementCollection[]{this.getStatementCollection(dtt), this.getStatementCollection(dt)} : new PreparedStatementCollection[]{this.getStatementCollection(dt)};
        this.savedPsc = res;
        this.pcsDate = dt;
    }

    public long c2_getDueSlotForTargetId(String targetId) throws PersistenceException {
        PreparedStatementCollection[] lstPsc;
        for (PreparedStatementCollection psc : lstPsc = this.c2_getPscList()) {
            long dueSlot = this.c2_getDueSlotForTargetId(psc, targetId);
            if (dueSlot == 0L) continue;
            return dueSlot;
        }
        return 0L;
    }

    public long c2_getDueSlotForTargetId(PreparedStatementCollection psc, String targetId) throws PersistenceException {
        try {
            PreparedStatement ps = psc.getDueSlotForTargetId;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{targetId});
            ResultSet res = this.session.execute((Statement)boundStatement);
            long l = 0L;
            Iterator i$ = res.iterator();
            if (i$.hasNext()) {
                Row row = (Row)i$.next();
                l = row.getLong(0);
            }
            return l;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            String msg = "Failed to execute getDueSlotForTargetId() !";
            throw new PersistenceException(msg, e1);
        }
    }

    public void c2_updateDueSlotForTargetId(String targetId, long newDueSlot) throws PersistenceException {
        PreparedStatementCollection psc = this.getStatementCollection(newDueSlot);
        try {
            PreparedStatement ps = psc.createDueSlotForTargetId;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{targetId, newDueSlot});
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed to execute createDueSlotForTargetId() !";
            throw new PersistenceException(msg, e1);
        }
    }

    private void c2_clearDueSlotForTargetId(String targetId, long newDueSlot) throws PersistenceException {
        PreparedStatementCollection psc = this.getStatementCollection(newDueSlot);
        try {
            PreparedStatement ps = psc.createDueSlotForTargetId;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{targetId, 0L});
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed to execute clearDueSlotForTargetId() !";
            throw new PersistenceException(msg, e1);
        }
    }

    public void c2_updateDueSlotForTargetId_WithTableCleaning(String targetId, long newDueSlot) throws PersistenceException {
        PreparedStatementCollection[] lstPsc = this.c2_getPscList();
        if (lstPsc.length >= 2) {
            String s1 = this.getTableName(newDueSlot);
            for (int i1 = 0; i1 < lstPsc.length; ++i1) {
                long dueSlot;
                PreparedStatementCollection psc = lstPsc[i1];
                if (psc.getTName().equals(s1) || (dueSlot = this.c2_getDueSlotForTargetId(psc, targetId)) == 0L) continue;
                this.c2_clearDueSlotForTargetId(targetId, dueSlot);
            }
        }
        this.c2_updateDueSlotForTargetId(targetId, newDueSlot);
    }

    public void c2_scheduleMessage_ReschedDueSlot(Sms sms, boolean fastStoreAndForwordMode, boolean removeExpiredValidityPeriod) throws PersistenceException {
        this.c2_scheduleMessage_ReschedDueSlot(sms, fastStoreAndForwordMode, 0L, null, removeExpiredValidityPeriod);
    }

    private void c2_scheduleMessage_ReschedDueSlot(Sms sms, boolean fastStoreAndForwordMode, long preferredDueSlot, ArrayList<Sms> lstFailured, boolean removeExpiredValidityPeriod) throws PersistenceException {
        if (sms.getStored()) {
            long dueSlot = 0L;
            PreparedStatementCollection[] lstPsc = this.c2_getPscList();
            boolean done = false;
            int cnt = 0;
            while (!done && cnt < 5) {
                ++cnt;
                SmType destType = sms.getSmsSet().getType();
                if (destType == null || destType == SmType.SMS_FOR_SS7) {
                    long dueSlot2;
                    PreparedStatementCollection psc;
                    PreparedStatementCollection[] arr$ = lstPsc;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (dueSlot = this.c2_getDueSlotForTargetId(psc = arr$[i$], sms.getSmsSet().getTargetId())) == 0L; ++i$) {
                    }
                    if ((dueSlot == 0L || dueSlot <= this.c2_getCurrentDueSlot()) && preferredDueSlot > 0L) {
                        dueSlot = preferredDueSlot;
                        this.c2_updateDueSlotForTargetId_WithTableCleaning(sms.getSmsSet().getTargetId(), dueSlot);
                    }
                    if (fastStoreAndForwordMode && dueSlot != 0L && (dueSlot2 = this.c2_checkDueSlotWritingPossibility(dueSlot)) != dueSlot) {
                        dueSlot = dueSlot2;
                        this.c2_updateDueSlotForTargetId_WithTableCleaning(sms.getSmsSet().getTargetId(), dueSlot);
                    }
                }
                if (dueSlot == 0L || dueSlot <= this.c2_getCurrentDueSlot()) {
                    dueSlot = this.c2_getDueSlotForNewSms();
                    this.c2_updateDueSlotForTargetId_WithTableCleaning(sms.getSmsSet().getTargetId(), dueSlot);
                }
                sms.setDueSlot(dueSlot);
                done = this.do_scheduleMessage(sms, dueSlot, lstFailured, fastStoreAndForwordMode, removeExpiredValidityPeriod);
            }
            if (!done) {
                logger.warn((Object)("5 retries of c2_scheduleMessage fails for targetId=" + sms.getSmsSet().getTargetId()));
            }
        }
    }

    public void c2_scheduleMessage_NewDueSlot(Sms sms, long dueSlot, ArrayList<Sms> lstFailured, boolean fastStoreAndForwordMode) throws PersistenceException {
        if (sms.getStoringAfterFailure()) {
            sms.setStored(true);
            this.c2_scheduleMessage_ReschedDueSlot(sms, fastStoreAndForwordMode, dueSlot, lstFailured, true);
        } else if (sms.getStored()) {
            if (fastStoreAndForwordMode) {
                dueSlot = this.c2_checkDueSlotWritingPossibility(dueSlot);
            }
            this.c2_updateInSystem(sms, 2, fastStoreAndForwordMode);
            this.c2_updateDueSlotForTargetId_WithTableCleaning(sms.getSmsSet().getTargetId(), dueSlot);
            this.do_scheduleMessage(sms, dueSlot, lstFailured, fastStoreAndForwordMode, true);
        } else if (lstFailured != null) {
            lstFailured.add(sms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean do_scheduleMessage(Sms sms, long dueSlot, ArrayList<Sms> lstFailured, boolean fastStoreAndForwordMode, boolean removeExpiredValidityPeriod) throws PersistenceException {
        sms.setDueSlot(dueSlot);
        Date dt = this.c2_getTimeForDueSlot(dueSlot);
        Date schedTime = sms.getScheduleDeliveryTime();
        if (schedTime != null && schedTime.after(dt)) {
            dueSlot = this.c2_getDueSlotForTime(schedTime);
            sms.setDueSlot(dueSlot);
        }
        if (fastStoreAndForwordMode) {
            return this.doCreateRecordCurrent(sms, dueSlot);
        }
        this.c2_registerDueSlotWriting(dueSlot);
        try {
            boolean bl = this.doCreateRecordCurrent(sms, dueSlot);
            return bl;
        }
        finally {
            this.c2_unregisterDueSlotWriting(dueSlot);
        }
    }

    private boolean doCreateRecordCurrent(Sms sms, long dueSlot) throws PersistenceException {
        if (dueSlot <= this.c2_getCurrentDueSlot()) {
            return false;
        }
        this.c2_createRecordCurrent(sms);
        return true;
    }

    public void c2_createRecordCurrent(Sms sms) throws PersistenceException {
        long dueSlot = sms.getDueSlot();
        PreparedStatementCollection psc = this.getStatementCollection(dueSlot);
        try {
            PreparedStatement ps = psc.createRecordCurrent;
            BoundStatement boundStatement = new BoundStatement(ps);
            this.setSmsFields(sms, dueSlot, boundStatement, false, psc.getShortMessageNewStringFormat(), psc.getAddedCorrId(), psc.getAddedNetworkId(), psc.getAddedOrigNetworkId(), psc.getAddedPacket1());
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed createRecordCurrent !" + e1.getMessage();
            throw new PersistenceException(msg, e1);
        }
    }

    public void c2_createRecordArchive(Sms sms, String dlvMessageId, String dlvDestId, boolean deliveryReceipts, boolean incomingDeliveryReceipts) throws PersistenceException {
        if (!this.databaseAvailable) {
            return;
        }
        Date deliveryDate = sms.getDeliverDate();
        if (deliveryDate == null) {
            deliveryDate = new Date();
        }
        long dueSlot = this.c2_getDueSlotForTime(deliveryDate);
        PreparedStatementCollection psc = this.getStatementCollection(deliveryDate);
        try {
            PreparedStatement ps = psc.createRecordArchive;
            BoundStatement boundStatement = new BoundStatement(ps);
            this.setSmsFields(sms, dueSlot, boundStatement, true, psc.getShortMessageNewStringFormat(), psc.getAddedCorrId(), psc.getAddedNetworkId(), psc.getAddedOrigNetworkId(), psc.getAddedPacket1());
            ResultSet res = this.session.execute((Statement)boundStatement);
            if ((deliveryReceipts || incomingDeliveryReceipts) && !MessageUtil.isDeliveryReceipt(sms)) {
                SmsSetCache.getInstance().putDeliveredMsgValue(sms, 30);
                ps = psc.createRecordArchiveMesId;
                boundStatement = new BoundStatement(ps);
                boundStatement.setLong("MESSAGE_ID", sms.getMessageId());
                boundStatement.setString("ADDR_DST_DIGITS", sms.getSmsSet().getDestAddr());
                boundStatement.setUUID("ID", sms.getDbId());
                res = this.session.execute((Statement)boundStatement);
            }
            if (incomingDeliveryReceipts && dlvMessageId != null && dlvDestId != null && MessageUtil.isDeliveryReceiptRequest(sms)) {
                ps = psc.createRecordArchiveDlvMesId;
                boundStatement = new BoundStatement(ps);
                boundStatement.setString("REMOTE_MESSAGE_ID", dlvMessageId);
                boundStatement.setString("DEST_ID", dlvDestId);
                boundStatement.setLong("MESSAGE_ID", sms.getMessageId());
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            String msg = "Failed createRecordArchive !" + e1.getMessage();
            throw new PersistenceException(msg, e1);
        }
    }

    private void setSmsFields(Sms sms, long dueSlot, BoundStatement boundStatement, boolean archive, boolean shortMessageNewStringFormat, boolean addedCorrId, boolean addedNetworkId, boolean addedOrigNetworkId, boolean addedPacket1) throws PersistenceException {
        boundStatement.setUUID("ID", sms.getDbId());
        boundStatement.setString("TARGET_ID", sms.getSmsSet().getTargetId());
        if (addedNetworkId) {
            boundStatement.setInt("NETWORK_ID", sms.getSmsSet().getNetworkId());
        }
        boundStatement.setLong("DUE_SLOT", dueSlot);
        boundStatement.setInt("IN_SYSTEM", 0);
        boundStatement.setUUID("SMSC_UUID", emptyUuid);
        boundStatement.setString("ADDR_DST_DIGITS", sms.getSmsSet().getDestAddr());
        boundStatement.setInt("ADDR_DST_TON", sms.getSmsSet().getDestAddrTon());
        boundStatement.setInt("ADDR_DST_NPI", sms.getSmsSet().getDestAddrNpi());
        if (sms.getSourceAddr() != null) {
            boundStatement.setString("ADDR_SRC_DIGITS", sms.getSourceAddr());
        } else {
            boundStatement.setToNull("ADDR_SRC_DIGITS");
        }
        boundStatement.setInt("ADDR_SRC_TON", sms.getSourceAddrTon());
        boundStatement.setInt("ADDR_SRC_NPI", sms.getSourceAddrNpi());
        if (addedOrigNetworkId) {
            boundStatement.setInt("ORIG_NETWORK_ID", sms.getOrigNetworkId());
        }
        boundStatement.setInt("DUE_DELAY", sms.getSmsSet().getDueDelay());
        if (sms.getSmsSet().getStatus() != null) {
            boundStatement.setInt("SM_STATUS", sms.getSmsSet().getStatus().getCode());
        } else {
            boundStatement.setToNull("SM_STATUS");
        }
        boundStatement.setBool("ALERTING_SUPPORTED", sms.getSmsSet().isAlertingSupported());
        boundStatement.setLong("MESSAGE_ID", sms.getMessageId());
        boundStatement.setInt("MO_MESSAGE_REF", sms.getMoMessageRef());
        if (sms.getOrigEsmeName() != null) {
            boundStatement.setString("ORIG_ESME_NAME", sms.getOrigEsmeName());
        } else {
            boundStatement.setToNull("ORIG_ESME_NAME");
        }
        if (sms.getOrigSystemId() != null) {
            boundStatement.setString("ORIG_SYSTEM_ID", sms.getOrigSystemId());
        } else {
            boundStatement.setToNull("ORIG_SYSTEM_ID");
        }
        if (sms.getSubmitDate() != null) {
            DBOperations.setBoundStatementDate(boundStatement, "SUBMIT_DATE", sms.getSubmitDate());
        } else {
            boundStatement.setToNull("SUBMIT_DATE");
        }
        if (sms.getDeliverDate() != null) {
            DBOperations.setBoundStatementDate(boundStatement, "DELIVERY_DATE", sms.getDeliverDate());
        } else {
            boundStatement.setToNull("DELIVERY_DATE");
        }
        if (sms.getServiceType() != null) {
            boundStatement.setString("SERVICE_TYPE", sms.getServiceType());
        } else {
            boundStatement.setToNull("SERVICE_TYPE");
        }
        boundStatement.setInt("ESM_CLASS", sms.getEsmClass());
        boundStatement.setInt("PROTOCOL_ID", sms.getProtocolId());
        boundStatement.setInt("PRIORITY", sms.getPriority());
        boundStatement.setInt("REGISTERED_DELIVERY", sms.getRegisteredDelivery());
        boundStatement.setInt("REPLACE", sms.getReplaceIfPresent());
        boundStatement.setInt("DATA_CODING", sms.getDataCodingForDatabase());
        boundStatement.setInt("DEFAULT_MSG_ID", sms.getDefaultMsgId());
        if (shortMessageNewStringFormat) {
            if (sms.getShortMessageText() != null) {
                boundStatement.setString("MESSAGE_TEXT", sms.getShortMessageText());
            } else {
                boundStatement.setToNull("MESSAGE_TEXT");
            }
            if (sms.getShortMessageBin() != null) {
                boundStatement.setBytes("MESSAGE_BIN", ByteBuffer.wrap(sms.getShortMessageBin()));
            } else {
                boundStatement.setToNull("MESSAGE_BIN");
            }
            boundStatement.setToNull("MESSAGE");
        } else {
            byte[] data;
            String msg = sms.getShortMessageText();
            byte[] udhData = sms.getShortMessageBin();
            byte[] textPart = null;
            DataCodingSchemeImpl dcs = new DataCodingSchemeImpl(sms.getDataCoding());
            switch (dcs.getCharacterSet()) {
                case GSM7: {
                    textPart = msg.getBytes();
                    break;
                }
                case UCS2: {
                    Charset ucs2Charset = Charset.forName("UTF-16BE");
                    ByteBuffer bb = ucs2Charset.encode(msg);
                    textPart = new byte[bb.limit()];
                    bb.get(textPart);
                    break;
                }
            }
            if (textPart != null) {
                if (udhData != null) {
                    data = new byte[textPart.length + udhData.length];
                    System.arraycopy(udhData, 0, data, 0, udhData.length);
                    System.arraycopy(textPart, 0, data, udhData.length, textPart.length);
                } else {
                    data = textPart;
                }
            } else {
                data = udhData != null ? udhData : new byte[]{};
            }
            boundStatement.setBytes("MESSAGE", ByteBuffer.wrap(data));
        }
        if (sms.getScheduleDeliveryTime() != null) {
            DBOperations.setBoundStatementDate(boundStatement, "SCHEDULE_DELIVERY_TIME", sms.getScheduleDeliveryTime());
        } else {
            boundStatement.setToNull("SCHEDULE_DELIVERY_TIME");
        }
        if (sms.getValidityPeriod() != null) {
            DBOperations.setBoundStatementDate(boundStatement, "VALIDITY_PERIOD", sms.getValidityPeriod());
        } else {
            boundStatement.setToNull("VALIDITY_PERIOD");
        }
        boundStatement.setInt("DELIVERY_COUNT", sms.getDeliveryCount());
        if (addedPacket1) {
            if (sms.getOriginatorSccpAddress() != null) {
                boundStatement.setString("ORIGINATOR_SCCP_ADDRESS", sms.getOriginatorSccpAddress());
            } else {
                boundStatement.setToNull("ORIGINATOR_SCCP_ADDRESS");
            }
            boundStatement.setBool("STATUS_REPORT_REQUEST", sms.isStatusReportRequest());
            boundStatement.setInt("DELIVERY_ATTEMPT", sms.getDeliveryAttempt());
            if (sms.getUserData() != null) {
                boundStatement.setString("USER_DATA", sms.getUserData());
            } else {
                boundStatement.setToNull("USER_DATA");
            }
            if (sms.getExtraData() != null) {
                boundStatement.setString("EXTRA_DATA", sms.getExtraData());
            } else {
                boundStatement.setToNull("EXTRA_DATA");
            }
            if (sms.getExtraData_2() != null) {
                boundStatement.setString("EXTRA_DATA_2", sms.getExtraData_2());
            } else {
                boundStatement.setToNull("EXTRA_DATA_2");
            }
            if (sms.getExtraData_3() != null) {
                boundStatement.setString("EXTRA_DATA_3", sms.getExtraData_3());
            } else {
                boundStatement.setToNull("EXTRA_DATA_3");
            }
            if (sms.getExtraData_4() != null) {
                boundStatement.setString("EXTRA_DATA_4", sms.getExtraData_4());
            } else {
                boundStatement.setToNull("EXTRA_DATA_4");
            }
        }
        if (sms.getTlvSet().getOptionalParameterCount() > 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                XMLObjectWriter writer = XMLObjectWriter.newInstance((OutputStream)baos);
                writer.setIndentation("\t");
                writer.write((Object)sms.getTlvSet(), TLV_SET, TlvSet.class);
                writer.close();
                byte[] rawData = baos.toByteArray();
                String serializedEvent = new String(rawData);
                boundStatement.setString("OPTIONAL_PARAMETERS", serializedEvent);
            }
            catch (XMLStreamException e) {
                String msg = "XMLStreamException when serializing optional parameters for '" + sms.getDbId() + "'!";
                throw new PersistenceException(msg, e);
            }
        } else {
            boundStatement.setToNull("OPTIONAL_PARAMETERS");
        }
        if (!archive) {
            if (addedCorrId) {
                boundStatement.setToNull("CORR_ID");
            }
            boundStatement.setToNull("IMSI");
            if (sms.getSmsSet().getCorrelationId() != null) {
                if (addedCorrId) {
                    boundStatement.setString("CORR_ID", sms.getSmsSet().getCorrelationId());
                } else {
                    boundStatement.setString("IMSI", sms.getSmsSet().getCorrelationId());
                }
            }
        } else {
            if (sms.getSmsSet().getLocationInfoWithLMSI() != null && sms.getSmsSet().getLocationInfoWithLMSI().getNetworkNodeNumber() != null) {
                boundStatement.setString("NNN_DIGITS", sms.getSmsSet().getLocationInfoWithLMSI().getNetworkNodeNumber().getAddress());
                boundStatement.setInt("NNN_AN", sms.getSmsSet().getLocationInfoWithLMSI().getNetworkNodeNumber().getAddressNature().getIndicator());
                boundStatement.setInt("NNN_NP", sms.getSmsSet().getLocationInfoWithLMSI().getNetworkNodeNumber().getNumberingPlan().getIndicator());
            } else {
                boundStatement.setToNull("NNN_DIGITS");
                boundStatement.setToNull("NNN_AN");
                boundStatement.setToNull("NNN_NP");
            }
            if (sms.getSmsSet().getType() != null) {
                boundStatement.setInt("SM_TYPE", sms.getSmsSet().getType().getCode());
            } else {
                boundStatement.setToNull("SM_TYPE");
            }
            if (addedCorrId) {
                boundStatement.setString("CORR_ID", sms.getSmsSet().getCorrelationId());
            }
            boundStatement.setString("IMSI", sms.getSmsSet().getImsi());
        }
    }

    public ArrayList<SmsSet> c2_getRecordList(long dueSlot) throws PersistenceException {
        PreparedStatementCollection psc = this.getStatementCollection(dueSlot);
        ArrayList<SmsSet> result = new ArrayList<SmsSet>();
        try {
            PreparedStatement ps = psc.getRecordData;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{dueSlot});
            ResultSet res = this.session.execute((Statement)boundStatement);
            for (Row row : res) {
                SmsSet smsSet = this.createSms(row, null, psc.getShortMessageNewStringFormat(), psc.getAddedCorrId(), psc.getAddedNetworkId(), psc.getAddedOrigNetworkId(), psc.getAddedPacket1(), false);
                if (smsSet == null) continue;
                result.add(smsSet);
            }
        }
        catch (Exception e1) {
            String msg = "Failed getRecordList()";
            throw new PersistenceException(msg, e1);
        }
        return result;
    }

    public SmsSet c2_getRecordListForTargeId(long dueSlot, String targetId) throws PersistenceException {
        PreparedStatementCollection psc = this.getStatementCollection(dueSlot);
        SmsSet result = null;
        try {
            PreparedStatement ps = psc.getRecordData2;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{dueSlot, targetId});
            ResultSet res = this.session.execute((Statement)boundStatement);
            for (Row row : res) {
                result = this.createSms(row, result, psc.getShortMessageNewStringFormat(), psc.getAddedCorrId(), psc.getAddedNetworkId(), psc.getAddedOrigNetworkId(), psc.getAddedPacket1(), false);
            }
        }
        catch (Exception e1) {
            String msg = "Failed getRecordListForTargeId()";
            throw new PersistenceException(msg, e1);
        }
        return result;
    }

    public Sms c2_getRecordArchiveForMessageId(long messageId) throws PersistenceException {
        Sms sms = SmsSetCache.getInstance().getDeliveredMsgValue(messageId);
        if (sms != null) {
            return sms;
        }
        SmsSet result = null;
        try {
            Date date = new Date();
            PreparedStatementCollection psc = this.getStatementCollection(date);
            result = this.doGetArchiveMsg(messageId, psc);
            if (result == null) {
                Date date2 = new Date(date.getTime() - 86400000L);
                psc = this.getStatementCollection(date2);
                result = this.doGetArchiveMsg(messageId, psc);
            }
        }
        catch (Exception e1) {
            String msg = "Failed getRecordArchiveForMessageId()";
            throw new PersistenceException(msg, e1);
        }
        if (result != null) {
            return result.getSms(0L);
        }
        return null;
    }

    private SmsSet doGetArchiveMsg(long messageId, PreparedStatementCollection psc) throws PersistenceException {
        SmsSet result;
        block2: {
            PreparedStatement ps = psc.getRecordArchiveMesId;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{messageId});
            ResultSet res = this.session.execute((Statement)boundStatement);
            String addr = null;
            UUID id = null;
            Iterator i$ = res.iterator();
            if (i$.hasNext()) {
                Row row = (Row)i$.next();
                addr = row.getString("ADDR_DST_DIGITS");
                id = row.getUUID("ID");
            }
            result = null;
            if (addr == null || id == null) break block2;
            ps = psc.getRecordArchive;
            boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{addr, id});
            res = this.session.execute((Statement)boundStatement);
            Iterator i$2 = res.iterator();
            if (i$2.hasNext()) {
                Row row = (Row)i$2.next();
                result = this.createSms(row, null, psc.getShortMessageNewStringFormat(), psc.getAddedCorrId(), psc.getAddedNetworkId(), psc.getAddedOrigNetworkId(), psc.getAddedPacket1(), true);
            }
        }
        return result;
    }

    public Long c2_getMessageIdByRemoteMessageId(String remoteMessageId, String destId) throws PersistenceException {
        Long result = null;
        result = SmsSetCache.getInstance().getDeliveredRemoteMsgIdValue(remoteMessageId, destId);
        if (result != null) {
            return result;
        }
        try {
            Date date = new Date();
            PreparedStatementCollection psc = this.getStatementCollection(date);
            result = this.doGetMessageIdByRemoteMessageId(remoteMessageId, destId, psc);
            if (result == null) {
                Date date2 = new Date(date.getTime() - 86400000L);
                psc = this.getStatementCollection(date2);
                result = this.doGetMessageIdByRemoteMessageId(remoteMessageId, destId, psc);
            }
        }
        catch (Exception e1) {
            String msg = "Failed c2_getMessageIdByRemoteMessageId()";
            throw new PersistenceException(msg, e1);
        }
        return result;
    }

    private Long doGetMessageIdByRemoteMessageId(String remoteMessageId, String destId, PreparedStatementCollection psc) throws PersistenceException {
        Long msgId;
        block0: {
            PreparedStatement ps = psc.getRecordArchiveDlvMesId;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{remoteMessageId, destId});
            ResultSet res = this.session.execute((Statement)boundStatement);
            msgId = null;
            Iterator i$ = res.iterator();
            if (!i$.hasNext()) break block0;
            Row row = (Row)i$.next();
            msgId = row.getLong("MESSAGE_ID");
        }
        return msgId;
    }

    protected SmsSet createSms(Row row, SmsSet smsSet, boolean shortMessageNewStringFormat, boolean addedCorrId, boolean addedNetworkId, boolean addedOrigNetworkId, boolean addedPacket1, boolean getMessageInProcessing) throws PersistenceException {
        boolean alertingSupported;
        int dueDelay;
        String s;
        byte[] buf;
        ByteBuffer bb;
        if (row == null) {
            return smsSet;
        }
        int inSystem = row.getInt("IN_SYSTEM");
        UUID smscUuid = row.getUUID("SMSC_UUID");
        if (!getMessageInProcessing && (inSystem == 2 || inSystem == 1 && smscUuid.equals(this.currentSessionUUID))) {
            return smsSet;
        }
        Sms sms = new Sms();
        sms.setStored(true);
        sms.setDbId(row.getUUID("ID"));
        sms.setDueSlot(row.getLong("DUE_SLOT"));
        sms.setSourceAddr(row.getString("ADDR_SRC_DIGITS"));
        sms.setSourceAddrTon(row.getInt("ADDR_SRC_TON"));
        sms.setSourceAddrNpi(row.getInt("ADDR_SRC_NPI"));
        if (addedOrigNetworkId) {
            sms.setOrigNetworkId(row.getInt("ORIG_NETWORK_ID"));
        }
        sms.setMessageId(row.getLong("MESSAGE_ID"));
        sms.setMoMessageRef(row.getInt("MO_MESSAGE_REF"));
        sms.setOrigEsmeName(row.getString("ORIG_ESME_NAME"));
        sms.setOrigSystemId(row.getString("ORIG_SYSTEM_ID"));
        sms.setSubmitDate(DBOperations.getRowDate(row, "SUBMIT_DATE"));
        sms.setServiceType(row.getString("SERVICE_TYPE"));
        sms.setEsmClass(row.getInt("ESM_CLASS"));
        sms.setProtocolId(row.getInt("PROTOCOL_ID"));
        sms.setPriority(row.getInt("PRIORITY"));
        sms.setRegisteredDelivery(row.getInt("REGISTERED_DELIVERY"));
        sms.setReplaceIfPresent(row.getInt("REPLACE"));
        sms.setDataCodingForDatabase(row.getInt("DATA_CODING"));
        sms.setDefaultMsgId(row.getInt("DEFAULT_MSG_ID"));
        if (shortMessageNewStringFormat) {
            sms.setShortMessageText(row.getString("MESSAGE_TEXT"));
            bb = row.getBytes("MESSAGE_BIN");
            if (bb != null) {
                buf = new byte[bb.limit() - bb.position()];
                bb.get(buf);
                sms.setShortMessageBin(buf);
            }
        } else {
            bb = row.getBytes("MESSAGE");
            if (bb != null) {
                byte[] shortMessage;
                buf = new byte[bb.limit() - bb.position()];
                bb.get(buf);
                sms.setShortMessage(buf);
                byte[] textPart = shortMessage = sms.getShortMessage();
                byte[] udhData = null;
                boolean udhExists = false;
                DataCodingSchemeImpl dcs = new DataCodingSchemeImpl(sms.getDataCoding());
                String msg = null;
                if (dcs.getCharacterSet() == CharacterSet.GSM8) {
                    udhData = shortMessage;
                } else {
                    int udhLen;
                    if ((sms.getEsmClass() & 0x40) != 0) {
                        udhExists = true;
                    }
                    if (udhExists && shortMessage != null && shortMessage.length > 2 && (udhLen = (shortMessage[0] & 0xFF) + 1) <= shortMessage.length) {
                        textPart = new byte[shortMessage.length - udhLen];
                        udhData = new byte[udhLen];
                        System.arraycopy(shortMessage, udhLen, textPart, 0, textPart.length);
                        System.arraycopy(shortMessage, 0, udhData, 0, udhLen);
                    }
                    switch (dcs.getCharacterSet()) {
                        case GSM7: {
                            msg = new String(textPart);
                            break;
                        }
                        case UCS2: {
                            Charset ucs2Charset = Charset.forName("UTF-16BE");
                            bb = ByteBuffer.wrap(textPart);
                            CharBuffer bf = ucs2Charset.decode(bb);
                            msg = bf.toString();
                            break;
                        }
                        default: {
                            udhData = sms.getShortMessage();
                        }
                    }
                }
                sms.setShortMessageText(msg);
                sms.setShortMessageBin(udhData);
            }
        }
        sms.setScheduleDeliveryTime(DBOperations.getRowDate(row, "SCHEDULE_DELIVERY_TIME"));
        sms.setValidityPeriod(DBOperations.getRowDate(row, "VALIDITY_PERIOD"));
        sms.setDeliveryCount(row.getInt("DELIVERY_COUNT"));
        if (addedPacket1) {
            sms.setOriginatorSccpAddress(row.getString("ORIGINATOR_SCCP_ADDRESS"));
            sms.setStatusReportRequest(row.getBool("STATUS_REPORT_REQUEST"));
            sms.setDeliveryAttempt(row.getInt("DELIVERY_ATTEMPT"));
            sms.setUserData(row.getString("USER_DATA"));
            sms.setExtraData(row.getString("EXTRA_DATA"));
            sms.setExtraData_2(row.getString("EXTRA_DATA_2"));
            sms.setExtraData_3(row.getString("EXTRA_DATA_3"));
            sms.setExtraData_4(row.getString("EXTRA_DATA_4"));
        }
        if ((s = row.getString("OPTIONAL_PARAMETERS")) != null) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(s.getBytes());
                XMLObjectReader reader = XMLObjectReader.newInstance((InputStream)bais);
                TlvSet copy = (TlvSet)reader.read(TLV_SET, TlvSet.class);
                sms.getTlvSet().clearAllOptionalParameter();
                sms.getTlvSet().addAllOptionalParameter((Collection)copy.getOptionalParameters());
            }
            catch (XMLStreamException e) {
                String msg = "XMLStreamException when deserializing optional parameters for '" + sms.getDbId() + "'!";
                throw new PersistenceException(msg, e);
            }
        }
        if (smsSet == null) {
            smsSet = new SmsSet();
            String destAddr = null;
            int destAddrTon = -1;
            int destAddrNpi = -1;
            destAddr = row.getString("ADDR_DST_DIGITS");
            destAddrTon = row.getInt("ADDR_DST_TON");
            destAddrNpi = row.getInt("ADDR_DST_NPI");
            if (destAddr == null || destAddrTon == -1 || destAddrNpi == -1) {
                throw new PersistenceException("destAddr or destAddrTon or destAddrNpi is absent for ID='" + sms.getDbId() + "'");
            }
            smsSet.setDestAddr(destAddr);
            smsSet.setDestAddrTon(destAddrTon);
            smsSet.setDestAddrNpi(destAddrNpi);
            if (getMessageInProcessing) {
                smsSet.setInSystem(inSystem);
                smsSet.setStatus(ErrorCode.fromInt(row.getInt("SM_STATUS")));
            }
            if (addedNetworkId) {
                smsSet.setNetworkId(row.getInt("NETWORK_ID"));
            } else {
                String[] ss;
                String tagId = row.getString("TARGET_ID");
                if (tagId != null && (ss = tagId.split("_")).length == 4) {
                    String s1 = ss[3];
                    try {
                        int networkId = Integer.parseInt(s1);
                        smsSet.setNetworkId(networkId);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (addedCorrId) {
                smsSet.setCorrelationId(row.getString("CORR_ID"));
            } else {
                smsSet.setCorrelationId(row.getString("IMSI"));
            }
        }
        if ((dueDelay = row.getInt("DUE_DELAY")) > smsSet.getDueDelay()) {
            smsSet.setDueDelay(dueDelay);
        }
        if (alertingSupported = row.getBool("ALERTING_SUPPORTED")) {
            smsSet.setAlertingSupported(true);
        }
        smsSet.addSms(sms);
        return smsSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SmsSet> c2_sortRecordList(ArrayList<SmsSet> sourceLst) {
        FastMap res = new FastMap();
        for (SmsSet smsSet : sourceLst) {
            SmsSet smsSet2 = null;
            try {
                smsSet2 = (SmsSet)res.get((Object)smsSet.getTargetId());
            }
            catch (Throwable e) {
                boolean dd = false;
            }
            if (smsSet2 != null) {
                smsSet2.addSms(smsSet.getSms(0L));
                if (smsSet2.getCorrelationId() != null) continue;
                smsSet2.setCorrelationId(smsSet.getCorrelationId());
                continue;
            }
            res.put((Object)smsSet.getTargetId(), (Object)smsSet);
        }
        ArrayList<SmsSet> res2 = new ArrayList<SmsSet>();
        Date timeOutDate = new Date(new Date().getTime() - 1800000L);
        for (SmsSet smsSet : res.values()) {
            smsSet.resortSms();
            TargetAddress lock = SmsSetCache.getInstance().addSmsSet(new TargetAddress(smsSet));
            try {
                SmsSet smsSet2;
                TargetAddress targetAddress = lock;
                synchronized (targetAddress) {
                    smsSet2 = SmsSetCache.getInstance().getProcessingSmsSet(smsSet.getTargetId());
                    if (smsSet2 != null) {
                        if (smsSet2.getLastUpdateTime().after(timeOutDate)) {
                            smsSet2.addSmsSet(smsSet);
                        } else {
                            logger.warn((Object)("Timeout of SmsSet in ProcessingSmsSet: targetId=" + smsSet2.getTargetId() + ", messageCount=" + smsSet2.getSmsCount()));
                            smsSet2 = smsSet;
                            SmsSetCache.getInstance().addProcessingSmsSet(smsSet2.getTargetId(), smsSet2, this.processingSmsSetTimeout);
                        }
                    } else {
                        smsSet2 = smsSet;
                        SmsSetCache.getInstance().addProcessingSmsSet(smsSet2.getTargetId(), smsSet2, this.processingSmsSetTimeout);
                    }
                }
                res2.add(smsSet2);
            }
            finally {
                SmsSetCache.getInstance().removeSmsSet(lock);
            }
        }
        return res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean c2_checkProcessingSmsSet(SmsSet smsSet) {
        Date timeOutDate = new Date(new Date().getTime() - 1800000L);
        TargetAddress lock = SmsSetCache.getInstance().addSmsSet(new TargetAddress(smsSet));
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                SmsSet smsSet2 = SmsSetCache.getInstance().getProcessingSmsSet(smsSet.getTargetId());
                if (smsSet2 != null) {
                    if (smsSet2.getLastUpdateTime().after(timeOutDate)) {
                        smsSet2.addSmsSet(smsSet);
                        boolean bl = false;
                        return bl;
                    }
                    logger.warn((Object)("Timeout of SmsSet in ProcessingSmsSet: targetId=" + smsSet2.getTargetId() + ", messageCount=" + smsSet2.getSmsCount()));
                    smsSet2 = smsSet;
                    SmsSetCache.getInstance().addProcessingSmsSet(smsSet2.getTargetId(), smsSet2, this.processingSmsSetTimeout);
                } else {
                    smsSet2 = smsSet;
                    SmsSetCache.getInstance().addProcessingSmsSet(smsSet2.getTargetId(), smsSet2, this.processingSmsSetTimeout);
                }
                return true;
            }
        }
        finally {
            SmsSetCache.getInstance().removeSmsSet(lock);
        }
    }

    public void c2_updateInSystem(Sms sms, int isSystemStatus, boolean fastStoreAndForwordMode) throws PersistenceException {
        if (sms.getStored()) {
            PreparedStatementCollection psc = this.getStatementCollection(sms.getDueSlot());
            String targetId = sms.getTargetIdOnDeliveryStart() != null ? sms.getTargetIdOnDeliveryStart() : sms.getSmsSet().getTargetId();
            try {
                PreparedStatement ps = psc.updateInSystem;
                BoundStatement boundStatement = new BoundStatement(ps);
                boundStatement.bind(new Object[]{isSystemStatus, this.currentSessionUUID, sms.getDueSlot(), targetId, sms.getDbId()});
                ResultSet res = this.session.execute((Statement)boundStatement);
            }
            catch (Exception e1) {
                String msg = "Failed to execute updateInSystem() !";
                throw new PersistenceException(msg, e1);
            }
        }
    }

    public void c2_updateAlertingSupport(long dueSlot, String targetId, UUID dbId) throws PersistenceException {
        PreparedStatementCollection psc = this.getStatementCollection(dueSlot);
        try {
            PreparedStatement ps = psc.updateAlertingSupport;
            BoundStatement boundStatement = new BoundStatement(ps);
            boundStatement.bind(new Object[]{true, dueSlot, targetId, dbId});
            ResultSet res = this.session.execute((Statement)boundStatement);
        }
        catch (Exception e1) {
            String msg = "Failed to execute c2_updateAlertingSupport() !";
            throw new PersistenceException(msg, e1);
        }
    }

    public void createArchiveMessage(Sms sms) throws PersistenceException {
    }

    protected PreparedStatementCollection getStatementCollection(Date dt) throws PersistenceException {
        String tName = this.getTableName(dt);
        PreparedStatementCollection psc = (PreparedStatementCollection)this.dataTableRead.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        return this.doGetStatementCollection(tName);
    }

    protected PreparedStatementCollection getStatementCollection(long deuSlot) throws PersistenceException {
        String tName = this.getTableName(deuSlot);
        PreparedStatementCollection psc = (PreparedStatementCollection)this.dataTableRead.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        return this.doGetStatementCollection(tName);
    }

    private synchronized PreparedStatementCollection doGetStatementCollection(String tName) throws PersistenceException {
        String msg;
        ResultSet res;
        BoundStatement boundStatement;
        PreparedStatement ps;
        String s2;
        StringBuilder sb;
        PreparedStatement ps2;
        String s1;
        PreparedStatementCollection psc = (PreparedStatementCollection)this.dataTableRead.get((Object)tName);
        if (psc != null) {
            return psc;
        }
        try {
            try {
                s1 = "SELECT * FROM \"DST_SLOT_TABLE" + tName + "\";";
                ps2 = this.session.prepare(s1);
            }
            catch (InvalidQueryException e) {
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"DST_SLOT_TABLE");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "TARGET_ID", "ascii");
                this.appendField(sb, "DUE_SLOT", "bigint");
                sb.append("PRIMARY KEY (\"");
                sb.append("TARGET_ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"SLOT_MESSAGES_TABLE");
                sb.append(tName);
                sb.append("\" (");
                this.addSmsFields(sb);
                sb.append("PRIMARY KEY ((\"");
                sb.append("DUE_SLOT");
                sb.append("\"), \"");
                sb.append("TARGET_ID");
                sb.append("\", \"");
                sb.append("ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"MESSAGES");
                sb.append(tName);
                sb.append("\" (");
                this.addSmsFields(sb);
                sb.append("PRIMARY KEY ((\"");
                sb.append("ADDR_DST_DIGITS");
                sb.append("\"), \"");
                sb.append("ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            String msg2 = "Failed to access or create table " + tName + "!";
            throw new PersistenceException(msg2, e1);
        }
        try {
            try {
                s1 = "SELECT * FROM \"MES_ID" + tName + "\";";
                ps2 = this.session.prepare(s1);
            }
            catch (InvalidQueryException e) {
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"MES_ID");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "MESSAGE_ID", "bigint");
                this.appendField(sb, "ADDR_DST_DIGITS", "ascii");
                this.appendField(sb, "ID", "uuid");
                sb.append("PRIMARY KEY (\"");
                sb.append("MESSAGE_ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            msg = "Failed to access or create table " + tName + "!";
            throw new PersistenceException(msg, e1);
        }
        try {
            try {
                s1 = "SELECT * FROM \"DLV_MES_ID" + tName + "\";";
                ps2 = this.session.prepare(s1);
            }
            catch (InvalidQueryException e) {
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"DLV_MES_ID");
                sb.append(tName);
                sb.append("\" (");
                this.appendField(sb, "REMOTE_MESSAGE_ID", "ascii");
                this.appendField(sb, "DEST_ID", "ascii");
                this.appendField(sb, "MESSAGE_ID", "bigint");
                sb.append("PRIMARY KEY (\"");
                sb.append("REMOTE_MESSAGE_ID");
                sb.append("\", \"");
                sb.append("DEST_ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            msg = "Failed to access or create table " + tName + "!";
            throw new PersistenceException(msg, e1);
        }
        psc = new PreparedStatementCollection(this, tName, this.ttlCurrent, this.ttlArchive);
        this.dataTableRead.putEntry((Object)tName, (Object)psc);
        return psc;
    }

    protected void addSmsFields(StringBuilder sb) {
        this.appendField(sb, "ID", "uuid");
        this.appendField(sb, "TARGET_ID", "ascii");
        this.appendField(sb, "NETWORK_ID", "int");
        this.appendField(sb, "DUE_SLOT", "bigint");
        this.appendField(sb, "IN_SYSTEM", "int");
        this.appendField(sb, "SMSC_UUID", "uuid");
        this.appendField(sb, "ADDR_DST_DIGITS", "ascii");
        this.appendField(sb, "ADDR_DST_TON", "int");
        this.appendField(sb, "ADDR_DST_NPI", "int");
        this.appendField(sb, "ADDR_SRC_DIGITS", "ascii");
        this.appendField(sb, "ADDR_SRC_TON", "int");
        this.appendField(sb, "ADDR_SRC_NPI", "int");
        this.appendField(sb, "ORIG_NETWORK_ID", "int");
        this.appendField(sb, "DUE_DELAY", "int");
        this.appendField(sb, "ALERTING_SUPPORTED", "boolean");
        this.appendField(sb, "MESSAGE_ID", "bigint");
        this.appendField(sb, "MO_MESSAGE_REF", "int");
        this.appendField(sb, "ORIG_ESME_NAME", "text");
        this.appendField(sb, "ORIG_SYSTEM_ID", "text");
        this.appendField(sb, "DEST_CLUSTER_NAME", "text");
        this.appendField(sb, "DEST_ESME_NAME", "text");
        this.appendField(sb, "DEST_SYSTEM_ID", "text");
        this.appendField(sb, "SUBMIT_DATE", "timestamp");
        this.appendField(sb, "DELIVERY_DATE", "timestamp");
        this.appendField(sb, "SERVICE_TYPE", "text");
        this.appendField(sb, "ESM_CLASS", "int");
        this.appendField(sb, "PROTOCOL_ID", "int");
        this.appendField(sb, "PRIORITY", "int");
        this.appendField(sb, "REGISTERED_DELIVERY", "int");
        this.appendField(sb, "REPLACE", "int");
        this.appendField(sb, "DATA_CODING", "int");
        this.appendField(sb, "DEFAULT_MSG_ID", "int");
        this.appendField(sb, "MESSAGE", "blob");
        this.appendField(sb, "MESSAGE_TEXT", "text");
        this.appendField(sb, "MESSAGE_BIN", "blob");
        this.appendField(sb, "OPTIONAL_PARAMETERS", "text");
        this.appendField(sb, "SCHEDULE_DELIVERY_TIME", "timestamp");
        this.appendField(sb, "VALIDITY_PERIOD", "timestamp");
        this.appendField(sb, "IMSI", "ascii");
        this.appendField(sb, "CORR_ID", "ascii");
        this.appendField(sb, "NNN_DIGITS", "ascii");
        this.appendField(sb, "NNN_AN", "int");
        this.appendField(sb, "NNN_NP", "int");
        this.appendField(sb, "SM_STATUS", "int");
        this.appendField(sb, "SM_TYPE", "int");
        this.appendField(sb, "DELIVERY_COUNT", "int");
        this.appendField(sb, "ORIGINATOR_SCCP_ADDRESS", "ascii");
        this.appendField(sb, "STATUS_REPORT_REQUEST", "boolean");
        this.appendField(sb, "DELIVERY_ATTEMPT", "int");
        this.appendField(sb, "USER_DATA", "text");
        this.appendField(sb, "EXTRA_DATA", "text");
        this.appendField(sb, "EXTRA_DATA_2", "text");
        this.appendField(sb, "EXTRA_DATA_3", "text");
        this.appendField(sb, "EXTRA_DATA_4", "text");
    }

    private synchronized void checkCurrentSlotTableExists() throws PersistenceException {
        String msg;
        ResultSet res;
        BoundStatement boundStatement;
        PreparedStatement ps;
        String s2;
        StringBuilder sb;
        PreparedStatement ps2;
        String sa;
        try {
            try {
                sa = "SELECT \"NEXT_SLOT\" FROM \"CURRENT_SLOT_TABLE\" where \"ID\"=0;";
                ps2 = this.session.prepare(sa);
            }
            catch (InvalidQueryException e) {
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"");
                sb.append("CURRENT_SLOT_TABLE");
                sb.append("\" (");
                this.appendField(sb, "ID", "int");
                this.appendField(sb, "NEXT_SLOT", "bigint");
                sb.append("PRIMARY KEY (\"");
                sb.append("ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            String msg2 = "Failed to access or create table CURRENT_SLOT_TABLE!";
            throw new PersistenceException(msg2, e1);
        }
        try {
            try {
                sa = "SELECT \"ADDRESS\" FROM \"SMPP_SMS_ROUTING_RULE_2\" where \"ADDRESS\"='' and \"NETWORK_ID\"=0;";
                ps2 = this.session.prepare(sa);
            }
            catch (InvalidQueryException e) {
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"");
                sb.append("SMPP_SMS_ROUTING_RULE_2");
                sb.append("\" (");
                this.appendField(sb, "ADDRESS", "text");
                this.appendField(sb, "NETWORK_ID", "int");
                this.appendField(sb, "CLUSTER_NAME", "text");
                sb.append("PRIMARY KEY (\"");
                sb.append("ADDRESS");
                sb.append("\", \"");
                sb.append("NETWORK_ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            msg = "Failed to access or create table SMPP_SMS_ROUTING_RULE_2!";
            throw new PersistenceException(msg, e1);
        }
        try {
            try {
                sa = "SELECT \"ADDRESS\" FROM \"SIP_SMS_ROUTING_RULE_2\" where \"ADDRESS\"='' and \"NETWORK_ID\"=0;";
                ps2 = this.session.prepare(sa);
            }
            catch (InvalidQueryException e) {
                sb = new StringBuilder();
                sb.append("CREATE TABLE \"");
                sb.append("SIP_SMS_ROUTING_RULE_2");
                sb.append("\" (");
                this.appendField(sb, "ADDRESS", "text");
                this.appendField(sb, "NETWORK_ID", "int");
                this.appendField(sb, "CLUSTER_NAME", "text");
                sb.append("PRIMARY KEY (\"");
                sb.append("ADDRESS");
                sb.append("\", \"");
                sb.append("NETWORK_ID");
                sb.append("\"");
                sb.append("));");
                s2 = sb.toString();
                ps = this.session.prepare(s2);
                boundStatement = new BoundStatement(ps);
                res = this.session.execute((Statement)boundStatement);
            }
        }
        catch (Exception e1) {
            msg = "Failed to access or create table SIP_SMS_ROUTING_RULE_2!";
            throw new PersistenceException(msg, e1);
        }
    }

    protected void appendField(StringBuilder sb, String name, String type) {
        sb.append("\"");
        sb.append(name);
        sb.append("\" ");
        sb.append(type);
        sb.append(", ");
    }

    private void appendIndex(String tName, String fieldName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE INDEX ON \"");
        sb.append(tName);
        sb.append("\" (\"");
        sb.append(fieldName);
        sb.append("\");");
        String s2 = sb.toString();
        PreparedStatement ps = this.session.prepare(s2);
        BoundStatement boundStatement = new BoundStatement(ps);
        ResultSet res = this.session.execute((Statement)boundStatement);
    }

    public QuerySmResponse c2_getQuerySmResponse(long messageId) throws PersistenceException {
        Sms sms = this.c2_getRecordArchiveForMessageId(messageId);
        if (sms == null) {
            return new QuerySmResponse(MessageState.ENROUTE, null, 0);
        }
        ErrorCode code = sms.getSmsSet().getStatus();
        if (code == ErrorCode.SUCCESS) {
            return new QuerySmResponse(MessageState.DELIVERED, sms.getDeliverDate(), 0);
        }
        if (code == ErrorCode.VALIDITY_PERIOD_EXPIRED) {
            return new QuerySmResponse(MessageState.EXPIRED, sms.getDeliverDate(), code.getCode());
        }
        return new QuerySmResponse(MessageState.UNDELIVERABLE, sms.getDeliverDate(), code.getCode());
    }

    public DbSmsRoutingRule c2_getSmppSmsRoutingRule(String address, int networkId) throws PersistenceException {
        try {
            BoundStatement boundStatement = new BoundStatement(this.getSmppSmsRoutingRule);
            boundStatement.bind(new Object[]{address, networkId});
            ResultSet result = this.session.execute((Statement)boundStatement);
            Row row = result.one();
            if (row == null) {
                return null;
            }
            String name = row.getString("CLUSTER_NAME");
            DbSmsRoutingRule res = new DbSmsRoutingRule(SmsRoutingRuleType.SMPP, address, networkId, name);
            return res;
        }
        catch (Exception e) {
            String msg = "Failed to getSmppSmsRoutingRule for address=" + address + " networkId=" + networkId + " !";
            throw new PersistenceException(msg, e);
        }
    }

    public DbSmsRoutingRule c2_getSipSmsRoutingRule(String address, int networkId) throws PersistenceException {
        try {
            BoundStatement boundStatement = new BoundStatement(this.getSipSmsRoutingRule);
            boundStatement.bind(new Object[]{address, networkId});
            ResultSet result = this.session.execute((Statement)boundStatement);
            Row row = result.one();
            if (row == null) {
                return null;
            }
            String name = row.getString("CLUSTER_NAME");
            DbSmsRoutingRule res = new DbSmsRoutingRule(SmsRoutingRuleType.SIP, address, networkId, name);
            return res;
        }
        catch (Exception e) {
            String msg = "Failed to getSipSmsRoutingRule for address=" + address + " networkId=" + networkId + " !";
            throw new PersistenceException(msg, e);
        }
    }

    public void c2_updateSmppSmsRoutingRule(DbSmsRoutingRule dbSmsRoutingRule) throws PersistenceException {
        try {
            BoundStatement boundStatement = new BoundStatement(this.updateSmppSmsRoutingRule);
            boundStatement.bind(new Object[]{dbSmsRoutingRule.getAddress(), dbSmsRoutingRule.getNetworkId(), dbSmsRoutingRule.getClusterName()});
            this.session.execute((Statement)boundStatement);
        }
        catch (Exception e) {
            String msg = "Failed to updateSmppSmsRoutingRule for address=" + dbSmsRoutingRule.getAddress() + " networkId=" + dbSmsRoutingRule.getNetworkId() + " !";
            throw new PersistenceException(msg, e);
        }
    }

    public void c2_updateSipSmsRoutingRule(DbSmsRoutingRule dbSmsRoutingRule) throws PersistenceException {
        try {
            BoundStatement boundStatement = new BoundStatement(this.updateSipSmsRoutingRule);
            boundStatement.bind(new Object[]{dbSmsRoutingRule.getAddress(), dbSmsRoutingRule.getNetworkId(), dbSmsRoutingRule.getClusterName()});
            this.session.execute((Statement)boundStatement);
        }
        catch (Exception e) {
            String msg = "Failed to updateSipSmsRoutingRule for address=" + dbSmsRoutingRule.getAddress() + " networkId=" + dbSmsRoutingRule.getNetworkId() + " !";
            throw new PersistenceException(msg, e);
        }
    }

    public void c2_deleteSmppSmsRoutingRule(String address, int networkId) throws PersistenceException {
        try {
            BoundStatement boundStatement = new BoundStatement(this.deleteSmppSmsRoutingRule);
            boundStatement.bind(new Object[]{address, networkId});
            this.session.execute((Statement)boundStatement);
        }
        catch (Exception e) {
            String msg = "Failed to deleteSmppSmsRoutingRule for '" + address + "-" + networkId + "'!";
            throw new PersistenceException(msg, e);
        }
    }

    public void c2_deleteSipSmsRoutingRule(String address, int networkId) throws PersistenceException {
        try {
            BoundStatement boundStatement = new BoundStatement(this.deleteSipSmsRoutingRule);
            boundStatement.bind(new Object[]{address, networkId});
            this.session.execute((Statement)boundStatement);
        }
        catch (Exception e) {
            String msg = "Failed to deleteSipSmsRoutingRule for '" + address + "-" + networkId + "'!";
            throw new PersistenceException(msg, e);
        }
    }

    public List<DbSmsRoutingRule> c2_getSmppSmsRoutingRulesRange() throws PersistenceException {
        return this.c2_getSmppSmsRoutingRulesRange(null);
    }

    public List<DbSmsRoutingRule> c2_getSmppSmsRoutingRulesRange(String lastAdress) throws PersistenceException {
        FastList ress = new FastList();
        try {
            PreparedStatement ps = lastAdress != null ? this.getSmppSmsRoutingRulesRange : this.getSmppSmsRoutingRulesRange2;
            BoundStatement boundStatement = new BoundStatement(ps);
            if (lastAdress != null) {
                boundStatement.bind(new Object[]{lastAdress});
            }
            ResultSet result = this.session.execute((Statement)boundStatement);
            boolean i1 = false;
            for (Row row : result) {
                String address = row.getString("ADDRESS");
                String name = row.getString("CLUSTER_NAME");
                int networkId = row.getInt("NETWORK_ID");
                DbSmsRoutingRule res = new DbSmsRoutingRule(SmsRoutingRuleType.SMPP, address, networkId, name);
                if (!i1) {
                    i1 = true;
                    if (lastAdress != null) continue;
                    ress.add(res);
                    continue;
                }
                ress.add(res);
            }
            return ress;
        }
        catch (Exception e) {
            String msg = "Failed to getSmsRoutingRule DbSmsRoutingRule for all records: " + e;
            throw new PersistenceException(msg, e);
        }
    }

    public List<DbSmsRoutingRule> c2_getSipSmsRoutingRulesRange() throws PersistenceException {
        return this.c2_getSipSmsRoutingRulesRange(null);
    }

    public List<DbSmsRoutingRule> c2_getSipSmsRoutingRulesRange(String lastAdress) throws PersistenceException {
        FastList ress = new FastList();
        try {
            PreparedStatement ps = lastAdress != null ? this.getSipSmsRoutingRulesRange : this.getSipSmsRoutingRulesRange2;
            BoundStatement boundStatement = new BoundStatement(ps);
            if (lastAdress != null) {
                boundStatement.bind(new Object[]{lastAdress});
            }
            ResultSet result = this.session.execute((Statement)boundStatement);
            boolean i1 = false;
            for (Row row : result) {
                String address = row.getString("ADDRESS");
                String name = row.getString("CLUSTER_NAME");
                int networkId = row.getInt("NETWORK_ID");
                DbSmsRoutingRule res = new DbSmsRoutingRule(SmsRoutingRuleType.SIP, address, networkId, name);
                if (!i1) {
                    i1 = true;
                    if (lastAdress != null) continue;
                    ress.add(res);
                    continue;
                }
                ress.add(res);
            }
            return ress;
        }
        catch (Exception e) {
            String msg = "Failed to getSmsRoutingRule DbSmsRoutingRule for all records: " + e;
            throw new PersistenceException(msg, e);
        }
    }

    public boolean c2_deleteLiveTablesForDate(Date dt) {
        CheckDeletingDateResult res = this.checkDeletingDate(dt, "live cassandra tables");
        switch (res) {
            case permFailure: {
                return true;
            }
            case tempFailure: {
                return false;
            }
        }
        String tName = "DST_SLOT_TABLE" + this.getTableName(dt);
        this.doDeleteTable(tName);
        tName = "SLOT_MESSAGES_TABLE" + this.getTableName(dt);
        this.doDeleteTable(tName);
        String tName2 = this.getTableName(dt);
        this.dataTableRead.remove((Object)tName2);
        return true;
    }

    public boolean c2_deleteArchiveTablesForDate(Date dt) {
        CheckDeletingDateResult res = this.checkDeletingDate(dt, "archive cassandra tables");
        switch (res) {
            case permFailure: {
                return true;
            }
            case tempFailure: {
                return false;
            }
        }
        String tName = "MESSAGES" + this.getTableName(dt);
        this.doDeleteTable(tName);
        tName = "MES_ID" + this.getTableName(dt);
        this.doDeleteTable(tName);
        tName = "DLV_MES_ID" + this.getTableName(dt);
        this.doDeleteTable(tName);
        String tName2 = this.getTableName(dt);
        this.dataTableRead.remove((Object)tName2);
        return true;
    }

    private CheckDeletingDateResult checkDeletingDate(Date dt, String taskName) {
        int maxBackupsDays = 2;
        Date curTime = new Date();
        Date curDate = new Date(curTime.getYear(), curTime.getMonth(), curTime.getDate());
        Date maxDate = new Date(curDate.getTime() - (long)(maxBackupsDays * 24 * 3600 * 1000));
        if (!dt.before(maxDate)) {
            logger.warn((Object)("Rejected an attempt of dropping of " + taskName + " for too late date: " + dt));
            return CheckDeletingDateResult.permFailure;
        }
        Date procDate = this.c2_getTimeForDueSlot(this.c2_getCurrentDueSlot());
        if (procDate.getYear() != curDate.getYear() || procDate.getMonth() != curDate.getMonth() || procDate.getDate() != curDate.getDate()) {
            logger.warn((Object)("Rejected an attempt of dropping of " + taskName + " for old message data are still in processing: " + dt));
            return CheckDeletingDateResult.tempFailure;
        }
        return CheckDeletingDateResult.success;
    }

    private void doDeleteTable(String tName) {
        BoundStatement boundStatement;
        PreparedStatement ps;
        try {
            String sa = "select * from \"" + tName + "\" limit 1";
            ps = this.session.prepare(sa);
            boundStatement = new BoundStatement(ps);
            this.session.execute((Statement)boundStatement);
        }
        catch (Exception e) {
            logger.info((Object)("Can not drop cassandra table because it is absent: " + tName));
            return;
        }
        try {
            String sb = "DROP TABLE \"" + tName + "\"";
            ps = this.session.prepare(sb);
            boundStatement = new BoundStatement(ps);
            this.session.execute((Statement)boundStatement);
            logger.warn((Object)("Successfully dropped cassandra table: " + tName));
        }
        catch (Exception e) {
            logger.warn((Object)("Exception when dropping cassandra table: " + tName), (Throwable)e);
        }
    }

    public Date[] c2_getLiveTableList(String keyspace) {
        String[] ss = this.c2_getTableList(keyspace);
        FastMap res = new FastMap();
        for (String s : ss) {
            int day;
            int mon;
            int year;
            String sDay;
            String sMon;
            String sYear;
            Date dt = null;
            if (s.startsWith("DST_SLOT_TABLE") && s.length() == 25) {
                sYear = s.substring(15, 19);
                sMon = s.substring(20, 22);
                sDay = s.substring(23, 25);
                try {
                    year = Integer.parseInt(sYear);
                    mon = Integer.parseInt(sMon);
                    day = Integer.parseInt(sDay);
                    dt = new Date(year - 1900, mon - 1, day);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (s.startsWith("SLOT_MESSAGES_TABLE") && s.length() == 30) {
                sYear = s.substring(20, 24);
                sMon = s.substring(25, 27);
                sDay = s.substring(28, 30);
                try {
                    year = Integer.parseInt(sYear);
                    mon = Integer.parseInt(sMon);
                    day = Integer.parseInt(sDay);
                    dt = new Date(year - 1900, mon - 1, day);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (dt == null) continue;
            res.put(dt, dt);
        }
        Object[] dd = new Date[res.size()];
        int i1 = 0;
        for (Date dt : res.keySet()) {
            dd[i1++] = dt;
        }
        Arrays.sort(dd);
        return dd;
    }

    public Date[] c2_getArchiveTableList(String keyspace) {
        String[] ss = this.c2_getTableList(keyspace);
        FastMap res = new FastMap();
        for (String s : ss) {
            int day;
            int mon;
            int year;
            String sDay;
            String sMon;
            String sYear;
            Date dt = null;
            if (s.startsWith("MESSAGES") && s.length() == 19) {
                sYear = s.substring(9, 13);
                sMon = s.substring(14, 16);
                sDay = s.substring(17, 19);
                try {
                    year = Integer.parseInt(sYear);
                    mon = Integer.parseInt(sMon);
                    day = Integer.parseInt(sDay);
                    dt = new Date(year - 1900, mon - 1, day);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (s.startsWith("MES_ID") && s.length() == 17) {
                sYear = s.substring(7, 11);
                sMon = s.substring(12, 14);
                sDay = s.substring(15, 17);
                try {
                    year = Integer.parseInt(sYear);
                    mon = Integer.parseInt(sMon);
                    day = Integer.parseInt(sDay);
                    dt = new Date(year - 1900, mon - 1, day);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (s.startsWith("DLV_MES_ID") && s.length() == 21) {
                sYear = s.substring(11, 15);
                sMon = s.substring(16, 18);
                sDay = s.substring(19, 21);
                try {
                    int year2 = Integer.parseInt(sYear);
                    mon = Integer.parseInt(sMon);
                    day = Integer.parseInt(sDay);
                    dt = new Date(year2 - 1900, mon - 1, day);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (dt == null) continue;
            res.put(dt, dt);
        }
        Object[] dd = new Date[res.size()];
        int i1 = 0;
        for (Date dt : res.keySet()) {
            dd[i1++] = dt;
        }
        Arrays.sort(dd);
        return dd;
    }

    public String[] c2_getTableList(String keyspace) {
        List lst = this.cluster.getMetadata().getKeyspaces();
        String[] ss = new String[]{};
        for (KeyspaceMetadata km : lst) {
            if (!km.getName().equals(keyspace)) continue;
            Collection lstTableMetadata = km.getTables();
            ss = new String[lstTableMetadata.size()];
            int i1 = 0;
            for (TableMetadata tm : lstTableMetadata) {
                ss[i1++] = tm.getName();
            }
        }
        return ss;
    }

    private String[] getDueSlotTableListAsNames(String keyspace) {
        String[] ss = this.c2_getTableList(keyspace);
        ArrayList<String> res = new ArrayList<String>();
        for (String s : ss) {
            if (!s.startsWith("DST_SLOT_TABLE_") || s.length() != 25) continue;
            res.add(s);
        }
        Object[] sss = new String[res.size()];
        res.toArray(sss);
        Arrays.sort(sss);
        return sss;
    }

    protected String[] getLiveTableListAsNames(String keyspace) {
        String[] ss = this.c2_getTableList(keyspace);
        ArrayList<String> res = new ArrayList<String>();
        for (String s : ss) {
            if (!s.startsWith("SLOT_MESSAGES_TABLE_") || s.length() != 30) continue;
            res.add(s);
        }
        Object[] sss = new String[res.size()];
        res.toArray(sss);
        Arrays.sort(sss);
        return sss;
    }

    private String[] getArchiveTableListAsNames(String keyspace) {
        String[] ss = this.c2_getTableList(keyspace);
        ArrayList<String> res = new ArrayList<String>();
        for (String s : ss) {
            Object dt = null;
            if (!s.startsWith("MESSAGES_") || s.length() != 19) continue;
            res.add(s);
        }
        Object[] sss = new String[res.size()];
        res.toArray(sss);
        Arrays.sort(sss);
        return sss;
    }

    private class DueSlotWritingElement {
        public long dueSlot;
        public int writingCount;
        public Date lastStartDate;

        public DueSlotWritingElement(long dueSlot) {
            this.dueSlot = dueSlot;
        }
    }

    static enum CheckDeletingDateResult {
        success,
        permFailure,
        tempFailure;

    }
}

