/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.common.ra;

import java.util.concurrent.ConcurrentHashMap;
import javax.slee.EventTypeID;
import javax.slee.facilities.EventLookupFacility;
import javax.slee.facilities.Tracer;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.ResourceAdaptorContext;

public class EventIDCache {
    private ConcurrentHashMap<String, FireableEventType> eventIds = new ConcurrentHashMap();
    private final String eventVendor;
    private final String eventVersion;
    private Tracer tracer;
    private EventLookupFacility eventLookupFacility;

    public EventIDCache(ResourceAdaptorContext raContext, String vendor, String version) {
        this.tracer = raContext.getTracer(EventIDCache.class.getSimpleName());
        this.eventLookupFacility = raContext.getEventLookupFacility();
        this.eventVendor = vendor;
        this.eventVersion = version;
    }

    public FireableEventType getEventId(String eventName) {
        FireableEventType eventType = this.eventIds.get(eventName);
        if (eventType == null) {
            try {
                eventType = this.eventLookupFacility.getFireableEventType(new EventTypeID(eventName, this.eventVendor, this.eventVersion));
            }
            catch (Throwable e) {
                this.tracer.severe("Error while looking up for SMPP Server Events", e);
            }
            if (eventType != null) {
                this.eventIds.put(eventName, eventType);
            }
        }
        return eventType;
    }
}

