/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.smsc.slee.services.alert;

import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.EventContext;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.ServiceID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParameterFactory;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.mobicents.slee.SbbContextExt;
import org.mobicents.slee.resource.map.MAPContextInterfaceFactory;
import org.mobicents.slee.resource.map.events.DialogAccept;
import org.mobicents.slee.resource.map.events.DialogClose;
import org.mobicents.slee.resource.map.events.DialogDelimiter;
import org.mobicents.slee.resource.map.events.DialogNotice;
import org.mobicents.slee.resource.map.events.DialogProviderAbort;
import org.mobicents.slee.resource.map.events.DialogReject;
import org.mobicents.slee.resource.map.events.DialogRelease;
import org.mobicents.slee.resource.map.events.DialogRequest;
import org.mobicents.slee.resource.map.events.DialogTimeout;
import org.mobicents.slee.resource.map.events.DialogUserAbort;
import org.mobicents.slee.resource.map.events.ErrorComponent;
import org.mobicents.slee.resource.map.events.InvokeTimeout;
import org.mobicents.slee.resource.map.events.RejectComponent;
import org.mobicents.smsc.cassandra.PersistenceException;
import org.mobicents.smsc.domain.SmscPropertiesManagement;
import org.mobicents.smsc.library.SbbStates;
import org.mobicents.smsc.library.Sms;
import org.mobicents.smsc.library.SmsSet;
import org.mobicents.smsc.library.SmsSetCache;
import org.mobicents.smsc.library.TargetAddress;
import org.mobicents.smsc.slee.resources.persistence.PersistenceRAInterface;
import org.mobicents.smsc.slee.resources.scheduler.SchedulerRaSbbInterface;

public abstract class AlertSbb
implements Sbb {
    private static final ResourceAdaptorTypeID PERSISTENCE_ID = new ResourceAdaptorTypeID("PersistenceResourceAdaptorType", "org.mobicents", "1.0");
    private static final String PERSISTENCE_LINK = "PersistenceResourceAdaptor";
    private static final ResourceAdaptorTypeID SCHEDULER_ID = new ResourceAdaptorTypeID("SchedulerResourceAdaptorType", "org.mobicents", "1.0");
    private static final String SCHEDULER_LINK = "SchedulerResourceAdaptor";
    protected Tracer logger;
    protected SbbContextExt sbbContext;
    protected MAPContextInterfaceFactory mapAcif;
    protected MAPProvider mapProvider;
    protected MAPParameterFactory mapParameterFactory;
    protected PersistenceRAInterface persistence;
    protected SchedulerRaSbbInterface scheduler = null;

    public PersistenceRAInterface getStore() {
        return this.persistence;
    }

    public void onInvokeTimeout(InvokeTimeout evt, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onInvokeTimeout" + evt);
    }

    public void onErrorComponent(ErrorComponent event, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onErrorComponent" + event);
    }

    public void onRejectComponent(RejectComponent event, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onRejectComponent" + event);
    }

    public void onDialogDelimiter(DialogDelimiter evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogDelimiter=" + evt);
        }
    }

    public void onDialogAccept(DialogAccept evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogAccept=" + evt);
        }
    }

    public void onDialogReject(DialogReject evt, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogReject=" + evt);
    }

    public void onDialogUserAbort(DialogUserAbort evt, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogUserAbort=" + evt);
    }

    public void onDialogProviderAbort(DialogProviderAbort evt, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogProviderAbort=" + evt);
    }

    public void onDialogClose(DialogClose evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogClose" + evt);
        }
    }

    public void onDialogNotice(DialogNotice evt, ActivityContextInterface aci) {
        if (this.logger.isWarningEnabled()) {
            this.logger.warning("\nRx :  onDialogNotice" + evt);
        }
    }

    public void onDialogTimeout(DialogTimeout evt, ActivityContextInterface aci) {
        this.logger.severe("\nRx :  onDialogTimeout" + evt);
    }

    public void onDialogRequest(DialogRequest evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogRequest" + evt);
        }
    }

    public void onDialogRelease(DialogRelease evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nRx :  onDialogRelease" + evt);
        }
    }

    public void onAlertServiceCentreRequest(AlertServiceCentreRequest evt, ActivityContextInterface aci) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("\nReceived onAlertServiceCentreRequest= " + evt);
        }
        try {
            MAPDialogSms mapDialogSms = evt.getMAPDialog();
            MAPApplicationContext mapApplicationContext = mapDialogSms.getApplicationContext();
            if (mapApplicationContext.getApplicationContextVersion() == MAPApplicationContextVersion.version2) {
                mapDialogSms.addAlertServiceCentreResponse(evt.getInvokeId());
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("\nSending AlertServiceCentreResponse");
                }
                mapDialogSms.close(false);
            } else {
                mapDialogSms.release();
            }
            this.setupAlert(evt.getMsisdn(), evt.getServiceCentreAddress(), mapDialogSms.getNetworkId());
        }
        catch (MAPException e) {
            this.logger.severe("Exception while trying to send back AlertServiceCentreResponse", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupAlert(ISDNAddressString msisdn, AddressString serviceCentreAddress, int networkId) {
        PersistenceRAInterface pers = this.getStore();
        SmscPropertiesManagement smscPropertiesManagement = SmscPropertiesManagement.getInstance();
        if (smscPropertiesManagement.isDeliveryPause()) {
            return;
        }
        if (!pers.isDatabaseAvailable()) {
            return;
        }
        int addrTon = msisdn.getAddressNature().getIndicator();
        int addrNpi = msisdn.getNumberingPlan().getIndicator();
        String addr = msisdn.getAddress();
        TargetAddress lock = pers.obtainSynchroObject(new TargetAddress(addrTon, addrNpi, addr, networkId));
        try {
            TargetAddress targetAddress = lock;
            synchronized (targetAddress) {
                block29: {
                    SmsSet smsSet0;
                    long dueSlot;
                    block28: {
                        dueSlot = 0L;
                        smsSet0 = new SmsSet();
                        smsSet0.setDestAddr(addr);
                        smsSet0.setDestAddrNpi(addrNpi);
                        smsSet0.setDestAddrTon(addrTon);
                        smsSet0.setNetworkId(networkId);
                        SmsSet smsSet1 = SmsSetCache.getInstance().getProcessingSmsSet(smsSet0.getTargetId());
                        if (smsSet1 == null) break block28;
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info(String.format("\nReceived AlertServiceCentre for MSISDN=%s but the delivering for this dest is already in progress", addr));
                        }
                        return;
                    }
                    try {
                        dueSlot = pers.c2_getDueSlotForTargetId(smsSet0.getTargetId());
                        if (dueSlot != 0L && dueSlot > pers.c2_getCurrentDueSlot() && pers.c2_checkDueSlotWritingPossibility(dueSlot) == dueSlot) {
                            pers.c2_registerDueSlotWriting(dueSlot);
                            try {
                                if (dueSlot != 0L && dueSlot > pers.c2_getCurrentDueSlot()) {
                                    SmsSet smsSet = pers.c2_getRecordListForTargeId(dueSlot, smsSet0.getTargetId());
                                    if (smsSet != null) {
                                        if (this.logger.isInfoEnabled()) {
                                            this.logger.info(String.format("\nReceived AlertServiceCentre for MSISDN=%s, SmsSet was loaded with %d messages", addr, smsSet.getSmsCount()));
                                        }
                                        int i1 = 0;
                                        while ((long)i1 < smsSet.getSmsCount()) {
                                            Sms sms = smsSet.getSms((long)i1);
                                            sms.setInvokedByAlert(true);
                                            ++i1;
                                        }
                                        ArrayList<SmsSet> lstS = new ArrayList<SmsSet>();
                                        lstS.add(smsSet);
                                        ArrayList lst = pers.c2_sortRecordList(lstS);
                                        if (lst.size() > 0) {
                                            smsSet = (SmsSet)lst.get(0);
                                            smsSet.setProcessingStarted();
                                            this.scheduler.injectSmsDatabase(smsSet);
                                        }
                                    } else if (this.logger.isInfoEnabled()) {
                                        this.logger.info(String.format("\nReceived AlertServiceCentre for MSISDN=%s, dueSlot was scheduled but no SmsSet was loaded", addr));
                                    }
                                } else if (this.logger.isInfoEnabled()) {
                                    this.logger.info(String.format("\nReceived AlertServiceCentre for MSISDN=%s but no dueSlot was scheduled or the scheduled dueSlot will come soon - 2", addr));
                                }
                                break block29;
                            }
                            finally {
                                pers.c2_unregisterDueSlotWriting(dueSlot);
                            }
                        }
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info(String.format("\nReceived AlertServiceCentre for MSISDN=%s but no dueSlot was scheduled or the scheduled dueSlot will come soon - 1", addr));
                        }
                    }
                    catch (PersistenceException e) {
                        this.logger.severe("PersistenceException when setupAlert()" + e.getMessage(), (Throwable)e);
                    }
                    catch (Exception e) {
                        this.logger.severe("Exception when setupAlert()" + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        finally {
            pers.releaseSynchroObject(lock);
        }
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = (SbbContextExt)sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.mapAcif = (MAPContextInterfaceFactory)ctx.lookup("slee/resources/map/2.0/acifactory");
            this.mapProvider = (MAPProvider)ctx.lookup("slee/resources/map/2.0/provider");
            this.mapParameterFactory = this.mapProvider.getMAPParameterFactory();
            this.logger = this.sbbContext.getTracer(AlertSbb.class.getSimpleName());
            this.persistence = (PersistenceRAInterface)this.sbbContext.getResourceAdaptorInterface(PERSISTENCE_ID, PERSISTENCE_LINK);
            this.scheduler = (SchedulerRaSbbInterface)this.sbbContext.getResourceAdaptorInterface(SCHEDULER_ID, SCHEDULER_LINK);
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci, EventContext eventContext) {
        ServiceID serviceID = event.getService();
        this.logger.info("Rx: onServiceStartedEvent: event=" + event + ", serviceID=" + serviceID);
        SbbStates.setAlertServiceState((boolean)true);
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci, EventContext eventContext) {
        boolean isServiceActivity = aci.getActivity() instanceof ServiceActivity;
        if (isServiceActivity) {
            this.logger.info("Rx: onActivityEndEvent: event=" + event + ", isServiceActivity=" + isServiceActivity);
            SbbStates.setAlertServiceState((boolean)false);
        }
    }

    public InitialEventSelector initialEventSelect(InitialEventSelector ies) {
        Object event = ies.getEvent();
        DialogRequest dialogRequest = null;
        if (event instanceof DialogRequest) {
            dialogRequest = (DialogRequest)event;
            if (MAPApplicationContextName.shortMsgAlertContext == dialogRequest.getMAPDialog().getApplicationContext().getApplicationContextName()) {
                ies.setInitialEvent(true);
                ies.setActivityContextSelected(true);
            } else {
                ies.setInitialEvent(false);
            }
        }
        return ies;
    }
}

