/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.client.slee.resource.http;

import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.StartActivityException;
import net.java.client.slee.resource.http.HttpClientActivity;
import net.java.client.slee.resource.http.HttpClientResourceAdaptorSbbInterface;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.mobicents.client.slee.resource.http.HttpClientActivityHandle;
import org.mobicents.client.slee.resource.http.HttpClientActivityImpl;
import org.mobicents.client.slee.resource.http.HttpClientResourceAdaptor;
import org.mobicents.client.slee.resource.http.HttpClientWrapper;

public class HttpClientResourceAdaptorSbbInterfaceImpl
implements HttpClientResourceAdaptorSbbInterface {
    private static final int ACTIVITY_FLAGS = 2;
    private final Tracer tracer;
    private final HttpClientResourceAdaptor ra;

    public HttpClientResourceAdaptorSbbInterfaceImpl(HttpClientResourceAdaptor ra) {
        this.ra = ra;
        this.tracer = ra.getResourceAdaptorContext().getTracer(HttpClientResourceAdaptorSbbInterfaceImpl.class.getName());
    }

    public HttpClient getHttpClient() {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("getHttpClient()");
        }
        if (!this.ra.isActive) {
            throw new IllegalStateException("ra is not in active state");
        }
        return new HttpClientWrapper(this.ra.httpclient);
    }

    public HttpClientActivity createHttpClientActivity(boolean endOnReceivingResponse, HttpContext context) throws StartActivityException {
        if (this.tracer.isFinestEnabled()) {
            this.tracer.finest("createHttpClientActivity(endOnReceivingResponse=" + endOnReceivingResponse + ",context=" + context + ")");
        }
        if (!this.ra.isActive) {
            throw new IllegalStateException("ra is not in active state");
        }
        if (context == null) {
            context = new BasicHttpContext();
        }
        if (context.getAttribute("http.cookie-store") == null) {
            BasicCookieStore cookieStore = new BasicCookieStore();
            context.setAttribute("http.cookie-store", (Object)cookieStore);
        }
        HttpClientActivityImpl activity = new HttpClientActivityImpl(this.ra, endOnReceivingResponse, context);
        HttpClientActivityHandle handle = new HttpClientActivityHandle(activity.getSessionId());
        this.ra.getResourceAdaptorContext().getSleeEndpoint().startActivitySuspended((ActivityHandle)handle, (Object)activity, 2);
        this.ra.addActivity(handle, activity);
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Started activity " + activity.getSessionId() + ", context is " + context + ", endOnReceivingResponse is " + endOnReceivingResponse);
        }
        return activity;
    }
}

