/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.client.slee.resource.http;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.slee.Address;
import javax.slee.EventTypeID;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import net.java.client.slee.resource.http.HttpClientActivity;
import net.java.client.slee.resource.http.HttpClientResourceAdaptorSbbInterface;
import net.java.client.slee.resource.http.event.ResponseEvent;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.mobicents.client.slee.resource.http.HttpClientActivityHandle;
import org.mobicents.client.slee.resource.http.HttpClientActivityImpl;
import org.mobicents.client.slee.resource.http.HttpClientFactory;
import org.mobicents.client.slee.resource.http.HttpClientResourceAdaptorSbbInterfaceImpl;

public class HttpClientResourceAdaptor
implements ResourceAdaptor {
    private static final int EVENT_FLAGS = 128;
    private static final String CFG_PROPERTY_HTTP_CLIENT_FACTORY = "HTTP_CLIENT_FACTORY";
    private static final String CFG_PROPERTY_MAX_CONNECTIONS_FOR_ROUTES = "MAX_CONNECTIONS_FOR_ROUTES";
    private static final String CFG_PROPERTY_MAX_CONNECTIONS_TOTAL = "MAX_CONNECTIONS_TOTAL";
    private static final int HTTP_SCHEME_INDEX = 0;
    private static final int HTTP_HOST_INDEX = 1;
    private static final int HTTP_PORT_INDEX = 2;
    private static final int HTTP_MAXFORROUTE_INDEX = 3;
    private static final int MAX_CONNECTIONS_FOR_ROUTES_TOKEN_LENGTH = 4;
    protected ResourceAdaptorContext resourceAdaptorContext;
    private ConcurrentHashMap<HttpClientActivityHandle, HttpClientActivity> activities;
    private HttpClientResourceAdaptorSbbInterface sbbInterface;
    private ExecutorService executorService;
    private Tracer tracer;
    protected HttpClient httpclient;
    protected volatile boolean isActive = false;
    private FireableEventType fireableEventType;
    private int maxTotal;
    private Map<HttpRoute, Integer> maxForRoutes;
    private HttpClientFactory httpClientFactory;

    public void setResourceAdaptorContext(ResourceAdaptorContext arg0) {
        this.resourceAdaptorContext = arg0;
        this.tracer = this.resourceAdaptorContext.getTracer(HttpClientResourceAdaptor.class.getSimpleName());
        try {
            this.fireableEventType = this.resourceAdaptorContext.getEventLookupFacility().getFireableEventType(new EventTypeID("net.java.client.slee.resource.http.event.ResponseEvent", "net.java.client.slee", "4.0"));
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        this.sbbInterface = new HttpClientResourceAdaptorSbbInterfaceImpl(this);
    }

    public void raConfigure(ConfigProperties properties) {
        String httpClientFactoryClassName = (String)properties.getProperty(CFG_PROPERTY_HTTP_CLIENT_FACTORY).getValue();
        if (httpClientFactoryClassName.isEmpty()) {
            String[] maxForRoutesStrings;
            this.maxTotal = (Integer)properties.getProperty(CFG_PROPERTY_MAX_CONNECTIONS_TOTAL).getValue();
            this.maxForRoutes = new HashMap<HttpRoute, Integer>();
            String maxForRoutesString = (String)properties.getProperty(CFG_PROPERTY_MAX_CONNECTIONS_FOR_ROUTES).getValue();
            for (String maxForRoute : maxForRoutesStrings = maxForRoutesString.split(",")) {
                if (maxForRoute.isEmpty()) continue;
                String[] maxForRouteParts = maxForRoute.split(":");
                String scheme = maxForRouteParts[0];
                if (scheme == null || scheme.equals("")) {
                    scheme = "http";
                }
                String host = maxForRouteParts[1];
                String portStr = maxForRouteParts[2];
                if (portStr == null || portStr.equals("")) {
                    portStr = "80";
                }
                int port = Integer.parseInt(portStr);
                String maxForRoutePartsStr = maxForRouteParts[3];
                Integer max = Integer.valueOf(maxForRoutePartsStr);
                HttpRoute httpRoute = new HttpRoute(new HttpHost(host, port, scheme));
                this.maxForRoutes.put(httpRoute, max);
            }
        } else {
            try {
                this.httpClientFactory = (HttpClientFactory)Class.forName(httpClientFactoryClassName).newInstance();
            }
            catch (Exception e) {
                this.tracer.severe("failed to load http client factory class", (Throwable)e);
            }
        }
    }

    public void raActive() {
        this.activities = new ConcurrentHashMap();
        this.executorService = Executors.newCachedThreadPool();
        if (this.httpClientFactory != null) {
            this.httpclient = this.httpClientFactory.newHttpClient();
        } else {
            SyncBasicHttpParams params = new SyncBasicHttpParams();
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
            ThreadSafeClientConnManager threadSafeClientConnManager = new ThreadSafeClientConnManager(schemeRegistry);
            threadSafeClientConnManager.setMaxTotal(this.maxTotal);
            for (Map.Entry<HttpRoute, Integer> entry : this.maxForRoutes.entrySet()) {
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info(String.format("Configuring MaxForRoute %s max %d", entry.getKey(), entry.getValue()));
                }
                threadSafeClientConnManager.setMaxForRoute(entry.getKey(), entry.getValue().intValue());
            }
            this.httpclient = new DefaultHttpClient((ClientConnectionManager)threadSafeClientConnManager, (HttpParams)params);
        }
        this.isActive = true;
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info(String.format("HttpClientResourceAdaptor=%s entity activated.", this.resourceAdaptorContext.getEntityName()));
        }
    }

    public void raStopping() {
        this.isActive = false;
    }

    public void raInactive() {
        this.isActive = false;
        this.activities.clear();
        this.activities = null;
        this.executorService.shutdown();
        this.executorService = null;
        this.httpclient.getConnectionManager().shutdown();
        this.httpclient = null;
    }

    public void raUnconfigure() {
    }

    public void unsetResourceAdaptorContext() {
        this.resourceAdaptorContext = null;
        this.tracer = null;
        this.sbbInterface = null;
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        String httpClientFactoryClassName = (String)properties.getProperty(CFG_PROPERTY_HTTP_CLIENT_FACTORY).getValue();
        if (httpClientFactoryClassName.isEmpty()) {
            try {
                Integer i = (Integer)properties.getProperty(CFG_PROPERTY_MAX_CONNECTIONS_TOTAL).getValue();
                if (i < 1) {
                    throw new InvalidConfigurationException("MAX_CONNECTIONS_TOTAL must be > 0");
                }
            }
            catch (InvalidConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                this.tracer.severe("failure in config validation", (Throwable)e);
                throw new InvalidConfigurationException(e.getMessage());
            }
            try {
                String[] maxForRoutesStrings;
                String maxForRoutesString = (String)properties.getProperty(CFG_PROPERTY_MAX_CONNECTIONS_FOR_ROUTES).getValue();
                for (String maxForRoute : maxForRoutesStrings = maxForRoutesString.split(",")) {
                    String host;
                    if (maxForRoute.isEmpty()) continue;
                    String[] maxForRouteParts = maxForRoute.split(":");
                    if (maxForRouteParts.length != 4) {
                        throw new InvalidConfigurationException("MAX_CONNECTIONS_FOR_ROUTES format is scheme:host:port:maxForRoute separated by comma");
                    }
                    String scheme = maxForRouteParts[0];
                    if (scheme == null || scheme.equals("")) {
                        scheme = "http";
                    }
                    if ((host = maxForRouteParts[1]) == null || host.equals("")) {
                        throw new InvalidConfigurationException("MAX_CONNECTIONS_FOR_ROUTES format is scheme:host:port:maxForRoute separated by comma. Passing host is mandatory");
                    }
                    String portStr = maxForRouteParts[2];
                    if (portStr == null || portStr.equals("")) {
                        portStr = "80";
                    }
                    int port = Integer.parseInt(portStr);
                    String maxForRoutePartsStr = maxForRouteParts[3];
                    Integer max = Integer.valueOf(maxForRoutePartsStr);
                    if (max < 1) {
                        throw new InvalidConfigurationException("MAX_CONNECTIONS_FOR_ROUTES format is scheme:host:port:maxForRoute separated by comma. Passing maxForRoute is mandatory and must be greater than 0");
                    }
                    new HttpRoute(new HttpHost(host, port, scheme));
                }
            }
            catch (InvalidConfigurationException e) {
                throw e;
            }
            catch (Exception e) {
                this.tracer.severe("failure in config validation", (Throwable)e);
                throw new InvalidConfigurationException(e.getMessage());
            }
        }
        try {
            Class<?> c = Class.forName(httpClientFactoryClassName);
            c.newInstance();
        }
        catch (Exception e) {
            this.tracer.severe("failed to load http client factory class", (Throwable)e);
            throw new InvalidConfigurationException("failed to load http client factory class", (Throwable)e);
        }
    }

    public void raConfigurationUpdate(ConfigProperties arg0) {
    }

    public void serviceActive(ReceivableService arg0) {
    }

    public void serviceStopping(ReceivableService arg0) {
    }

    public void serviceInactive(ReceivableService arg0) {
    }

    public Object getResourceAdaptorInterface(String arg0) {
        return this.sbbInterface;
    }

    public Marshaler getMarshaler() {
        return null;
    }

    public void administrativeRemove(ActivityHandle arg0) {
    }

    public Object getActivity(ActivityHandle activityHandle) {
        return this.activities.get(activityHandle);
    }

    public ActivityHandle getActivityHandle(Object arg0) {
        HttpClientActivityHandle handle;
        if (arg0 instanceof HttpClientActivityImpl && this.activities.containsKey(handle = new HttpClientActivityHandle(((HttpClientActivityImpl)arg0).getSessionId()))) {
            return handle;
        }
        return null;
    }

    public void queryLiveness(ActivityHandle arg0) {
        if (!this.activities.contains(arg0)) {
            this.resourceAdaptorContext.getSleeEndpoint().endActivity(arg0);
        }
    }

    public void eventProcessingSuccessful(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
    }

    public void eventProcessingFailed(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5, FailureReason arg6) {
    }

    public void eventUnreferenced(ActivityHandle arg0, FireableEventType arg1, Object arg2, Address arg3, ReceivableService arg4, int arg5) {
        ResponseEvent event;
        HttpResponse response;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(String.format("Event=%s unreferenced", arg2));
        }
        if (arg2 instanceof ResponseEvent && (response = (event = (ResponseEvent)arg2).getHttpResponse()) != null) {
            try {
                EntityUtils.consume((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                this.tracer.severe("Exception while housekeeping. Event unreferenced", (Throwable)e);
            }
        }
    }

    public void activityEnded(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("activityEnded( handle = " + activityHandle + ")");
        }
        this.activities.remove(activityHandle);
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public ResourceAdaptorContext getResourceAdaptorContext() {
        return this.resourceAdaptorContext;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void addActivity(HttpClientActivityHandle activityHandle, HttpClientActivity activity) {
        this.activities.put(activityHandle, activity);
    }

    public void endActivity(HttpClientActivity activity) {
        HttpClientActivityHandle ah = new HttpClientActivityHandle(activity.getSessionId());
        if (this.activities.containsKey(ah)) {
            this.resourceAdaptorContext.getSleeEndpoint().endActivity((ActivityHandle)ah);
        }
    }

    public void processResponseEvent(ResponseEvent event, HttpClientActivity activity) {
        HttpClientActivityHandle ah = new HttpClientActivityHandle(activity.getSessionId());
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("==== FIRING ResponseEvent EVENT TO LOCAL SLEE, Event: " + event + " ====");
        }
        try {
            this.resourceAdaptorContext.getSleeEndpoint().fireEvent((ActivityHandle)ah, this.fireableEventType, (Object)event, null, null, 128);
        }
        catch (Throwable e) {
            this.tracer.severe(e.getMessage(), e);
        }
    }

    protected class AsyncExecuteMethodHandler
    implements Runnable {
        private final HttpRequest httpRequest;
        private final HttpContext httpContext;
        private final HttpHost httpHost;
        private final HttpClientActivity activity;
        private final Object requestApplicationData;

        protected AsyncExecuteMethodHandler(HttpUriRequest request, Object requestApplicationData, HttpClientActivity activity, HttpContext httpContext) {
            this(null, (HttpRequest)request, requestApplicationData, httpContext, activity);
        }

        protected AsyncExecuteMethodHandler(HttpHost target, HttpRequest request, Object requestApplicationData, HttpContext context, HttpClientActivity activity) {
            this.httpHost = target;
            this.httpRequest = request;
            this.httpContext = context;
            this.activity = activity;
            this.requestApplicationData = requestApplicationData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (HttpClientResourceAdaptor.this.tracer.isFineEnabled()) {
                HttpClientResourceAdaptor.this.tracer.fine("Executing Request " + this.httpRequest);
            }
            ResponseEvent event = null;
            HttpResponse response = null;
            try {
                if (this.httpHost != null) {
                    response = HttpClientResourceAdaptor.this.httpclient.execute(this.httpHost, this.httpRequest, this.httpContext);
                } else if (this.httpContext != null) {
                    response = HttpClientResourceAdaptor.this.httpclient.execute((HttpUriRequest)this.httpRequest, this.httpContext);
                }
                if (HttpClientResourceAdaptor.this.tracer.isFineEnabled()) {
                    HttpClientResourceAdaptor.this.tracer.fine("Executed Request " + this.httpRequest);
                }
                event = new ResponseEvent(response, this.requestApplicationData);
            }
            catch (IOException e) {
                HttpClientResourceAdaptor.this.tracer.severe("executeMethod failed in AsyncExecuteHttpMethodHandler with IOException", (Throwable)e);
                event = new ResponseEvent((Exception)e, this.requestApplicationData);
            }
            catch (Exception e) {
                HttpClientResourceAdaptor.this.tracer.severe("executeMethod failed in AsyncExecuteHttpMethodHandler with Exception", (Throwable)e);
                event = new ResponseEvent(e, this.requestApplicationData);
            }
            if (this.activity.isEnded()) {
                HttpClientResourceAdaptor.this.tracer.warning(String.format("Wanted to fire ResponseEvent for HttpClientActivity %s but activity is already ended, droping event", this.activity.getSessionId()));
                return;
            }
            HttpClientResourceAdaptor.this.processResponseEvent(event, this.activity);
            if (this.activity.getEndOnReceivingResponse()) {
                try {
                    HttpClientResourceAdaptor.this.endActivity(this.activity);
                }
                finally {
                    ((HttpClientActivityImpl)this.activity).setEnded(true);
                }
            }
        }
    }
}

