/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.client.slee.resource.http;

import java.util.UUID;
import java.util.concurrent.ExecutorService;
import net.java.client.slee.resource.http.HttpClientActivity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.mobicents.client.slee.resource.http.HttpClientResourceAdaptor;

public class HttpClientActivityImpl
implements HttpClientActivity {
    private final String sessionId;
    private final HttpClientResourceAdaptor ra;
    private final boolean endOnReceivingResponse;
    private final HttpContext context;
    private volatile boolean ended = false;

    public HttpClientActivityImpl(HttpClientResourceAdaptor ra, boolean endOnReceivingResponse, HttpContext context) {
        this.ra = ra;
        this.sessionId = UUID.randomUUID().toString();
        this.endOnReceivingResponse = endOnReceivingResponse;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endActivity() {
        if (this.endOnReceivingResponse) {
            throw new IllegalStateException("Activity will end automatically as soon as Response is received");
        }
        try {
            this.ra.endActivity(this);
        }
        finally {
            this.ended = true;
        }
    }

    public void execute(HttpUriRequest httpMethod, Object requestApplicationData) {
        ExecutorService executorService = this.ra.getExecutorService();
        HttpClientResourceAdaptor httpClientResourceAdaptor = this.ra;
        httpClientResourceAdaptor.getClass();
        executorService.execute(new HttpClientResourceAdaptor.AsyncExecuteMethodHandler(httpClientResourceAdaptor, httpMethod, requestApplicationData, this, this.context));
    }

    public void execute(HttpHost target, HttpRequest request, Object requestApplicationData) {
        ExecutorService executorService = this.ra.getExecutorService();
        HttpClientResourceAdaptor httpClientResourceAdaptor = this.ra;
        httpClientResourceAdaptor.getClass();
        executorService.execute(new HttpClientResourceAdaptor.AsyncExecuteMethodHandler(httpClientResourceAdaptor, target, request, requestApplicationData, this.context, this));
    }

    public boolean getEndOnReceivingResponse() {
        return this.endOnReceivingResponse;
    }

    public HttpContext getHttpContext() {
        return this.context;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isEnded() {
        return this.ended;
    }

    protected void setEnded(boolean ended) {
        this.ended = ended;
    }

    public int hashCode() {
        return this.sessionId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            return ((HttpClientActivityImpl)obj).sessionId.equals(this.sessionId);
        }
        return false;
    }
}

