/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip;

import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.MobicentsSipProviderImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.SipStackImpl;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import org.mobicents.ext.javax.sip.SipProviderFactory;
import org.mobicents.ext.javax.sip.SipStackExtension;

public class MobicentsSipProviderFactory
implements SipProviderFactory {
    private SipStackImpl sipStack;

    public void setSipStack(SipStack sipStack) {
        this.sipStack = (SipStackImpl)sipStack;
    }

    public SipProvider createSipProvider(ListeningPoint listeningPoint) throws ObjectInUseException {
        ListeningPointImpl listeningPointImpl;
        if (listeningPoint == null) {
            throw new NullPointerException("null listeningPoint");
        }
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("createSipProvider: " + listeningPoint);
        }
        if ((listeningPointImpl = (ListeningPointImpl)listeningPoint).getProvider() != null) {
            throw new ObjectInUseException("Provider already attached!");
        }
        MobicentsSipProviderImpl provider = new MobicentsSipProviderImpl(this.sipStack);
        provider.setListeningPoint((ListeningPoint)listeningPointImpl);
        listeningPointImpl.setSipProvider((SipProviderImpl)provider);
        ((SipStackExtension)this.sipStack).addSipProvider(provider);
        return provider;
    }
}

