/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser.chars;

import gov.nist.core.Debug;
import gov.nist.core.NameValue;
import gov.nist.javax.sip.parser.chars.LexerCore;
import gov.nist.javax.sip.parser.chars.Token;
import java.text.ParseException;

public abstract class ParserCore {
    public static final boolean debug = Debug.parserDebug;
    static int nesting_level;
    protected LexerCore lexer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NameValue nameValue(char separator) throws ParseException {
        if (debug) {
            this.dbg_enter("nameValue");
        }
        try {
            Token name;
            block13: {
                this.lexer.match(4095);
                name = this.lexer.getNextToken();
                this.lexer.SPorHT();
                try {
                    boolean quoted = false;
                    char la = this.lexer.lookAhead(0);
                    if (la != separator) break block13;
                    this.lexer.consume(1);
                    this.lexer.SPorHT();
                    String str = null;
                    boolean isFlag = false;
                    if (this.lexer.lookAhead(0) == '\"') {
                        str = this.lexer.quotedString();
                        quoted = true;
                    } else {
                        this.lexer.match(4095);
                        Token value = this.lexer.getNextToken();
                        str = value.getTokenValue();
                        if (str == null) {
                            str = "";
                            isFlag = true;
                        }
                    }
                    NameValue nv = new NameValue(name.getTokenValue(), (Object)str, isFlag);
                    if (quoted) {
                        nv.setQuotedValue();
                    }
                    NameValue nameValue = nv;
                    return nameValue;
                }
                catch (ParseException ex) {
                    NameValue nameValue = new NameValue(name.getTokenValue(), null, false);
                    return nameValue;
                }
            }
            NameValue nameValue = new NameValue(name.getTokenValue(), (Object)"", true);
            return nameValue;
        }
        finally {
            if (debug) {
                this.dbg_leave("nameValue");
            }
        }
    }

    protected void dbg_enter(String rule) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nesting_level; ++i) {
            stringBuilder.append(">");
        }
        if (debug) {
            System.out.println(stringBuilder + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        ++nesting_level;
    }

    protected void dbg_leave(String rule) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nesting_level; ++i) {
            stringBuilder.append("<");
        }
        if (debug) {
            System.out.println(stringBuilder + rule + "\nlexer buffer = \n" + this.lexer.getRest());
        }
        --nesting_level;
    }

    protected NameValue nameValue() throws ParseException {
        return this.nameValue('=');
    }

    protected void peekLine(String rule) {
        if (debug) {
            Debug.println((String)(rule + " " + this.lexer.peekLine()));
        }
    }
}

