/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message.selective;

import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.selective.SelectiveMessageDelegate;
import gov.nist.javax.sip.parser.selective.SelectiveMessage;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.sip.header.Header;
import javax.sip.header.ViaHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectiveSIPRequest
extends SIPRequest
implements SelectiveMessage {
    SelectiveMessageDelegate delegate;
    private static Set<String> headersToParse;

    public SelectiveSIPRequest(Set<String> headersToParse) {
        SelectiveSIPRequest.headersToParse = headersToParse;
        this.delegate = new SelectiveMessageDelegate();
    }

    @Override
    public void addHeaderNotParsed(String headerName, String header) {
        this.delegate.addHeaderNotParsed(headerName, header);
    }

    protected Header getHeaderLowerCase(String lowerCaseHeaderName) {
        SIPHeader sipHeader;
        if (!headersToParse.contains(lowerCaseHeaderName) && (sipHeader = this.delegate.parseHeader(lowerCaseHeaderName, true)) != null) {
            super.addHeader((Header)sipHeader);
        }
        return super.getHeaderLowerCase(lowerCaseHeaderName);
    }

    public SIPHeader getSIPHeaderListLowerCase(String lowerCaseHeaderName) {
        SIPHeader sipHeader;
        if (!headersToParse.contains(lowerCaseHeaderName) && (sipHeader = this.delegate.parseHeader(lowerCaseHeaderName, true)) != null) {
            super.addHeader((Header)sipHeader);
        }
        return super.getSIPHeaderListLowerCase(lowerCaseHeaderName);
    }

    public String encode() {
        String retval;
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            retval = this.requestLine.encode() + this.encodeSelective();
        } else {
            retval = this.isNullRequest() ? "\r\n\r\n" : this.encodeSelective();
        }
        return retval;
    }

    public String encodeSelective() {
        StringBuilder encoding = new StringBuilder();
        for (SIPHeader siphdr : this.headers) {
            if (siphdr instanceof ContentLength) continue;
            siphdr.encode(encoding);
        }
        Iterator<String> nonParsedHeadersIt = this.delegate.getHeaderValuesNotParsed();
        while (nonParsedHeadersIt.hasNext()) {
            String nonParsedHeader = nonParsedHeadersIt.next();
            encoding.append(nonParsedHeader);
        }
        if (this.unrecognizedHeaders != null) {
            for (String unrecognized : this.unrecognizedHeaders) {
                encoding.append(unrecognized).append("\r\n");
            }
        }
        this.contentLengthHeader.encode(encoding).append("\r\n");
        if (this.messageContentObject != null) {
            String mbody = this.getContent().toString();
            encoding.append(mbody);
        } else if (this.messageContent != null || this.messageContentBytes != null) {
            String content = null;
            try {
                content = this.messageContent != null ? this.messageContent : new String(this.messageContentBytes, this.getCharset());
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException((Exception)ex);
            }
            encoding.append(content);
        }
        return encoding.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encodeAsBytesSelective(String transport) {
        if (this instanceof SIPRequest && this.isNullRequest()) {
            return "\r\n\r\n".getBytes();
        }
        ViaHeader topVia = (ViaHeader)this.getHeader("Via");
        try {
            topVia.setTransport(transport);
        }
        catch (ParseException e) {
            InternalErrorHandler.handleException((Exception)e);
        }
        StringBuilder encoding = new StringBuilder();
        ConcurrentLinkedQueue concurrentLinkedQueue = this.headers;
        synchronized (concurrentLinkedQueue) {
            for (SIPHeader siphdr : this.headers) {
                if (siphdr instanceof ContentLength) continue;
                siphdr.encode(encoding);
            }
        }
        Iterator<String> nonParsedHeadersIt = this.delegate.getHeaderValuesNotParsed();
        while (nonParsedHeadersIt.hasNext()) {
            String nonParsedHeader = nonParsedHeadersIt.next();
            encoding.append(nonParsedHeader);
        }
        this.contentLengthHeader.encode(encoding);
        encoding.append("\r\n");
        byte[] retval = null;
        byte[] content = this.getRawContent();
        if (content != null) {
            byte[] msgarray = null;
            try {
                msgarray = encoding.toString().getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException((Exception)ex);
            }
            retval = new byte[msgarray.length + content.length];
            System.arraycopy(msgarray, 0, retval, 0, msgarray.length);
            System.arraycopy(content, 0, retval, msgarray.length, content.length);
        } else {
            try {
                retval = encoding.toString().getBytes(this.getCharset());
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException((Exception)ex);
            }
        }
        return retval;
    }

    public byte[] encodeAsBytes(String transport) {
        if (this.isNullRequest()) {
            return "\r\n\r\n".getBytes();
        }
        if (this.requestLine == null) {
            return new byte[0];
        }
        byte[] rlbytes = null;
        if (this.requestLine != null) {
            try {
                rlbytes = this.requestLine.encode().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                InternalErrorHandler.handleException((Exception)ex);
            }
        }
        byte[] superbytes = this.encodeAsBytesSelective(transport);
        byte[] retval = new byte[rlbytes.length + superbytes.length];
        System.arraycopy(rlbytes, 0, retval, 0, rlbytes.length);
        System.arraycopy(superbytes, 0, retval, rlbytes.length, superbytes.length);
        return retval;
    }

    public StringBuilder encodeMessage(StringBuilder retval) {
        if (this.requestLine != null) {
            this.setRequestLineDefaults();
            this.requestLine.encode(retval);
            this.encodeSIPHeaders(retval);
        } else if (this.isNullRequest()) {
            retval.append("\r\n\r\n");
        } else {
            retval = this.encodeSIPHeaders(retval);
        }
        return retval;
    }

    protected StringBuilder encodeSIPHeaders(StringBuilder encoding) {
        for (SIPHeader siphdr : this.headers) {
            if (siphdr instanceof ContentLength) continue;
            siphdr.encode(encoding);
        }
        Iterator<String> nonParsedHeadersIt = this.delegate.getHeaderValuesNotParsed();
        while (nonParsedHeadersIt.hasNext()) {
            String nonParsedHeader = nonParsedHeadersIt.next();
            encoding.append(nonParsedHeader);
        }
        return this.contentLengthHeader.encode(encoding).append("\r\n");
    }

    public String getHeaderAsFormattedString(String name) {
        String unparsedHeader;
        if (!headersToParse.contains(name.toLowerCase()) && (unparsedHeader = this.delegate.getHeaderUnparsed(name.toLowerCase())) != null) {
            return unparsedHeader;
        }
        String lowerCaseName = name.toLowerCase();
        if (this.headerTable.containsKey(lowerCaseName)) {
            return ((SIPHeader)this.headerTable.get(lowerCaseName)).toString();
        }
        return this.getHeader(name).toString();
    }

    public ListIterator<String> getHeaderNames() {
        Iterator li = this.headers.iterator();
        LinkedList<String> retval = new LinkedList<String>();
        while (li.hasNext()) {
            SIPHeader sipHeader = (SIPHeader)li.next();
            String name = sipHeader.getName();
            retval.add(name);
        }
        Iterator<String> nonParsedHeadersIt = this.delegate.getHeaderValuesNotParsed();
        while (nonParsedHeadersIt.hasNext()) {
            String nonParsedHeader = nonParsedHeadersIt.next();
            retval.add(nonParsedHeader);
        }
        return retval.listIterator();
    }

    public Iterator<SIPHeader> getHeaders() {
        Iterator<String> nonParsedHeadersIt = this.delegate.getHeaderNamesNotParsed();
        while (nonParsedHeadersIt.hasNext()) {
            String nonParsedHeaderName = nonParsedHeadersIt.next();
            SIPHeader sipHeader = this.delegate.parseHeader(nonParsedHeaderName, true);
            if (sipHeader == null) continue;
            super.addHeader((Header)sipHeader);
        }
        return super.getHeaders();
    }

    public ListIterator<SIPHeader> getHeaders(String headerName) {
        SIPHeader sipHeader;
        if (!headersToParse.contains(headerName.toLowerCase()) && (sipHeader = this.delegate.parseHeader(headerName.toLowerCase(), true)) != null) {
            super.addHeader((Header)sipHeader);
        }
        return super.getHeaders(headerName);
    }

    public void removeHeader(String headerName) {
        if (!headersToParse.contains(headerName.toLowerCase())) {
            this.delegate.removeHeaderNotParsed(headerName.toLowerCase());
        }
        super.removeHeader(headerName);
    }

    public void removeHeader(String headerName, boolean top) {
        if (!headersToParse.contains(headerName.toLowerCase())) {
            this.delegate.removeHeaderNotParsed(headerName.toLowerCase());
        }
        super.removeHeader(headerName, top);
    }

    public Object clone() {
        SelectiveSIPRequest retval = (SelectiveSIPRequest)super.clone();
        retval.delegate = new SelectiveMessageDelegate();
        Map<String, String> headersNotParsed = this.delegate.getHeadersNotParsed();
        for (Map.Entry<String, String> entry : headersNotParsed.entrySet()) {
            retval.delegate.addHeaderNotParsed(entry.getKey(), entry.getValue());
        }
        return retval;
    }
}

