/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.message.selective;

import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.parser.chars.HeaderParser;
import gov.nist.javax.sip.parser.chars.ParserFactory;
import gov.nist.javax.sip.parser.selective.SelectiveMessage;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectiveMessageDelegate
implements SelectiveMessage {
    private Map<String, String> headersNotParsed = new ConcurrentHashMap<String, String>(0);

    @Override
    public void addHeaderNotParsed(String headerName, String header) {
        if (header.endsWith("\n")) {
            this.headersNotParsed.put(headerName.toLowerCase(), header);
        } else {
            this.headersNotParsed.put(headerName.toLowerCase(), header + "\n");
        }
    }

    public Iterator<String> getHeaderValuesNotParsed() {
        return this.headersNotParsed.values().iterator();
    }

    public Iterator<String> getHeaderNamesNotParsed() {
        return this.headersNotParsed.keySet().iterator();
    }

    public Map<String, String> getHeadersNotParsed() {
        return this.headersNotParsed;
    }

    public SIPHeader parseHeader(String headerName, boolean remove) {
        String header = null;
        header = remove ? this.headersNotParsed.remove(headerName) : this.headersNotParsed.get(headerName);
        if (header != null) {
            HeaderParser headerParser = null;
            try {
                headerParser = ParserFactory.createParser(header.toCharArray());
                return headerParser.parse();
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Following header couldn't be parsed " + header + " for header name " + headerName, ex);
            }
        }
        return null;
    }

    public String getHeaderUnparsed(String headerName) {
        String header = this.headersNotParsed.get(headerName);
        return header;
    }

    public String removeHeaderNotParsed(String lowerCase) {
        return this.headersNotParsed.remove(lowerCase);
    }
}

