/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;

public class DateCodec
implements Codec<java.sql.Date> {
    public static final DateCodec INSTANCE = new DateCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.DATE, new DataType[]{DataType.NEWDATE, DataType.DATETIME, DataType.TIMESTAMP, DataType.YEAR, DataType.VARSTRING, DataType.VARCHAR, DataType.STRING, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB});

    @Override
    public String className() {
        return java.sql.Date.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && type.isAssignableFrom(java.sql.Date.class);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof java.sql.Date || Date.class.equals(value.getClass());
    }

    @Override
    public java.sql.Date decodeText(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeDateText(buf, length, cal);
    }

    @Override
    public java.sql.Date decodeBinary(ReadableByteBuf buf, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeDateBinary(buf, length, cal);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object val, Calendar providedCal, Long maxLen) throws IOException {
        Calendar cal = providedCal == null ? Calendar.getInstance() : providedCal;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        sdf.setTimeZone(cal.getTimeZone());
        String dateString = sdf.format(val);
        encoder.writeByte(39);
        encoder.writeAscii(dateString);
        encoder.writeByte(39);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar providedCal, Long maxLength) throws IOException {
        Calendar cal;
        Calendar calendar = cal = providedCal == null ? Calendar.getInstance() : providedCal;
        synchronized (calendar) {
            cal.clear();
            cal.setTimeInMillis(((Date)value).getTime());
            encoder.writeByte(4);
            encoder.writeShort((short)cal.get(1));
            encoder.writeByte(cal.get(2) + 1 & 0xFF);
            encoder.writeByte(cal.get(5) & 0xFF);
        }
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.DATE.get();
    }
}

