/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mapstruct.ap.internal.model.assignment.Assignment;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.util.Strings;

public class SourceRHS
extends ModelElement
implements Assignment {
    private final String sourceReference;
    private final Type sourceType;
    private String sourceLocalVarName;
    private final Set<String> existingVariableNames;
    private final String sourceErrorMessagePart;
    private final String sourcePresenceCheckerReference;
    private boolean useElementAsSourceTypeForMatching = false;
    private final String sourceParameterName;

    public SourceRHS(String sourceReference, Type sourceType, Set<String> existingVariableNames, String sourceErrorMessagePart) {
        this(sourceReference, sourceReference, null, sourceType, existingVariableNames, sourceErrorMessagePart);
    }

    public SourceRHS(String sourceParameterName, String sourceReference, String sourcePresenceCheckerReference, Type sourceType, Set<String> existingVariableNames, String sourceErrorMessagePart) {
        this.sourceReference = sourceReference;
        this.sourceType = sourceType;
        this.existingVariableNames = existingVariableNames;
        this.sourceErrorMessagePart = sourceErrorMessagePart;
        this.sourcePresenceCheckerReference = sourcePresenceCheckerReference;
        this.sourceParameterName = sourceParameterName;
    }

    @Override
    public String getSourceReference() {
        return this.sourceReference;
    }

    @Override
    public boolean isSourceReferenceParameter() {
        return this.sourceReference.equals(this.sourceParameterName);
    }

    @Override
    public String getSourcePresenceCheckerReference() {
        return this.sourcePresenceCheckerReference;
    }

    @Override
    public Type getSourceType() {
        return this.sourceType;
    }

    @Override
    public String createLocalVarName(String desiredName) {
        String result = Strings.getSaveVariableName(desiredName, this.existingVariableNames);
        this.existingVariableNames.add(result);
        return result;
    }

    @Override
    public String getSourceLocalVarName() {
        return this.sourceLocalVarName;
    }

    @Override
    public void setSourceLocalVarName(String sourceLocalVarName) {
        this.sourceLocalVarName = sourceLocalVarName;
    }

    @Override
    public Set<Type> getImportTypes() {
        return Collections.emptySet();
    }

    @Override
    public List<Type> getThrownTypes() {
        return Collections.emptyList();
    }

    @Override
    public void setAssignment(Assignment assignment) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Assignment.AssignmentType getType() {
        return Assignment.AssignmentType.DIRECT;
    }

    @Override
    public boolean isCallingUpdateMethod() {
        return false;
    }

    public String toString() {
        return this.sourceReference;
    }

    public String getSourceErrorMessagePart() {
        return this.sourceErrorMessagePart;
    }

    public Type getSourceTypeForMatching() {
        return this.useElementAsSourceTypeForMatching && this.sourceType.isCollectionType() ? this.sourceType.getTypeParameters().get(0) : this.sourceType;
    }

    public void setUseElementAsSourceTypeForMatching(boolean useElementAsSourceTypeForMatching) {
        this.useElementAsSourceTypeForMatching = useElementAsSourceTypeForMatching;
    }

    @Override
    public String getSourceParameterName() {
        return this.sourceParameterName;
    }
}

