/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import net.java.truelicense.core.crypto.BasicPbeEncryption;
import net.java.truelicense.core.crypto.PbeParameters;
import net.java.truelicense.core.io.Sink;
import net.java.truelicense.core.io.Source;

@Immutable
final class V2Encryption
extends BasicPbeEncryption {
    V2Encryption(PbeParameters pbeParameters) {
        super(pbeParameters);
    }

    @Override
    public Sink apply(final Sink sink) {
        return new Sink(){

            @Override
            public OutputStream output() throws IOException {
                return (OutputStream)V2Encryption.wrap(new Callable<OutputStream>(){
                    static final /* synthetic */ boolean $assertionsDisabled;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
                    public OutputStream call() throws Exception {
                        Cipher cipher = V2Encryption.this.cipher(true, null);
                        AlgorithmParameters algorithmParameters = cipher.getParameters();
                        byte[] byArray = algorithmParameters.getEncoded();
                        if (!$assertionsDisabled && byArray.length > Short.MAX_VALUE) {
                            throw new AssertionError();
                        }
                        OutputStream outputStream = sink.output();
                        try {
                            new DataOutputStream(outputStream).writeShort(byArray.length);
                            outputStream.write(byArray);
                        }
                        catch (Exception exception) {
                            try {
                                outputStream.close();
                            }
                            finally {
                                throw exception;
                            }
                        }
                        return new CipherOutputStream(outputStream, cipher);
                    }

                    static {
                        1.$assertionsDisabled = !V2Encryption.class.desiredAssertionStatus();
                    }
                });
            }
        };
    }

    @Override
    public Source unapply(final Source source) {
        return new Source(){

            @Override
            public InputStream input() throws IOException {
                return (InputStream)V2Encryption.wrap(new Callable<InputStream>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
                    public InputStream call() throws Exception {
                        Cipher cipher;
                        InputStream inputStream = source.input();
                        try {
                            DataInputStream dataInputStream = new DataInputStream(inputStream);
                            byte[] byArray = new byte[dataInputStream.readShort() & 0xFFFF];
                            dataInputStream.readFully(byArray);
                            cipher = V2Encryption.this.cipher(false, V2Encryption.this.param(byArray));
                        }
                        catch (Exception exception) {
                            try {
                                inputStream.close();
                            }
                            finally {
                                throw exception;
                            }
                        }
                        return new CipherInputStream(inputStream, cipher);
                    }
                });
            }
        };
    }

    private AlgorithmParameters param(byte[] byArray) throws Exception {
        AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance(this.algorithm());
        algorithmParameters.init(byArray);
        return algorithmParameters;
    }

    private Cipher cipher(boolean bl, @CheckForNull AlgorithmParameters algorithmParameters) throws Exception {
        Cipher cipher = Cipher.getInstance(this.algorithm());
        cipher.init(bl ? 1 : 2, (Key)this.secretKey(), algorithmParameters);
        return cipher;
    }
}

