/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.vertical_blank.sqlformatter.core;

import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.core.TokenTypes;

public class Token {
    public final TokenTypes type;
    public final String value;
    public final String regex;
    public final String whitespaceBefore;
    public final String key;
    private static final Pattern AND = Pattern.compile("^AND$", 66);
    private static final Pattern BETWEEN = Pattern.compile("^BETWEEN$", 66);
    private static final Pattern LIMIT = Pattern.compile("^LIMIT$", 66);
    private static final Pattern SET = Pattern.compile("^SET$", 66);
    private static final Pattern BY = Pattern.compile("^BY$", 66);
    private static final Pattern WINDOW = Pattern.compile("^WINDOW$", 66);
    private static final Pattern END = Pattern.compile("^END$", 66);

    public Token(TokenTypes type, String value, String regex, String whitespaceBefore, String key) {
        this.type = type;
        this.value = value;
        this.regex = regex;
        this.whitespaceBefore = whitespaceBefore;
        this.key = key;
    }

    public Token(TokenTypes type, String value, String regex, String whitespaceBefore) {
        this(type, value, regex, whitespaceBefore, null);
    }

    public Token(TokenTypes type, String value, String regex) {
        this(type, value, regex, null);
    }

    public Token(TokenTypes type, String value) {
        this(type, value, null, null);
    }

    public Token withWhitespaceBefore(String whitespaceBefore) {
        return new Token(this.type, this.value, this.regex, whitespaceBefore, this.key);
    }

    public Token withKey(String key) {
        return new Token(this.type, this.value, this.regex, this.whitespaceBefore, key);
    }

    public String toString() {
        return "type: " + (Object)((Object)this.type) + ", value: [" + this.value + "], regex: /" + this.regex + "/, key: " + this.key;
    }

    private static Function<Token, Boolean> isToken(TokenTypes type, Pattern pattern) {
        return token -> token.type == type && pattern.matcher(token.value).matches();
    }

    public static boolean isAnd(Token token) {
        return Token.isAnd(Optional.ofNullable(token));
    }

    public static boolean isAnd(Optional<Token> token) {
        return token.map(Token.isToken(TokenTypes.RESERVED_NEWLINE, AND)).orElse(false);
    }

    public static boolean isBetween(Token token) {
        return Token.isBetween(Optional.ofNullable(token));
    }

    public static boolean isBetween(Optional<Token> token) {
        return token.map(Token.isToken(TokenTypes.RESERVED, BETWEEN)).orElse(false);
    }

    public static boolean isLimit(Token token) {
        return Token.isLimit(Optional.ofNullable(token));
    }

    public static boolean isLimit(Optional<Token> token) {
        return token.map(Token.isToken(TokenTypes.RESERVED_TOP_LEVEL, LIMIT)).orElse(false);
    }

    public static boolean isSet(Token token) {
        return Token.isSet(Optional.ofNullable(token));
    }

    public static boolean isSet(Optional<Token> token) {
        return token.map(Token.isToken(TokenTypes.RESERVED_TOP_LEVEL, SET)).orElse(false);
    }

    public static boolean isBy(Token token) {
        return Token.isBy(Optional.ofNullable(token));
    }

    public static boolean isBy(Optional<Token> token) {
        return token.map(Token.isToken(TokenTypes.RESERVED, BY)).orElse(false);
    }

    public static boolean isWindow(Token token) {
        return Token.isWindow(Optional.ofNullable(token));
    }

    public static boolean isWindow(Optional<Token> token) {
        return token.map(Token.isToken(TokenTypes.RESERVED_TOP_LEVEL, WINDOW)).orElse(false);
    }

    public static boolean isEnd(Token token) {
        return Token.isEnd(Optional.ofNullable(token));
    }

    public static boolean isEnd(Optional<Token> token) {
        return token.map(Token.isToken(TokenTypes.CLOSE_PAREN, END)).orElse(false);
    }
}

