/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.mustachejava.util;

import java.io.IOException;
import java.io.Writer;

public class IndentWriter
extends Writer {
    public final Writer inner;
    private final String indent;
    private boolean prependIndent = false;

    private void setPrependIndent() {
        this.prependIndent = true;
        if (this.inner instanceof IndentWriter) {
            ((IndentWriter)this.inner).setPrependIndent();
        }
    }

    public IndentWriter(Writer inner, String indent) {
        this.inner = inner;
        this.indent = indent;
    }

    @Override
    public void write(char[] chars, int off, int len) throws IOException {
        int newOff;
        for (int i = newOff = off; i < len; ++i) {
            if (chars[i] != '\n') continue;
            this.writeLine(chars, newOff, i + 1 - newOff);
            this.setPrependIndent();
            newOff = i + 1;
        }
        this.writeLine(chars, newOff, len - (newOff - off));
    }

    public void flushIndent() throws IOException {
        if (this.prependIndent) {
            this.inner.append(this.indent);
            this.prependIndent = false;
        }
    }

    private void writeLine(char[] chars, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        this.flushIndent();
        this.inner.write(chars, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.inner.flush();
    }

    @Override
    public void close() throws IOException {
        this.inner.close();
    }
}

