/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;

public class MissingFunctionChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Function.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        CreateFunctionChange createFunctionChange = new CreateFunctionChange();
        if (diffOutputControl.getIncludeCatalog()) {
            createFunctionChange.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            createFunctionChange.setSchemaName(databaseObject.getSchema().getName());
        }
        createFunctionChange.setFunctionName(Function.getFunctionName(databaseObject));
        createFunctionChange.setFunctionBody(((Function)databaseObject).getBody());
        if (database instanceof MSSQLDatabase && !createFunctionChange.getFunctionBody().toUpperCase().contains("AS EXTERNAL NAME")) {
            createFunctionChange.setReplaceIfExists(true);
        }
        return MissingFunctionChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{createFunctionChange});
    }
}

