/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.checkconstraint.change;

import com.datical.liquibase.ext.storedlogic.checkconstraint.change.EnableCheckConstraintStatement;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class EnableCheckConstraintGenerator
extends AbstractSqlGenerator<EnableCheckConstraintStatement> {
    public boolean supports(EnableCheckConstraintStatement enableCheckConstrainttStatement, Database database) {
        return (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof AbstractDb2Database) && !(database instanceof Db2zDatabase);
    }

    public ValidationErrors validate(EnableCheckConstraintStatement enableCheckConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)enableCheckConstraintStatement.getTableName());
        validationErrors.checkRequiredField("constraintName", (Object)enableCheckConstraintStatement.getConstraintName());
        return validationErrors;
    }

    public Sql[] generateSql(EnableCheckConstraintStatement enableCheckConstraintStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TABLE ");
        String escapedTableName = database.escapeTableName(enableCheckConstraintStatement.getCatalogName(), enableCheckConstraintStatement.getSchemaName(), enableCheckConstraintStatement.getTableName());
        sql.append(escapedTableName);
        if (database instanceof OracleDatabase) {
            sql.append(" ENABLE CONSTRAINT ").append(enableCheckConstraintStatement.getConstraintName());
        } else if (database instanceof AbstractDb2Database) {
            sql.append(" ALTER CHECK ").append(enableCheckConstraintStatement.getConstraintName()).append(" ENFORCED");
        } else {
            sql.append(" WITH CHECK CHECK CONSTRAINT ").append(enableCheckConstraintStatement.getConstraintName());
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

