/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.parser;

import java.util.HashSet;
import java.util.Set;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.util.StandardSqlParser;
import liquibase.util.StringClauses;
import lombok.Generated;

public class ExceptionSwallowingSqlParser
extends StandardSqlParser {
    private static final Set<ChangeSet> changeSetsWithLoggedWarning = new HashSet<ChangeSet>();
    private static boolean printedCommentRemovalWarning = false;
    private int priority = -1;

    public StringClauses parse(String sqlBlock) {
        try {
            return super.parse(sqlBlock);
        }
        catch (Throwable e) {
            return this.handleException(e, sqlBlock, null);
        }
    }

    public StringClauses parse(String sqlBlock, boolean preserveWhitespace, boolean preserveComments) {
        try {
            return super.parse(sqlBlock, preserveWhitespace, preserveComments);
        }
        catch (Throwable e) {
            return this.handleException(e, sqlBlock, null);
        }
    }

    public StringClauses parse(String sqlBlock, boolean preserveWhitespace, boolean preserveComments, ChangeSet changeSet) {
        try {
            return super.parse(sqlBlock, preserveWhitespace, preserveComments, changeSet);
        }
        catch (Throwable e) {
            return this.handleException(e, sqlBlock, changeSet);
        }
    }

    private StringClauses handleException(Throwable e, String sql, ChangeSet changeSet) {
        String logMessage;
        if (changeSet != null) {
            if (changeSetsWithLoggedWarning.contains(changeSet)) {
                logMessage = null;
            } else {
                logMessage = "WARNING: Liquibase was unable to remove comments from " + changeSet + "; policy checks will be run without removing comments.";
                changeSetsWithLoggedWarning.add(changeSet);
            }
        } else {
            logMessage = "WARNING: Liquibase was unable to remove comments from a changeset; policy checks will be run without removing comments.";
        }
        if (!printedCommentRemovalWarning) {
            Scope.getCurrentScope().getUI().sendMessage("WARNING: Liquibase was unable to remove comments from a changeset; policy checks will be run without removing comments.");
            printedCommentRemovalWarning = true;
        }
        if (logMessage != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(logMessage, e);
        }
        StringClauses stringClauses = new StringClauses();
        stringClauses.append(sql);
        return stringClauses;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }
}

