/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.action;

import com.datical.liquibase.ext.command.ScriptCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.FlowShellCommandAction;
import java.util.Map;
import javax.script.SimpleBindings;
import liquibase.Scope;
import liquibase.command.CommandResults;
import liquibase.command.CommandScope;
import liquibase.exception.LiquibaseException;

public class ScriptFlowShellCommandAction
extends FlowShellCommandAction {
    private CommandResults results;

    public ScriptFlowShellCommandAction() {
    }

    public ScriptFlowShellCommandAction(String cmd) {
        super(cmd);
    }

    @Override
    public String getType() {
        return "script";
    }

    @Override
    public Action fromAction(Map<String, Object> actionMap, Map<String, Object> variables) {
        return this;
    }

    @Override
    public void run(boolean keepTempFiles) {
        try {
            SimpleBindings bindings = new SimpleBindings();
            if (Scope.getCurrentScope().has("conditionVariables")) {
                bindings.putAll((Map)Scope.getCurrentScope().get("conditionVariables", Map.class));
            }
            String[] parts = this.getCommand().split(" ");
            String scriptName = null;
            if (parts.length <= 1) {
                throw new LiquibaseException("No script name specified in shell exec command '" + this.getCommand() + "'");
            }
            scriptName = parts[1];
            StringBuilder builder = new StringBuilder();
            if (parts.length > 2) {
                for (int i = 2; i < parts.length; ++i) {
                    if (i > 2) {
                        builder.append(",");
                    }
                    builder.append(parts[i]);
                }
            }
            CommandScope commandScope = new CommandScope(ScriptCommandStep.COMMAND_NAME);
            commandScope.addArgumentValue(ScriptCommandStep.SCRIPT_PATH_ARG, (Object)scriptName);
            commandScope.addArgumentValue(ScriptCommandStep.SCRIPT_TYPE_ARG, (Object)this.getCommand());
            commandScope.addArgumentValue(ScriptCommandStep.SCRIPT_ARGS, (Object)builder.toString());
            commandScope.addArgumentValue(ScriptCommandStep.BINDINGS_ARG.getName(), (Object)bindings);
            this.results = commandScope.execute();
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(ScriptFlowShellCommandAction.class).severe("Unable to execute command: " + this.getCommand() + ": " + e.getMessage());
        }
    }

    @Override
    public String getCommandOutput() {
        return (String)this.results.getResult("returnValue");
    }
}

