/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.helpers;

import com.datical.liquibase.ext.command.checks.CustomScriptArguments;
import java.util.Collections;
import java.util.List;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.core.helpers.AbstractArgumentCommandStep;

public class CustomScriptCommandArguments
extends AbstractArgumentCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"checks", "customScriptArguments"};
    public static final CommandArgumentDefinition<String> CUSTOM_SCRIPT_PATH;
    public static final CommandArgumentDefinition<Boolean> CUSTOM_SCRIPT_ENABLED;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(CustomScriptArguments.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String pathList = (String)commandScope.getArgumentValue(CUSTOM_SCRIPT_PATH);
        Boolean enabled = (Boolean)commandScope.getArgumentValue(CUSTOM_SCRIPT_ENABLED);
        CustomScriptArguments customScriptPath = new CustomScriptArguments(pathList, enabled);
        commandScope.provideDependency(CustomScriptArguments.class, (Object)customScriptPath);
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CUSTOM_SCRIPT_PATH = builder.argument("checksScriptsPath", String.class).description("Only allow custom scripts found in the specified directories to execute. If not set custom scripts from any location will be allowed to execute.").defaultValue(null).addAlias("checksScriptPath").addAlias("checkScriptsPath").addAlias("checkScriptPath").addAlias("checksScriptPaths").addAlias("checkScriptsPaths").addAlias("checkScriptPaths").build();
        CUSTOM_SCRIPT_ENABLED = builder.argument("checksScriptsEnabled", Boolean.class).description("Allow execution of custom script checks.").defaultValue((Object)false).addAlias("checksScriptEnabled").addAlias("checkScriptsEnabled").addAlias("checkScriptEnabled").build();
    }
}

