/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.dynamic.AbstractMaxAffectedRows;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class CheckForSpecificPatternsInSQL
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, database, false);
    }

    private boolean doEvaluate(List<Change> changes, ChangeSet changeSet, DynamicRule dynamicRule, Database database, boolean isRollback) {
        DynamicRuleParameter searchStringParam = dynamicRule.getParameter(DynamicRuleParameterEnum.SEARCH_STRING);
        DynamicRuleParameter messageParam = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
        DynamicRuleParameter stripCommentsParam = dynamicRule.getParameter(DynamicRuleParameterEnum.STRIP_COMMENTS);
        DynamicRuleParameter pathFilterParam = dynamicRule.getParameter(DynamicRuleParameterEnum.PATH_FILTER_REGEX);
        DynamicRuleParameter splitStatementsParam = dynamicRule.getParameter(DynamicRuleParameterEnum.SPLIT_STATEMENTS);
        Objects.requireNonNull(searchStringParam);
        Objects.requireNonNull(messageParam);
        Objects.requireNonNull(stripCommentsParam);
        Pattern searchString = Pattern.compile((String)searchStringParam.getValue());
        String messageTemplate = (String)messageParam.getValue();
        Boolean stripComments = (Boolean)stripCommentsParam.getValue();
        String pathFilter = null;
        if (pathFilterParam != null) {
            pathFilter = (String)pathFilterParam.getValue();
        }
        Boolean splitStatements = null;
        if (splitStatementsParam != null) {
            splitStatements = (Boolean)splitStatementsParam.getValue();
        }
        for (Change change : changes) {
            try {
                if (!CheckForSpecificPatternsInSQL.doCheck(change, database, searchString, stripComments, pathFilter, splitStatements)) continue;
                this.addFailureRuleIteration(changeSet, this.getFailureMessage(messageTemplate, searchString, changeSet, pathFilter), dynamicRule, isRollback);
            }
            catch (IllegalStateException ise) {
                Scope.getCurrentScope().getLog(CheckForSpecificPatternsInSQL.class).info("Error generating SQL for change '" + change.getDescription() + "': " + ise.getMessage());
                this.addFailureRuleIteration(changeSet, "Unable to generate SQL for change '" + change.getDescription() + "'. Checks executed against the H2 database for this object type are not available.", (AbstractConfigurableRule)dynamicRule);
            }
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, isRollback);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> changes, Database database, DynamicRule dr) {
        return this.doEvaluate(changes, changeSet, dr, database, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    public static boolean doCheck(Change change, Database database, Pattern searchString, boolean stripComments, String pathFilter, Boolean splitStatements) throws IllegalStateException {
        ChangeSet changeSet = change.getChangeSet();
        if (StringUtil.isNotEmpty((String)pathFilter)) {
            String filePath = changeSet.getFilePath();
            if (!Pattern.compile(pathFilter).matcher(filePath).matches()) {
                Scope.getCurrentScope().getLog(CheckForSpecificPatternsInSQL.class).fine("Skipping change " + change + " from changeset " + changeSet + " because the path filter does not match the path of this changeset.");
                return false;
            }
        }
        String sql = change instanceof AbstractSQLChange ? CheckForSpecificPatternsInSQL.getSql((AbstractSQLChange)change) : CheckForSpecificPatternsInSQL.generateSqlFromChange(change, database);
        if (stripComments) {
            sql = StringUtil.stripComments((String)sql, (ChangeSet)changeSet);
        }
        if (StringUtil.isEmpty((String)sql)) {
            return false;
        }
        if (Boolean.TRUE.equals(splitStatements)) {
            String[] strings = StringUtil.processMultiLineSQL((String)sql, (boolean)stripComments, (boolean)splitStatements, (String)AbstractMaxAffectedRows.getEndDelimiter(changeSet));
            return Arrays.stream(strings).anyMatch(s -> searchString.matcher((CharSequence)s).find());
        }
        return searchString.matcher(sql).find();
    }

    private String getFailureMessage(String messageTemplate, Pattern searchString, ChangeSet changeSet, String pathFilter) {
        String msg = messageTemplate.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", searchString.pattern()).replace("<CHANGESET>", changeSet.getId());
        if (StringUtil.isNotEmpty((String)pathFilter)) {
            msg = msg.replace("<" + (Object)((Object)DynamicRuleParameterEnum.PATH_FILTER_REGEX) + ">", pathFilter);
        }
        return msg;
    }

    @Override
    public String getDescription() {
        return "This check scans SQL for the presence of specific patterns in specified changelog paths, and warns the user when they are found.";
    }

    @Override
    public String getShortName() {
        return "SqlUserDefinedPatternCheck";
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.SEARCH_STRING), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, "A match for regular expression <" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + "> was detected in Changeset <CHANGESET> in changelog path <" + (Object)((Object)DynamicRuleParameterEnum.PATH_FILTER_REGEX) + ">.", false), new RuleParameter(DynamicRuleParameterEnum.STRIP_COMMENTS), new RuleParameter(DynamicRuleParameterEnum.PATH_FILTER_REGEX, null, null, null, true, true), new RuleParameter(DynamicRuleParameterEnum.SPLIT_STATEMENTS, null, null, null, true, true));
    }
}

