/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.ModifyDataTypeChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.ext.percona.PerconaChange;
import liquibase.ext.percona.PerconaChangeUtil;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="modifyDataType", description="Modify data type", priority=51, appliesTo={"column"})
public class PerconaModifyDataTypeChange
extends ModifyDataTypeChange
implements PerconaChange {
    public static final String NAME = "modifyDataType";
    public static final int PRIORITY = 51;
    private Boolean usePercona;
    private String perconaOptions;

    public SqlStatement[] generateStatements(Database database) {
        return PerconaChangeUtil.generateStatements(this, database, super.generateStatements(database));
    }

    @Override
    public String generateAlterStatement(Database database) {
        StringBuilder alter = new StringBuilder();
        alter.append("MODIFY ");
        String columnName = database.escapeColumnName(this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.getColumnName());
        alter.append(columnName);
        alter.append(' ');
        if (this.getNewDataType() != null) {
            String dataType = String.valueOf(DataTypeFactory.getInstance().fromDescription(this.getNewDataType(), database).toDatabaseDataType(database));
            alter.append(dataType);
        }
        return alter.toString();
    }

    @Override
    public String getTargetTableName() {
        return this.getTableName();
    }

    @Override
    public String getTargetDatabaseName() {
        return this.getCatalogName();
    }

    @Override
    public String getChangeName() {
        return NAME;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public Boolean getUsePercona() {
        return this.usePercona;
    }

    @Override
    public void setUsePercona(Boolean usePercona) {
        this.usePercona = usePercona;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public String getPerconaOptions() {
        return this.perconaOptions;
    }

    @Override
    public void setPerconaOptions(String perconaOptions) {
        this.perconaOptions = perconaOptions;
    }

    public Set<String> getSerializableFields() {
        HashSet fields = new HashSet(super.getSerializableFields());
        fields.remove("usePercona");
        fields.remove("perconaOptions");
        return Collections.unmodifiableSet(fields);
    }
}

