/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateIndexChange;
import liquibase.database.Database;
import liquibase.ext.percona.PerconaChange;
import liquibase.ext.percona.PerconaChangeUtil;
import liquibase.ext.percona.PerconaDropIndexChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createIndex", description="Creates an index on an existing column or set of columns.", priority=51, appliesTo={"index"})
public class PerconaCreateIndexChange
extends CreateIndexChange
implements PerconaChange {
    public static final String NAME = "createIndex";
    public static final int PRIORITY = 51;
    private Boolean usePercona;
    private String perconaOptions;

    public SqlStatement[] generateStatements(Database database) {
        return PerconaChangeUtil.generateStatements(this, database, super.generateStatements(database));
    }

    @Override
    public String generateAlterStatement(Database database) {
        StringBuilder alter = new StringBuilder();
        alter.append("ADD ");
        if (this.isUnique() != null && this.isUnique().booleanValue()) {
            alter.append("UNIQUE ");
        }
        alter.append("INDEX ");
        if (this.getIndexName() != null) {
            alter.append(database.escapeIndexName(this.getCatalogName(), this.getSchemaName(), this.getIndexName())).append(" ");
        }
        alter.append("(");
        Iterator iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            AddColumnConfig column = (AddColumnConfig)iterator.next();
            if (Boolean.TRUE.equals(column.getComputed())) {
                alter.append(column.getName());
            } else {
                alter.append(database.escapeColumnName(this.getCatalogName(), this.getSchemaName(), this.getTableName(), column.getName()));
            }
            if (!iterator.hasNext()) continue;
            alter.append(", ");
        }
        alter.append(")");
        return alter.toString();
    }

    protected Change[] createInverses() {
        PerconaDropIndexChange inverse = new PerconaDropIndexChange();
        inverse.setIndexName(this.getIndexName());
        inverse.setCatalogName(this.getCatalogName());
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        return new Change[]{inverse};
    }

    @Override
    public String getTargetTableName() {
        return this.getTableName();
    }

    @Override
    public String getTargetDatabaseName() {
        return this.getCatalogName();
    }

    @Override
    public String getChangeName() {
        return NAME;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public Boolean getUsePercona() {
        return this.usePercona;
    }

    @Override
    public void setUsePercona(Boolean usePercona) {
        this.usePercona = usePercona;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public String getPerconaOptions() {
        return this.perconaOptions;
    }

    @Override
    public void setPerconaOptions(String perconaOptions) {
        this.perconaOptions = perconaOptions;
    }

    public Set<String> getSerializableFields() {
        HashSet fields = new HashSet(super.getSerializableFields());
        fields.remove("usePercona");
        fields.remove("perconaOptions");
        return Collections.unmodifiableSet(fields);
    }
}

