/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.Collections;
import java.util.List;
import liquibase.CatalogAndSchema;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.percona.PerconaAddPrimaryKeyChange;
import liquibase.ext.percona.PerconaChangeUtil;
import liquibase.ext.percona.PerconaDropForeignKeyConstraintChange;
import liquibase.logging.Logger;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Table;

public class PerconaConstraintsService {
    private static PerconaConstraintsService instance = new PerconaConstraintsService();
    private Logger log = Scope.getCurrentScope().getLog(PerconaConstraintsService.class);
    private boolean enabled = true;

    public static PerconaConstraintsService getInstance() {
        return instance;
    }

    public void disable() {
        if (this.enabled) {
            this.log.warning("Disabled dynamic foreign key name resolution - DropForeignKeyConstraint might not work with pt-osc");
            this.enabled = false;
        }
    }

    public String determineCurrentConstraintName(Database database, PerconaDropForeignKeyConstraintChange change) {
        String constraintName = change.getConstraintName();
        if (this.enabled && !PerconaChangeUtil.isDryRun(database) && PerconaChangeUtil.isConnected(database)) {
            constraintName = this.findForeignKey(database, change);
        }
        return this.prefixConstraintName(constraintName);
    }

    private String findForeignKey(Database database, PerconaDropForeignKeyConstraintChange change) {
        this.log.fine("Searching for all foreign keys in table " + change.getBaseTableName());
        try {
            SnapshotControl control = new SnapshotControl(database);
            control.getTypesToInclude().add(ForeignKey.class);
            CatalogAndSchema catalogAndSchema = new CatalogAndSchema(change.getBaseTableCatalogName(), change.getBaseTableSchemaName()).standardize(database);
            Table target = (Table)SnapshotGeneratorFactory.getInstance().createSnapshot((DatabaseObject)new Table(catalogAndSchema.getCatalogName(), catalogAndSchema.getSchemaName(), database.correctObjectName(change.getBaseTableName(), Table.class)), database);
            List results = target == null ? Collections.emptyList() : target.getOutgoingForeignKeys();
            for (ForeignKey fk : results) {
                Table baseTable = fk.getForeignKeyTable();
                String constraintName = fk.getName();
                this.log.fine("Found FK: " + baseTable.getName() + "." + constraintName);
                if (!baseTable.getName().equalsIgnoreCase(change.getBaseTableName()) || !constraintName.endsWith(change.getConstraintName())) continue;
                this.log.fine("Found current foreign key constraint " + constraintName);
                return constraintName;
            }
        }
        catch (DatabaseException e) {
            throw new UnexpectedLiquibaseException("Failed to find foreign keys for table: " + change.getBaseTableName(), (Throwable)e);
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException("Failed to find foreign keys for table: " + change.getBaseTableName(), (Throwable)e);
        }
        this.log.warning("No foreign key with name " + change.getConstraintName() + " found.");
        return change.getConstraintName();
    }

    private String prefixConstraintName(String constraintName) {
        if (constraintName != null && constraintName.startsWith("__")) {
            return constraintName.substring(2);
        }
        return "_" + constraintName;
    }

    public boolean hasPrimaryKey(Database database, PerconaAddPrimaryKeyChange change) {
        boolean result = false;
        if (this.enabled && !PerconaChangeUtil.isDryRun(database) && PerconaChangeUtil.isConnected(database)) {
            this.log.fine("Searching for primary key in table " + change.getTableName());
            try {
                PrimaryKey primaryKeyExample = new PrimaryKey("primary", change.getCatalogName(), change.getSchemaName(), change.getTableName(), new Column[0]);
                result = SnapshotGeneratorFactory.getInstance().has((DatabaseObject)primaryKeyExample, database);
            }
            catch (DatabaseException e) {
                this.log.fine("Failed to find primary key for table: " + change.getTableName(), (Throwable)e);
            }
            catch (InvalidExampleException e) {
                throw new UnexpectedLiquibaseException("Failed to find primary key for table: " + change.getTableName(), (Throwable)e);
            }
            this.log.fine("No primary key in table " + change.getTableName() + " found.");
        }
        return result;
    }
}

