/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.ext.percona.Configuration;
import liquibase.ext.percona.PTOnlineSchemaChangeStatement;
import liquibase.ext.percona.PerconaChange;
import liquibase.logging.Logger;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CommentStatement;

public class PerconaChangeUtil {
    private static Logger log = Scope.getCurrentScope().getLog(PerconaChangeUtil.class);
    private static Map<String, Boolean> alreadyLogged = new HashMap<String, Boolean>();

    public static boolean isDryRun(Database database) {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        return executor instanceof LoggingExecutor;
    }

    public static boolean isConnected(Database database) {
        try {
            if (database.getConnection() != null) {
                return !database.getConnection().isClosed();
            }
            return false;
        }
        catch (DatabaseException e) {
            return false;
        }
    }

    public static SqlStatement[] generateStatements(PerconaChange change, Database database, SqlStatement[] originalStatements) {
        String changeSetId = "unknown changeset id";
        ChangeSet changeSet = change.getChangeSet();
        if (changeSet != null) {
            changeSetId = changeSet.getId() + ":" + changeSet.getAuthor();
        }
        if (change.getUsePercona() == null && !Configuration.getDefaultOn()) {
            log.fine("Not using percona toolkit, because property liquibase.percona.defaultOn is false. " + changeSetId + ":" + change.getChangeName());
            return originalStatements;
        }
        if (change.getUsePercona() != null && !change.getUsePercona().booleanValue()) {
            log.fine("Not using percona toolkit, because usePercona flag is false for " + changeSetId + ":" + change.getChangeName());
            return originalStatements;
        }
        if (Configuration.skipChange(change.getChangeName())) {
            PerconaChangeUtil.maybeLog("Not using percona toolkit, because skipChange for " + change.getChangeName() + " is active (property: " + "liquibase.percona.skipChanges" + ")!");
            return originalStatements;
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>(Arrays.asList(originalStatements));
        if (database instanceof MySQLDatabase) {
            if (PTOnlineSchemaChangeStatement.isAvailable()) {
                PTOnlineSchemaChangeStatement statement = new PTOnlineSchemaChangeStatement(change.getTargetDatabaseName(), change.getTargetTableName(), change.generateAlterStatement(database), Optional.ofNullable(change.getPerconaOptions()));
                if (PerconaChangeUtil.isDryRun(database)) {
                    CommentStatement commentStatement = new CommentStatement(statement.printCommand(database));
                    if (Configuration.noAlterSqlDryMode()) {
                        statements.clear();
                        statements.add(0, (SqlStatement)commentStatement);
                    } else {
                        statements.add(0, (SqlStatement)commentStatement);
                        statements.add(1, (SqlStatement)new CommentStatement("Instead of the following statements, pt-online-schema-change will be used"));
                    }
                } else {
                    statements.clear();
                    statements.add((SqlStatement)statement);
                }
            } else {
                if (Configuration.failIfNoPT()) {
                    throw new RuntimeException("No percona toolkit found!");
                }
                PerconaChangeUtil.maybeLog("Not using percona toolkit, because it is not available!");
            }
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private static void maybeLog(String message) {
        if (!alreadyLogged.containsKey(message)) {
            log.warning(message);
            alreadyLogged.put(message, Boolean.TRUE);
        }
    }

    public static String resolveReferencedPerconaTableName(String baseTableName, String referencedTableName) {
        if (baseTableName != null && baseTableName.equals(referencedTableName) && (!PTOnlineSchemaChangeStatement.getVersion().isGreaterOrEqualThan("2.2.21") || PTOnlineSchemaChangeStatement.getVersion().isGreaterOrEqualThan("3.0.0"))) {
            log.warning("Applying workaround for pt-osc bug https://jira.percona.com/browse/PT-381 for table " + baseTableName);
            return "_" + referencedTableName + "_new";
        }
        return referencedTableName;
    }
}

