/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.AddUniqueConstraintChange;
import liquibase.database.Database;
import liquibase.ext.percona.PerconaChange;
import liquibase.ext.percona.PerconaChangeUtil;
import liquibase.ext.percona.PerconaDropUniqueConstraintChange;
import liquibase.statement.SqlStatement;
import liquibase.util.StringUtil;

@DatabaseChange(name="addUniqueConstraint", description="Adds a unique constraint to an existing column or set of columns", priority=51, appliesTo={"column"})
public class PerconaAddUniqueConstraintChange
extends AddUniqueConstraintChange
implements PerconaChange {
    public static final String NAME = "addUniqueConstraint";
    public static final int PRIORITY = 51;
    private Boolean usePercona;
    private String perconaOptions;

    public SqlStatement[] generateStatements(Database database) {
        return PerconaChangeUtil.generateStatements(this, database, super.generateStatements(database));
    }

    @Override
    public String generateAlterStatement(Database database) {
        StringBuilder alter = new StringBuilder();
        alter.append("ADD ");
        if (StringUtil.isNotEmpty((String)this.getConstraintName())) {
            alter.append("CONSTRAINT ");
            alter.append(database.escapeConstraintName(this.getConstraintName()));
            alter.append(" ");
        }
        alter.append("UNIQUE (");
        List columns = StringUtil.splitAndTrim((String)this.getColumnNames(), (String)",");
        if (columns == null) {
            columns = Collections.emptyList();
        }
        alter.append(database.escapeColumnNameList(StringUtil.join(columns, (String)", ")));
        alter.append(")");
        return alter.toString();
    }

    protected Change[] createInverses() {
        PerconaDropUniqueConstraintChange inverse = new PerconaDropUniqueConstraintChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setCatalogName(this.getCatalogName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    @Override
    public String getTargetTableName() {
        return this.getTableName();
    }

    @Override
    public String getTargetDatabaseName() {
        return this.getCatalogName();
    }

    @Override
    public String getChangeName() {
        return NAME;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public Boolean getUsePercona() {
        return this.usePercona;
    }

    @Override
    public void setUsePercona(Boolean usePercona) {
        this.usePercona = usePercona;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public String getPerconaOptions() {
        return this.perconaOptions;
    }

    @Override
    public void setPerconaOptions(String perconaOptions) {
        this.perconaOptions = perconaOptions;
    }

    public Set<String> getSerializableFields() {
        HashSet fields = new HashSet(super.getSerializableFields());
        fields.remove("usePercona");
        fields.remove("perconaOptions");
        return Collections.unmodifiableSet(fields);
    }
}

