/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.percona.PerconaChange;
import liquibase.ext.percona.PerconaChangeUtil;
import liquibase.ext.percona.PerconaDropColumnChange;
import liquibase.ext.percona.StringUtil;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="addColumn", description="Adds a new column to an existing table", priority=51, appliesTo={"table"})
public class PerconaAddColumnChange
extends AddColumnChange
implements PerconaChange {
    public static final String NAME = "addColumn";
    public static final int PRIORITY = 51;
    private Boolean usePercona;
    private String perconaOptions;

    public SqlStatement[] generateStatements(Database database) {
        return PerconaChangeUtil.generateStatements(this, database, super.generateStatements(database));
    }

    @Override
    public String generateAlterStatement(Database database) {
        StringBuilder alter = new StringBuilder();
        boolean firstColumn = true;
        for (AddColumnConfig a : this.getColumns()) {
            if (!firstColumn) {
                alter.append(", ");
            }
            alter.append(this.convertColumnToSql(a, database));
            firstColumn = false;
        }
        return alter.toString();
    }

    String convertColumnToSql(AddColumnConfig column, Database database) {
        String nullable = "";
        ConstraintsConfig constraintsConfig = column.getConstraints();
        nullable = constraintsConfig != null && constraintsConfig.isNullable() == false ? " NOT NULL" : " NULL";
        String defaultValue = "";
        if (column.getDefaultValueObject() != null) {
            defaultValue = " DEFAULT " + DataTypeFactory.getInstance().fromObject(column.getDefaultValueObject(), database).objectToSql(column.getDefaultValueObject(), database);
        }
        String comment = "";
        if (StringUtil.isNotEmpty(column.getRemarks())) {
            comment = comment + " COMMENT '" + column.getRemarks() + "'";
        }
        String after = "";
        if (StringUtil.isNotEmpty(column.getAfterColumn())) {
            after = after + " AFTER " + database.escapeColumnName(null, null, null, column.getAfterColumn());
        }
        String constraints = "";
        constraints = constraints + this.addForeignKeyConstraint(column, database);
        constraints = constraints + this.addUniqueKeyConstraint(column, database);
        return "ADD COLUMN " + database.escapeColumnName(null, null, null, column.getName()) + " " + DataTypeFactory.getInstance().fromDescription(column.getType(), database).toDatabaseDataType(database) + nullable + defaultValue + comment + after + constraints;
    }

    private String addForeignKeyConstraint(AddColumnConfig column, Database database) {
        String result = "";
        ConstraintsConfig constraintsConfig = column.getConstraints();
        if (constraintsConfig != null && (StringUtil.isNotEmpty(constraintsConfig.getReferences()) || StringUtil.isNotEmpty(constraintsConfig.getReferencedTableName()))) {
            String referencedColumn;
            String referencedTable;
            result = result + ", ADD ";
            if (StringUtil.isNotEmpty(constraintsConfig.getForeignKeyName())) {
                result = result + "CONSTRAINT " + database.escapeConstraintName(constraintsConfig.getForeignKeyName()) + " ";
            }
            result = result + "FOREIGN KEY (" + database.escapeColumnName(null, null, null, column.getName()) + ") REFERENCES ";
            if (StringUtil.isNotEmpty(constraintsConfig.getReferences())) {
                Matcher references = Pattern.compile("([\\w\\._]+)\\(([\\w_]+)\\)").matcher(constraintsConfig.getReferences());
                if (!references.matches()) {
                    throw new UnexpectedLiquibaseException("Unable to get table name and column name from " + constraintsConfig.getReferences());
                }
                referencedTable = references.group(1);
                referencedColumn = references.group(2);
            } else {
                referencedTable = constraintsConfig.getReferencedTableName();
                referencedColumn = constraintsConfig.getReferencedColumnNames();
            }
            referencedTable = PerconaChangeUtil.resolveReferencedPerconaTableName(this.getTableName(), referencedTable);
            result = result + database.escapeTableName(null, null, referencedTable) + "(";
            result = result + database.escapeColumnName(null, null, null, referencedColumn);
            result = result + ")";
        }
        return result;
    }

    private String addUniqueKeyConstraint(AddColumnConfig column, Database database) {
        String result = "";
        ConstraintsConfig constraintsConfig = column.getConstraints();
        if (constraintsConfig != null && constraintsConfig.isUnique() != null && constraintsConfig.isUnique().booleanValue()) {
            result = result + ", ADD ";
            if (StringUtil.isNotEmpty(constraintsConfig.getUniqueConstraintName())) {
                result = result + "CONSTRAINT " + database.escapeConstraintName(constraintsConfig.getUniqueConstraintName()) + " ";
            }
            result = result + "UNIQUE (" + database.escapeColumnName(null, null, null, column.getName()) + ")";
        }
        return result;
    }

    protected Change[] createInverses() {
        ArrayList<Object> inverses = new ArrayList<Object>();
        for (ColumnConfig aColumn : this.getColumns()) {
            if (aColumn.hasDefaultValue()) {
                DropDefaultValueChange dropChange = new DropDefaultValueChange();
                dropChange.setTableName(this.getTableName());
                dropChange.setColumnName(aColumn.getName());
                dropChange.setSchemaName(this.getSchemaName());
                dropChange.setCatalogName(this.getCatalogName());
                inverses.add(dropChange);
            }
            PerconaDropColumnChange inverse = new PerconaDropColumnChange();
            inverse.setSchemaName(this.getSchemaName());
            inverse.setColumnName(aColumn.getName());
            inverse.setCatalogName(this.getCatalogName());
            inverse.setTableName(this.getTableName());
            inverses.add(inverse);
        }
        return inverses.toArray(new Change[inverses.size()]);
    }

    @Override
    public String getTargetTableName() {
        return this.getTableName();
    }

    @Override
    public String getTargetDatabaseName() {
        return this.getCatalogName();
    }

    @Override
    public String getChangeName() {
        return NAME;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public Boolean getUsePercona() {
        return this.usePercona;
    }

    @Override
    public void setUsePercona(Boolean usePercona) {
        this.usePercona = usePercona;
    }

    @Override
    @DatabaseChangeProperty(requiredForDatabase={})
    public String getPerconaOptions() {
        return this.perconaOptions;
    }

    @Override
    public void setPerconaOptions(String perconaOptions) {
        this.perconaOptions = perconaOptions;
    }

    public Set<String> getSerializableFields() {
        HashSet fields = new HashSet(super.getSerializableFields());
        fields.remove("usePercona");
        fields.remove("perconaOptions");
        return Collections.unmodifiableSet(fields);
    }
}

