/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.percona;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.ext.percona.Configuration;
import liquibase.ext.percona.ReflectionUtils;
import liquibase.logging.Logger;

public class DatabaseConnectionUtil {
    private static final String DEFAULT_LIQUIBASE_PROPERTIES_FILENAME = "liquibase.properties";
    private static final String PASSWORD_PROPERTY_NAME = "password";
    private Logger log = Scope.getCurrentScope().getLog(DatabaseConnectionUtil.class);
    private final String host;
    private final String port;
    private final String user;
    private final String password;

    public DatabaseConnectionUtil(DatabaseConnection connection) {
        this.host = DatabaseConnectionUtil.determineHost(connection.getURL());
        this.port = DatabaseConnectionUtil.determinePort(connection.getURL());
        this.user = DatabaseConnectionUtil.determineUser(connection.getConnectionUserName());
        this.password = this.determinePassword(connection);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    private static String determineHost(String url) {
        Pattern p = Pattern.compile("jdbc:(?:mysql|mariadb):(?:replication:|loadbalance:|sequential:|aurora:)?//([^@]+@)?([^:/]+)");
        Matcher m = p.matcher(url);
        if (m.find()) {
            return m.group(2);
        }
        return "";
    }

    private static String determinePort(String url) {
        Pattern p = Pattern.compile("jdbc:(?:mysql|mariadb):(?:replication:|loadbalance:|sequential:|aurora:)?//[^:/]+:(\\d+)");
        Matcher m = p.matcher(url);
        if (m.find()) {
            return m.group(1);
        }
        return "3306";
    }

    private static String determineUser(String connectionUserName) {
        if (connectionUserName.contains("@")) {
            return connectionUserName.substring(0, connectionUserName.indexOf(64));
        }
        return connectionUserName;
    }

    private String determinePassword(DatabaseConnection connection) {
        block13: {
            String liquibasePassword = Configuration.getLiquibasePassword();
            if (liquibasePassword != null) {
                return liquibasePassword;
            }
            if (connection instanceof JdbcConnection) {
                try {
                    Connection jdbcCon = ((JdbcConnection)connection).getWrappedConnection();
                    jdbcCon = this.getDelegatedDbcpConnection(jdbcCon);
                    jdbcCon = this.getDelegatedDbcp2Connection(jdbcCon);
                    jdbcCon = this.getUnderlyingJdbcConnectionFromProxy(jdbcCon);
                    Class<?> connectionImplClass = ReflectionUtils.findClass(jdbcCon.getClass().getClassLoader(), "com.mysql.jdbc.ConnectionImpl", "com.mysql.cj.jdbc.ConnectionImpl");
                    Class<?> mariadbConnectionClass = ReflectionUtils.findClass(jdbcCon.getClass().getClassLoader(), "org.mariadb.jdbc.MariaDbConnection");
                    boolean isMySQL = false;
                    boolean isMariaDB = false;
                    if (connectionImplClass != null && connectionImplClass.isInstance(jdbcCon)) {
                        isMySQL = true;
                    }
                    if (mariadbConnectionClass != null && mariadbConnectionClass.isInstance(jdbcCon)) {
                        isMariaDB = true;
                    }
                    if (isMySQL) {
                        Properties props = (Properties)ReflectionUtils.readField(connectionImplClass, jdbcCon, "props");
                        String password = props.getProperty(PASSWORD_PROPERTY_NAME);
                        if (password != null && !password.trim().isEmpty()) {
                            return password;
                        }
                        break block13;
                    }
                    if (isMariaDB) {
                        Object protocol = ReflectionUtils.readField(mariadbConnectionClass, jdbcCon, "protocol");
                        Object urlParser = ReflectionUtils.invokeMethod(protocol.getClass(), protocol, "getUrlParser");
                        Object password = ReflectionUtils.invokeMethod(urlParser.getClass(), urlParser, "getPassword");
                        if (password != null && !password.toString().trim().isEmpty()) {
                            return password.toString();
                        }
                        break block13;
                    }
                    throw new RuntimeException("JdbcConnection is unsupported: " + jdbcCon.getClass().getName());
                }
                catch (Exception e) {
                    this.log.warning("Couldn't determine the password from JdbcConnection", (Throwable)e);
                }
            }
        }
        try {
            Properties liquibaseProperties = this.loadLiquibaseProperties();
            if (liquibaseProperties.containsKey(PASSWORD_PROPERTY_NAME)) {
                return liquibaseProperties.getProperty(PASSWORD_PROPERTY_NAME);
            }
        }
        catch (IOException e) {
            this.log.warning("Couldn't read liquibase.properties file", (Throwable)e);
        }
        return null;
    }

    private Connection getUnderlyingJdbcConnectionFromProxy(Connection wrappedConnection) {
        if (Proxy.isProxyClass(wrappedConnection.getClass())) {
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(wrappedConnection);
            Class<?> pooledConnectionClass = ReflectionUtils.loadClass("org.apache.tomcat.jdbc.pool.PooledConnection", invocationHandler.getClass().getClassLoader());
            if (pooledConnectionClass != null) {
                try {
                    Object pooledConnectionInstance = wrappedConnection.unwrap(pooledConnectionClass);
                    Connection result = (Connection)ReflectionUtils.invokeMethod(pooledConnectionClass, pooledConnectionInstance, "getConnection");
                    return result != null ? result : wrappedConnection;
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
            this.log.warning("Couldn't determine the password from JdbcConnection. It is a not supported proxy class: " + invocationHandler.getClass().getName());
        }
        return wrappedConnection;
    }

    private Connection getDelegatedDbcpConnection(Connection con) {
        Connection result = (Connection)ReflectionUtils.invokeMethod("org.apache.commons.dbcp.DelegatingConnection", (Object)con, "getInnermostDelegateInternal");
        return result != null ? result : con;
    }

    private Connection getDelegatedDbcp2Connection(Connection con) {
        Connection result = (Connection)ReflectionUtils.invokeMethod("org.apache.commons.dbcp2.DelegatingConnection", (Object)con, "getInnermostDelegateInternal");
        return result != null ? result : con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadLiquibaseProperties() throws IOException {
        Properties properties = new Properties();
        File propertiesFile = new File(DEFAULT_LIQUIBASE_PROPERTIES_FILENAME);
        if (propertiesFile.exists()) {
            try (FileInputStream stream = new FileInputStream(propertiesFile);){
                properties.load(stream);
            }
        }
        InputStream stream = DatabaseConnectionUtil.class.getClassLoader().getResourceAsStream(DEFAULT_LIQUIBASE_PROPERTIES_FILENAME);
        if (stream != null) {
            try {
                properties.load(stream);
            }
            finally {
                stream.close();
            }
        }
        return properties;
    }
}

