/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import java.util.List;
import java.util.stream.Collectors;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractRunCommandStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.nosql.statement.NoSqlQueryForListStatement;
import org.bson.Document;

public class ListCollectionNamesStatement
extends AbstractRunCommandStatement
implements NoSqlQueryForListStatement<MongoLiquibaseDatabase, String> {
    static final String RUN_COMMAND_NAME = "listCollections";
    public static final String FILTER = "filter";
    public static final String CURSOR = "cursor";
    public static final String FIRST_BATCH = "firstBatch";
    public static final String NAME = "name";
    public static final String AUTHORIZED_COLLECTIONS = "authorizedCollections";
    public static final String NAME_ONLY = "nameOnly";

    public ListCollectionNamesStatement() {
        this(new Document());
    }

    public ListCollectionNamesStatement(Document filter) {
        super(BsonUtils.toCommand(RUN_COMMAND_NAME, 1, ListCollectionNamesStatement.combine(filter)));
    }

    @Override
    public String getRunCommandName() {
        return RUN_COMMAND_NAME;
    }

    @Override
    public List<String> queryForList(MongoLiquibaseDatabase database) {
        Document response = super.run(database);
        List firstBatch = (List)((Object)((Document)((Object)response.get((Object)CURSOR, Document.class))).get((Object)FIRST_BATCH, List.class));
        return firstBatch.stream().map(document -> document.getString(NAME)).collect(Collectors.toList());
    }

    private static Document combine(Document filter) {
        return new Document(FILTER, filter).append(AUTHORIZED_COLLECTIONS, true).append(NAME_ONLY, true);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListCollectionNamesStatement)) {
            return false;
        }
        ListCollectionNamesStatement other = (ListCollectionNamesStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ListCollectionNamesStatement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

