/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.changelog;

import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import liquibase.ChecksumVersion;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.TagDatabaseChange;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.mongodb.changelog.AdjustChangeLogCollectionStatement;
import liquibase.ext.mongodb.changelog.CreateChangeLogCollectionStatement;
import liquibase.ext.mongodb.changelog.GetMaxChangeSetSequenceStatement;
import liquibase.ext.mongodb.changelog.MongoRanChangeSet;
import liquibase.ext.mongodb.changelog.MongoRanChangeSetToDocumentConverter;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.CountCollectionByNameStatement;
import liquibase.ext.mongodb.statement.CountDocumentsInCollectionStatement;
import liquibase.ext.mongodb.statement.DeleteManyStatement;
import liquibase.ext.mongodb.statement.DropCollectionStatement;
import liquibase.ext.mongodb.statement.FindAllStatement;
import liquibase.ext.mongodb.statement.FindOneAndUpdateStatement;
import liquibase.ext.mongodb.statement.InsertOneStatement;
import liquibase.ext.mongodb.statement.UpdateManyStatement;
import liquibase.logging.Logger;
import liquibase.nosql.changelog.AbstractNoSqlHistoryService;
import liquibase.statement.SqlStatement;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoHistoryService
extends AbstractNoSqlHistoryService<MongoLiquibaseDatabase> {
    private final Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
    private final MongoRanChangeSetToDocumentConverter converter = new MongoRanChangeSetToDocumentConverter();

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    protected Logger getLogger() {
        return this.log;
    }

    public boolean supports(Database database) {
        return "MongoDB".equals(database.getDatabaseProductName());
    }

    public List<RanChangeSet> getRanChangeSets(boolean allowChecksumsUpgrade) throws DatabaseException {
        return this.getRanChangeSets();
    }

    public boolean isDatabaseChecksumsCompatible() {
        return false;
    }

    @Override
    protected Boolean existsRepository() throws DatabaseException {
        return this.getExecutor().queryForLong((SqlStatement)new CountCollectionByNameStatement(this.getDatabaseChangeLogTableName())) == 1L;
    }

    @Override
    protected void createRepository() throws DatabaseException {
        CreateChangeLogCollectionStatement createChangeLogCollectionStatement = new CreateChangeLogCollectionStatement(this.getDatabaseChangeLogTableName());
        this.getExecutor().execute((SqlStatement)createChangeLogCollectionStatement);
    }

    @Override
    protected void adjustRepository() throws DatabaseException {
        if (((MongoLiquibaseDatabase)((Object)this.getNoSqlDatabase())).getAdjustTrackingTablesOnStartup().booleanValue()) {
            this.getLogger().info("Adjusting database history Collection with name: " + this.getDatabase().getConnection().getCatalog() + "." + this.getDatabaseChangeLogTableName());
            this.getLogger().info("Adjusted database history Collection with name: " + this.getDatabase().getConnection().getCatalog() + "." + this.getDatabaseChangeLogTableName());
            this.getExecutor().execute((SqlStatement)new AdjustChangeLogCollectionStatement(this.getDatabaseChangeLogTableName()));
        } else {
            this.getLogger().info("Skipped Adjusting database history Collection with name: " + this.getDatabase().getConnection().getCatalog() + "." + this.getDatabaseChangeLogTableName());
        }
    }

    @Override
    protected void dropRepository() throws DatabaseException {
        this.getExecutor().execute((SqlStatement)new DropCollectionStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected List<RanChangeSet> queryRanChangeSets() throws DatabaseException {
        Document filter = new Document();
        Bson sort = Sorts.ascending("orderExecuted");
        return this.getExecutor().queryForList((SqlStatement)new FindAllStatement(this.getDatabaseChangeLogTableName(), filter, sort), Document.class).stream().map(Document.class::cast).map(this.getConverter()::fromDocument).collect(Collectors.toList());
    }

    @Override
    protected Integer generateNextSequence() throws DatabaseException {
        return (int)this.getExecutor().queryForLong((SqlStatement)new GetMaxChangeSetSequenceStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    protected void markChangeSetRun(ChangeSet changeSet, ChangeSet.ExecType execType, Integer nextSequenceValue) throws DatabaseException {
        ChecksumVersion currentChecksumVersion;
        String tag = this.extractTag(changeSet);
        Date dateExecuted = new Date(this.getClock().instant().toEpochMilli());
        ChecksumVersion checksumVersion = currentChecksumVersion = changeSet.getStoredCheckSum() != null ? ChecksumVersion.enumFromChecksumVersion((int)changeSet.getStoredCheckSum().getVersion()) : ChecksumVersion.latest();
        if (execType.ranBefore) {
            Bson filter = Filters.and(Filters.eq("fileName", changeSet.getFilePath()), Filters.eq("id", changeSet.getId()), Filters.eq("author", changeSet.getAuthor()));
            ArrayList<Bson> updates = new ArrayList<Bson>();
            updates.add(Updates.set("dateExecuted", dateExecuted));
            updates.add(Updates.set("orderExecuted", nextSequenceValue));
            updates.add(Updates.set("md5sum", changeSet.generateCheckSum(currentChecksumVersion).toString()));
            updates.add(Updates.set("execType", execType.value));
            updates.add(Updates.set("deploymentId", this.getDeploymentId()));
            if (Objects.nonNull(tag)) {
                updates.add(Updates.set("tag", tag));
            }
            Bson update = Updates.combine(updates);
            this.getExecutor().update((SqlStatement)new UpdateManyStatement(this.getDatabaseChangeLogTableName(), filter, update));
        } else {
            MongoRanChangeSet insertRanChangeSet = new MongoRanChangeSet(changeSet.getFilePath(), changeSet.getId(), changeSet.getAuthor(), changeSet.generateCheckSum(currentChecksumVersion), dateExecuted, tag, execType, changeSet.getDescription(), changeSet.getComments(), changeSet.getContexts(), changeSet.getInheritableContextFilter(), changeSet.getLabels(), this.getDeploymentId(), nextSequenceValue, LiquibaseUtil.getBuildVersion());
            this.getExecutor().execute((SqlStatement)new InsertOneStatement(this.getDatabaseChangeLogTableName(), this.getConverter().toDocument(insertRanChangeSet), new Document()));
        }
    }

    public String extractTag(ChangeSet changeSet) {
        String tag = null;
        for (Change change : changeSet.getChanges()) {
            if (!(change instanceof TagDatabaseChange)) continue;
            TagDatabaseChange tagChange = (TagDatabaseChange)change;
            tag = StringUtil.trimToNull((String)tagChange.getTag());
        }
        return tag;
    }

    @Override
    protected void removeRanChangeSet(ChangeSet changeSet) throws DatabaseException {
        Bson filter = Filters.and(Filters.eq("fileName", changeSet.getFilePath()), Filters.eq("id", changeSet.getId()), Filters.eq("author", changeSet.getAuthor()));
        this.getExecutor().update((SqlStatement)new DeleteManyStatement(this.getDatabaseChangeLogTableName(), filter));
    }

    @Override
    protected void clearChekSums() throws DatabaseException {
        Document filter = new Document();
        Bson update = Updates.set("md5sum", null);
        this.getExecutor().update((SqlStatement)new UpdateManyStatement(this.getDatabaseChangeLogTableName(), filter, update));
    }

    @Override
    protected long countTags(String tag) throws DatabaseException {
        Bson filter = Filters.eq("tag", tag);
        return this.getExecutor().queryForLong((SqlStatement)new CountDocumentsInCollectionStatement(this.getDatabaseChangeLogTableName(), filter));
    }

    @Override
    protected void tagLast(String tagString) throws DatabaseException {
        Document filter = new Document();
        Bson update = Updates.set("tag", tagString);
        Bson sort = Sorts.descending("dateExecuted", "orderExecuted");
        this.getExecutor().update((SqlStatement)new FindOneAndUpdateStatement(this.getDatabaseChangeLogTableName(), filter, update, sort));
    }

    @Override
    protected long countRanChangeSets() throws DatabaseException {
        return this.getExecutor().queryForLong((SqlStatement)new CountDocumentsInCollectionStatement(this.getDatabaseChangeLogTableName()));
    }

    @Override
    public void updateCheckSum(ChangeSet changeSet) throws DatabaseException {
        Bson filter = Filters.and(Filters.eq("fileName", changeSet.getFilePath()), Filters.eq("id", changeSet.getId()), Filters.eq("author", changeSet.getAuthor()));
        ChecksumVersion currentChecksumVersion = changeSet.getStoredCheckSum() != null ? ChecksumVersion.enumFromChecksumVersion((int)changeSet.getStoredCheckSum().getVersion()) : ChecksumVersion.latest();
        Bson update = Updates.set("md5sum", changeSet.generateCheckSum(currentChecksumVersion).toString());
        this.getExecutor().update((SqlStatement)new UpdateManyStatement(this.getDatabaseChangeLogTableName(), filter, update));
    }

    public MongoRanChangeSetToDocumentConverter getConverter() {
        return this.converter;
    }
}

