/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.binding.AsyncConnectionSource;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.QueryResult;
import com.mongodb.internal.diagnostics.logging.Logger;
import com.mongodb.internal.diagnostics.logging.Loggers;
import com.mongodb.internal.operation.CommandResultDocumentCodec;
import com.mongodb.internal.operation.CursorHelper;
import com.mongodb.internal.operation.DocumentHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.QueryHelper;
import com.mongodb.internal.operation.ServerVersionHelper;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

class AsyncQueryBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private static final Logger LOGGER = Loggers.getLogger("operation");
    private static final FieldNameValidator NO_OP_FIELD_NAME_VALIDATOR = new NoOpFieldNameValidator();
    private static final String CURSOR = "cursor";
    private static final String POST_BATCH_RESUME_TOKEN = "postBatchResumeToken";
    private static final String OPERATION_TIME = "operationTime";
    private final MongoNamespace namespace;
    private final int limit;
    private final Decoder<T> decoder;
    private final long maxTimeMS;
    private volatile AsyncConnectionSource connectionSource;
    private volatile AsyncConnection pinnedConnection;
    private final AtomicReference<ServerCursor> cursor;
    private volatile QueryResult<T> firstBatch;
    private volatile int batchSize;
    private final AtomicInteger count = new AtomicInteger();
    private volatile BsonDocument postBatchResumeToken;
    private final BsonTimestamp operationTime;
    private final BsonValue comment;
    private final boolean firstBatchEmpty;
    private final int maxWireVersion;
    private boolean isOperationInProgress = false;
    private boolean isClosed = false;
    private volatile boolean isClosePending = false;

    AsyncQueryBatchCursor(QueryResult<T> firstBatch, int limit, int batchSize, long maxTimeMS, Decoder<T> decoder, BsonValue comment, AsyncConnectionSource connectionSource, AsyncConnection connection) {
        this(firstBatch, limit, batchSize, maxTimeMS, decoder, comment, connectionSource, connection, null);
    }

    AsyncQueryBatchCursor(QueryResult<T> firstBatch, int limit, int batchSize, long maxTimeMS, Decoder<T> decoder, BsonValue comment, AsyncConnectionSource connectionSource, @Nullable AsyncConnection connection, @Nullable BsonDocument result) {
        Assertions.isTrueArgument("maxTimeMS >= 0", maxTimeMS >= 0L);
        this.maxTimeMS = maxTimeMS;
        this.namespace = firstBatch.getNamespace();
        this.firstBatch = firstBatch;
        this.limit = limit;
        this.batchSize = batchSize;
        this.decoder = decoder;
        this.comment = comment;
        this.cursor = new AtomicReference<ServerCursor>(firstBatch.getCursor());
        this.count.addAndGet(firstBatch.getResults().size());
        if (result != null) {
            this.operationTime = result.getTimestamp(OPERATION_TIME, null);
            this.postBatchResumeToken = this.getPostBatchResumeTokenFromResponse(result);
        } else {
            this.operationTime = null;
        }
        this.firstBatchEmpty = firstBatch.getResults().isEmpty();
        if (this.cursor.get() != null) {
            this.connectionSource = Assertions.notNull("connectionSource", connectionSource).retain();
            Assertions.assertNotNull(connection);
            if (this.limitReached()) {
                this.killCursor(connection);
            } else if (connectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER) {
                this.pinnedConnection = connection.retain();
                this.pinnedConnection.markAsPinned(Connection.PinningMode.CURSOR);
            }
        }
        this.maxWireVersion = connection == null ? 0 : connection.getDescription().getMaxWireVersion();
        this.logQueryResult(firstBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        boolean doClose = false;
        AsyncQueryBatchCursor asyncQueryBatchCursor = this;
        synchronized (asyncQueryBatchCursor) {
            if (this.isOperationInProgress) {
                this.isClosePending = true;
            } else if (!this.isClosed) {
                this.isClosed = true;
                this.isClosePending = false;
                doClose = true;
            }
        }
        if (doClose) {
            this.killCursorOnClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        if (this.isClosed()) {
            callback.onResult(null, new MongoException("next() called after the cursor was closed."));
        } else if (this.firstBatch != null && !this.firstBatch.getResults().isEmpty()) {
            List<T> results = this.firstBatch.getResults();
            this.firstBatch = null;
            if (this.getServerCursor() == null) {
                this.close();
            }
            callback.onResult(results, null);
        } else {
            ServerCursor localCursor = this.getServerCursor();
            if (localCursor == null) {
                this.close();
                callback.onResult(null, null);
            } else {
                AsyncQueryBatchCursor asyncQueryBatchCursor = this;
                synchronized (asyncQueryBatchCursor) {
                    if (this.isClosed()) {
                        callback.onResult(null, new MongoException("next() called after the cursor was closed."));
                        return;
                    }
                    this.isOperationInProgress = true;
                }
                this.getMore(localCursor, callback);
            }
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        Assertions.assertFalse(this.isClosed());
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        Assertions.assertFalse(this.isClosed());
        return this.batchSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        AsyncQueryBatchCursor asyncQueryBatchCursor = this;
        synchronized (asyncQueryBatchCursor) {
            return this.isClosed || this.isClosePending;
        }
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.postBatchResumeToken;
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.operationTime;
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private boolean limitReached() {
        return Math.abs(this.limit) != 0 && this.count.get() >= Math.abs(this.limit);
    }

    private void getMore(ServerCursor cursor, SingleResultCallback<List<T>> callback) {
        if (this.pinnedConnection != null) {
            this.getMore(this.pinnedConnection.retain(), cursor, callback);
        } else {
            this.connectionSource.getConnection((connection, t) -> {
                if (t != null) {
                    this.endOperationInProgress();
                    callback.onResult(null, t);
                } else {
                    this.getMore(Assertions.assertNotNull(connection), cursor, callback);
                }
            });
        }
    }

    private void getMore(AsyncConnection connection, ServerCursor cursor, SingleResultCallback<List<T>> callback) {
        connection.commandAsync(this.namespace.getDatabaseName(), this.asGetMoreCommandDocument(cursor.getId(), connection.getDescription()), NO_OP_FIELD_NAME_VALIDATOR, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), this.connectionSource, new CommandResultSingleResultCallback(connection, cursor, callback));
    }

    private BsonDocument asGetMoreCommandDocument(long cursorId, ConnectionDescription connectionDescription) {
        BsonDocument document = new BsonDocument("getMore", new BsonInt64(cursorId)).append("collection", new BsonString(this.namespace.getCollectionName()));
        int batchSizeForGetMoreCommand = Math.abs(CursorHelper.getNumberToReturn(this.limit, this.batchSize, this.count.get()));
        if (batchSizeForGetMoreCommand != 0) {
            document.append("batchSize", new BsonInt32(batchSizeForGetMoreCommand));
        }
        if (this.maxTimeMS != 0L) {
            document.append("maxTimeMS", new BsonInt64(this.maxTimeMS));
        }
        if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
            DocumentHelper.putIfNotNull(document, "comment", this.comment);
        }
        return document;
    }

    private void killCursorOnClose() {
        ServerCursor localCursor = this.getServerCursor();
        if (localCursor != null) {
            if (this.pinnedConnection != null) {
                this.killCursorAsynchronouslyAndReleaseConnectionAndSource(this.pinnedConnection, localCursor);
            } else {
                this.connectionSource.getConnection((connection, t) -> {
                    if (t != null) {
                        this.connectionSource.release();
                    } else {
                        this.killCursorAsynchronouslyAndReleaseConnectionAndSource(Assertions.assertNotNull(connection), localCursor);
                    }
                });
            }
        } else if (this.pinnedConnection != null) {
            this.pinnedConnection.release();
        }
    }

    private void killCursor(AsyncConnection connection) {
        ServerCursor localCursor = this.cursor.getAndSet(null);
        if (localCursor != null) {
            this.killCursorAsynchronouslyAndReleaseConnectionAndSource(connection.retain(), localCursor);
        } else {
            this.connectionSource.release();
        }
    }

    private void killCursorAsynchronouslyAndReleaseConnectionAndSource(AsyncConnection connection, ServerCursor localCursor) {
        connection.commandAsync(this.namespace.getDatabaseName(), this.asKillCursorsCommandDocument(localCursor), NO_OP_FIELD_NAME_VALIDATOR, ReadPreference.primary(), new BsonDocumentCodec(), this.connectionSource, (result, t) -> {
            connection.release();
            this.connectionSource.release();
        });
    }

    private BsonDocument asKillCursorsCommandDocument(ServerCursor localCursor) {
        return new BsonDocument("killCursors", new BsonString(this.namespace.getCollectionName())).append("cursors", new BsonArray(Collections.singletonList(new BsonInt64(localCursor.getId()))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOperationInProgress() {
        boolean closePending;
        AsyncQueryBatchCursor asyncQueryBatchCursor = this;
        synchronized (asyncQueryBatchCursor) {
            this.isOperationInProgress = false;
            closePending = this.isClosePending;
        }
        if (closePending) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetMoreQueryResult(AsyncConnection connection, SingleResultCallback<List<T>> callback, QueryResult<T> result) {
        this.logQueryResult(result);
        this.cursor.set(result.getCursor());
        if (this.isClosePending) {
            try {
                connection.release();
                if (result.getCursor() == null) {
                    this.connectionSource.release();
                }
                this.endOperationInProgress();
            }
            finally {
                callback.onResult(null, null);
            }
        } else if (result.getResults().isEmpty() && result.getCursor() != null) {
            this.getMore(connection, Assertions.assertNotNull(result.getCursor()), callback);
        } else {
            this.count.addAndGet(result.getResults().size());
            if (this.limitReached()) {
                this.killCursor(connection);
                connection.release();
            } else {
                connection.release();
                if (result.getCursor() == null) {
                    this.connectionSource.release();
                }
            }
            this.endOperationInProgress();
            if (result.getResults().isEmpty()) {
                callback.onResult(null, null);
            } else {
                callback.onResult(result.getResults(), null);
            }
        }
    }

    private void logQueryResult(QueryResult<T> result) {
        LOGGER.debug(String.format("Received batch of %d documents with cursorId %d from server %s", result.getResults().size(), result.getCursorId(), result.getAddress()));
    }

    @Nullable
    ServerCursor getServerCursor() {
        return this.cursor.get();
    }

    @Nullable
    private BsonDocument getPostBatchResumeTokenFromResponse(BsonDocument result) {
        BsonDocument cursor = result.getDocument(CURSOR, null);
        if (cursor != null) {
            return cursor.getDocument(POST_BATCH_RESUME_TOKEN, null);
        }
        return null;
    }

    private class CommandResultSingleResultCallback
    implements SingleResultCallback<BsonDocument> {
        private final AsyncConnection connection;
        private final ServerCursor cursor;
        private final SingleResultCallback<List<T>> callback;

        CommandResultSingleResultCallback(AsyncConnection connection, ServerCursor cursor, SingleResultCallback<List<T>> callback) {
            this.connection = connection;
            this.cursor = cursor;
            this.callback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        }

        @Override
        public void onResult(@Nullable BsonDocument result, @Nullable Throwable t) {
            if (t != null) {
                Throwable translatedException = t instanceof MongoCommandException ? QueryHelper.translateCommandException((MongoCommandException)t, this.cursor) : t;
                this.connection.release();
                AsyncQueryBatchCursor.this.endOperationInProgress();
                this.callback.onResult(null, translatedException);
            } else {
                Assertions.assertNotNull(result);
                QueryResult queryResult = OperationHelper.getMoreCursorDocumentToQueryResult(result.getDocument(AsyncQueryBatchCursor.CURSOR), this.connection.getDescription().getServerAddress());
                AsyncQueryBatchCursor.this.postBatchResumeToken = AsyncQueryBatchCursor.this.getPostBatchResumeTokenFromResponse(result);
                AsyncQueryBatchCursor.this.handleGetMoreQueryResult(this.connection, this.callback, queryResult);
            }
        }
    }
}

