/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.client.model;

import com.mongodb.internal.client.model.AbstractConstructibleBson;
import com.mongodb.internal.client.model.ToMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public abstract class AbstractConstructibleBsonElement<S extends AbstractConstructibleBsonElement<S>>
implements Bson,
ToMap {
    private final Bson baseElement;
    private final AbstractConstructibleBson<?> appendedElementValue;

    protected AbstractConstructibleBsonElement(String name) {
        this(name, AbstractConstructibleBson.EMPTY_IMMUTABLE);
    }

    protected AbstractConstructibleBsonElement(String name, Bson value) {
        this(new Document(name, value));
    }

    protected AbstractConstructibleBsonElement(Bson baseElement) {
        this(baseElement, AbstractConstructibleBson.EMPTY_IMMUTABLE);
    }

    protected AbstractConstructibleBsonElement(Bson baseElement, Bson appendedElementValue) {
        this.baseElement = baseElement;
        this.appendedElementValue = AbstractConstructibleBson.of(appendedElementValue);
    }

    protected abstract S newSelf(Bson var1, Bson var2);

    protected final S newWithAppendedValue(String name, Object value) {
        return this.newWithMutatedValue(doc -> doc.append(name, value));
    }

    protected final S newWithMutatedValue(Consumer<Document> mutator) {
        return this.newSelf(this.baseElement, (Bson)this.appendedElementValue.newMutated(mutator));
    }

    @Override
    public final <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
        BsonDocument baseElementDoc = this.baseElement.toBsonDocument(documentClass, codecRegistry);
        if (baseElementDoc.size() != 1) {
            throw new IllegalStateException(String.format("baseElement must contain exactly one element, but contains %s", baseElementDoc.size()));
        }
        Map.Entry<String, BsonValue> baseElementEntry = baseElementDoc.entrySet().iterator().next();
        String baseElementName = baseElementEntry.getKey();
        BsonValue baseElementValue = baseElementEntry.getValue();
        if (!baseElementValue.isDocument()) {
            throw new IllegalStateException(String.format("baseElement value must be a document, but it is %s", new Object[]{baseElementValue.getBsonType()}));
        }
        BsonDocument baseElementValueDoc = baseElementValue.asDocument();
        BsonDocument appendedElementValueDoc = this.appendedElementValue.toBsonDocument(documentClass, codecRegistry);
        return appendedElementValueDoc.isEmpty() ? baseElementDoc : new BsonDocument(baseElementName, AbstractConstructibleBson.newMerged(baseElementValueDoc, appendedElementValueDoc));
    }

    @Override
    public Optional<Map<String, ?>> tryToMap() {
        Map appendedElementValueMap;
        Map baseElementMap = ToMap.tryToMap(this.baseElement).orElse(null);
        Map map = appendedElementValueMap = baseElementMap == null ? null : (Map)this.appendedElementValue.tryToMap().orElse(null);
        if (baseElementMap != null && appendedElementValueMap != null) {
            if (baseElementMap.size() != 1) {
                throw new IllegalStateException(String.format("baseElement must contain exactly one element, but contains %s", baseElementMap.size()));
            }
            Map.Entry baseEntry = baseElementMap.entrySet().iterator().next();
            String elementName = (String)baseEntry.getKey();
            return ToMap.tryToMap(baseEntry.getValue()).map(elementValueMap -> {
                LinkedHashMap result = new LinkedHashMap(elementValueMap);
                result.putAll(appendedElementValueMap);
                return result;
            }).map(mergedElementValueMap -> {
                LinkedHashMap<String, Document> result = new LinkedHashMap<String, Document>();
                result.put(elementName, new Document((Map<String, ?>)mergedElementValueMap));
                return result;
            });
        }
        return Optional.empty();
    }

    public static AbstractConstructibleBsonElement<?> of(Bson baseElement) {
        return baseElement instanceof AbstractConstructibleBsonElement ? (AbstractConstructibleBsonElement)baseElement : new ConstructibleBsonElement(baseElement, AbstractConstructibleBson.EMPTY_IMMUTABLE);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractConstructibleBsonElement that = (AbstractConstructibleBsonElement)o;
        return this.baseElement.equals(that.baseElement) && this.appendedElementValue.equals(that.appendedElementValue);
    }

    public final int hashCode() {
        return Objects.hash(this.baseElement, this.appendedElementValue);
    }

    public String toString() {
        return this.tryToMap().map(Document::new).map(Document::toString).orElseGet(() -> "ConstructibleBsonElement{baseElement=" + this.baseElement + ", appendedElementValue=" + this.appendedElementValue + '}');
    }

    private static final class ConstructibleBsonElement
    extends AbstractConstructibleBsonElement<ConstructibleBsonElement> {
        private ConstructibleBsonElement(Bson baseElement, Bson appendedElementValue) {
            super(baseElement, appendedElementValue);
        }

        @Override
        protected ConstructibleBsonElement newSelf(Bson baseElement, Bson appendedElementValue) {
            return new ConstructibleBsonElement(baseElement, appendedElementValue);
        }
    }
}

