/*
 * Decompiled with CFR 0.152.
 */
package com.liquibase.ext.tools;

import com.datical.liquibase.ext.util.NativeRunnerUtil;
import com.liquibase.ext.config.MongoShConfiguration;
import com.liquibase.ext.tools.MongoshFileCreator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.TimeoutException;
import liquibase.Scope;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.mongodb.database.MongoConnection;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.logging.Logger;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class MongoshRunner
extends ExecuteShellCommandChange {
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private Boolean keepTempFile = false;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private String logFile;
    private Integer timeout;
    private File mongoshExec;
    private static final String EXECUTABLE_NAME = "mongosh";
    private static final String MONGOSH_CONF = "liquibase.mongosh.conf";
    private static final ResourceBundle mongoshBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-mongosh");
    private static final String MSG_UNABLE_TO_RUN_MONGOSH = mongoshBundle.getString("unable.to.run.mongosh");

    public MongoshRunner() {
    }

    public MongoshRunner(ChangeSet changeSet, Sql[] sqlStrings) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlStrings;
        this.setTimeout("1800");
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    protected List<String> createFinalCommandArray(Database database) {
        this.loadMongoshProperties();
        List commandArray = super.createFinalCommandArray(database);
        try {
            this.writeSqlStrings();
        }
        catch (Exception ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
        if (!this.args.isEmpty()) {
            commandArray.addAll(Collections.unmodifiableList(this.args));
        }
        if (this.sqlStrings != null) {
            MongoLiquibaseDatabase mongoDatabase = (MongoLiquibaseDatabase)database;
            MongoConnection connection = (MongoConnection)mongoDatabase.getConnection();
            commandArray.add(connection.getConnectionString().getConnectionString());
            if (this.outFile != null) {
                commandArray.add("--file");
                commandArray.add(this.outFile.getAbsolutePath());
            } else {
                commandArray.add("--eval");
                commandArray.add(this.sqlStrings[0].toSql());
            }
        } else {
            commandArray.add("--version");
        }
        String commandLine = StringUtil.join((Collection)commandArray, (String)" ");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("mongosh command:\n" + commandLine.replaceAll("://.*:.*@", "://<credentials>@"));
        return commandArray;
    }

    protected void processResult(int returnCode, String errorStreamOut, String infoStreamOut, Database database) {
        if (this.logFile != null && this.outFile != null) {
            try {
                if (!infoStreamOut.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), infoStreamOut.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                if (!errorStreamOut.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), errorStreamOut.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
            }
            catch (IOException writeException) {
                throw new UnexpectedLiquibaseException((Throwable)writeException);
            }
        }
        if (returnCode != 0 && !StringUtil.isEmpty((String)infoStreamOut)) {
            String returnString = this.getCommandString() + " returned a code of " + returnCode + "\n" + infoStreamOut + "Learn more at https://docs.liquibase.com/mongodb";
            throw new UnexpectedLiquibaseException(returnString);
        }
        super.processResult(returnCode, errorStreamOut, infoStreamOut, database);
    }

    private void writeSqlStrings() throws Exception {
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.info("Creating the mongosh run script");
        MongoshFileCreator mongoshFileCreator = new MongoshFileCreator(this.changeSet, this.tempName, this.tempPath, true, this.keepTempFile == null ? (Boolean)MongoShConfiguration.TEMP_KEEP.getDefaultValue() : this.keepTempFile);
        try {
            this.outFile = mongoshFileCreator.generateTemporaryFile(".txt");
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        Path path = Paths.get(this.outFile.getAbsolutePath(), new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            for (Sql sql : this.sqlStrings) {
                String line = sql.toSql();
                line = line.replace("\r", "");
                writer.write(line);
            }
            writer.write(";\n");
        }
    }

    public void executeCommand(Database database) throws Exception {
        try {
            this.finalCommandArray = this.createFinalCommandArray(database);
            super.executeCommand(database);
        }
        catch (TimeoutException e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.processResult(0, null, null, database);
            String message = e.getMessage() + System.lineSeparator() + "Error: The mongosh executable failed to return a response with the configured timeout. Please check liquibase.mongosh.timeout specified in liquibase.mongosh.conf file, the LIQUIBASE_MONGOSH_TIMEOUT environment variable, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html and https://docs.liquibase.com/mongodb" + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(MongoshRunner.class).warning(message);
            throw new LiquibaseException((Throwable)e);
        }
        catch (IOException e) {
            if (e.getMessage().contains(EXECUTABLE_NAME)) {
                throw new LiquibaseException(MSG_UNABLE_TO_RUN_MONGOSH, (Throwable)e);
            }
            throw new LiquibaseException((Throwable)e);
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
        finally {
            if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Mongosh run script can be located at: " + this.outFile.getAbsolutePath());
            }
        }
    }

    private void loadMongoshProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable((String)EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(MONGOSH_CONF);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        this.handleMongoShExecutable(this.mongoshExec);
        this.handleTimeout(this.timeout);
        this.logProperties();
    }

    public Properties getPropertiesFromConf(String configFile) {
        Properties properties = new Properties();
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        InputStream is = null;
        try {
            Resource resource = resourceAccessor.get(configFile);
            if (!resource.exists()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(String.format("No configuration file named '%s' found.", configFile));
            } else {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(String.format("%s configuration file located at '%s'.", configFile, resource.getUri()));
                is = resource.openInputStream();
                properties.load(is);
            }
        }
        catch (IOException ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
        }
        return properties;
    }

    private int determineTimeout(Properties properties) {
        String timeoutString = properties.getProperty("liquibase.mongosh.timeout");
        if (timeoutString == null) {
            return -1;
        }
        try {
            return Integer.parseInt(timeoutString);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Invalid value '" + timeoutString + "' for property 'liquibase.mongosh.timeout'. Must be a valid integer. Learn more at https://docs.liquibase.com/mongodb");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a log file value of '" + this.logFile + "'");
        }
    }

    private void handleArgs(String argsString) {
        if (argsString != null) {
            argsString = argsString.trim();
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a extra arguments of '" + argsString + "'");
            this.args = StringUtil.splitAndTrim((String)argsString, (String)" ");
        }
    }

    private void handleTimeout(Integer timeout) {
        if (timeout != null) {
            NativeRunnerUtil.validateTimeout((Integer)timeout);
            this.setTimeout(String.valueOf(timeout));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'mongosh' with a timeout of '" + timeout + "'");
        }
    }

    private void handleMongoShExecutable(File mongoshExec) {
        if (mongoshExec == null) {
            return;
        }
        if (!mongoshExec.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'mongosh' cannot be found at path '" + mongoshExec.getAbsolutePath() + "' as specified in the liquibase.mongosh.conf file, the LIQUIBASE_MONGOSH_* environment variables, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html and https://docs.liquibase.com/mongodb");
        }
        if (!mongoshExec.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'mongosh' executable in the liquibase.mongosh.conf file at " + mongoshExec.getAbsolutePath() + " cannot be executed. Learn more at https://docs.liquibase.com/mongodb");
        }
        try {
            this.setExecutable(mongoshExec.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'mongosh' executable located at:  '" + mongoshExec.getCanonicalPath() + "'");
            this.mongoshExec = mongoshExec;
        }
        catch (IOException ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
    }

    private void setupConfProperties(Properties properties) {
        if (properties.containsKey(MongoShConfiguration.ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties((Properties)properties, (String)MongoShConfiguration.ConfigurationKeys.getFullKey("keep.temp"));
        }
        if (properties.containsKey(MongoShConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(MongoShConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(MongoShConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(MongoShConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(MongoShConfiguration.ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(MongoShConfiguration.ConfigurationKeys.getFullKey("logFile"));
        }
        if (properties.containsKey("liquibase.mongosh.path")) {
            this.mongoshExec = new File(properties.getProperty("liquibase.mongosh.path"));
        }
        if (properties.containsKey("liquibase.mongosh.timeout")) {
            this.timeout = this.determineTimeout(properties);
        }
        if (properties.containsKey("liquibase.mongosh.args")) {
            this.handleArgs(properties.getProperty("liquibase.mongosh.args"));
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.keepTempFile = MongoShConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)MongoShConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        this.tempName = MongoShConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)MongoShConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = MongoShConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)MongoShConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.logFile = MongoShConfiguration.LOG_FILE.getCurrentValue() != null ? (String)MongoShConfiguration.LOG_FILE.getCurrentValue() : this.logFile;
        Integer n = this.timeout = MongoShConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)MongoShConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        if (MongoShConfiguration.PATH.getCurrentValue() != null) {
            this.mongoshExec = new File((String)MongoShConfiguration.PATH.getCurrentValue());
        }
        if (MongoShConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)MongoShConfiguration.ARGS.getCurrentValue());
        }
    }
}

