/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import java.io.InputStream;
import java.security.MessageDigest;
import org.linguafranca.pwdb.security.Aes;
import org.linguafranca.pwdb.security.Encryption;

public class KdbHeader {
    public static final int FLAG_SHA2 = 1;
    public static final int FLAG_RIJNDAEL = 2;
    public static final int FLAG_ARCFOUR = 4;
    public static final int FLAG_TWOFISH = 8;
    private int flags;
    private int version;
    private byte[] masterSeed;
    private byte[] encryptionIv;
    private long groupCount;
    private long entryCount;
    private byte[] contentHash;
    private byte[] transformSeed;
    private long transformRounds;

    public InputStream createDecryptedInputStream(byte[] key, InputStream inputStream) {
        if ((this.flags & 2) == 0) {
            throw new IllegalStateException("StreamEncryptor algorithm is not supported");
        }
        byte[] transformedKeyDigest = Aes.getTransformedKey((byte[])key, (byte[])this.transformSeed, (long)this.transformRounds);
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        md.update(this.masterSeed);
        byte[] finalKeyDigest = md.digest(transformedKeyDigest);
        return Aes.getInstance().getDecryptedInputStream(inputStream, finalKeyDigest, this.encryptionIv);
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public byte[] getMasterSeed() {
        return this.masterSeed;
    }

    public void setMasterSeed(byte[] masterSeed) {
        this.masterSeed = masterSeed;
    }

    public byte[] getEncryptionIv() {
        return this.encryptionIv;
    }

    public void setEncryptionIv(byte[] encryptionIv) {
        this.encryptionIv = encryptionIv;
    }

    public long getGroupCount() {
        return this.groupCount;
    }

    public void setGroupCount(long groupCount) {
        this.groupCount = groupCount;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public void setEntryCount(long entryCount) {
        this.entryCount = entryCount;
    }

    public byte[] getContentHash() {
        return this.contentHash;
    }

    public void setContentHash(byte[] contentHash) {
        this.contentHash = contentHash;
    }

    public byte[] getTransformSeed() {
        return this.transformSeed;
    }

    public void setTransformSeed(byte[] transformSeed) {
        this.transformSeed = transformSeed;
    }

    public long getTransformRounds() {
        return this.transformRounds;
    }

    public void setTransformRounds(long transformRounds) {
        this.transformRounds = transformRounds;
    }
}

