/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdb;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.base.AbstractGroup;
import org.linguafranca.pwdb.kdb.KdbDatabase;
import org.linguafranca.pwdb.kdb.KdbEntry;
import org.linguafranca.pwdb.kdb.KdbIcon;

public class KdbGroup
extends AbstractGroup<KdbDatabase, KdbGroup, KdbEntry, KdbIcon> {
    private boolean root;
    private KdbGroup parent;
    protected KdbDatabase database;
    private UUID uuid = UUID.randomUUID();
    private String name = "";
    private KdbIcon icon = new KdbIcon(0);
    private List<KdbGroup> groups = new ArrayList<KdbGroup>();
    private List<KdbEntry> entries = new ArrayList<KdbEntry>();
    private Date creationTime;
    private Date lastModificationTime = this.creationTime = new Date();
    private Date lastAccessTime = new Date(Long.MIN_VALUE);
    private Date expiryTime = new Date(Long.MAX_VALUE);
    private int flags;

    KdbGroup() {
    }

    public KdbGroup addGroup(KdbGroup group) {
        this.groups.add(group);
        if (group.getParent() != null) {
            group.getParent().removeGroup(group);
        }
        group.parent = this;
        return group;
    }

    public KdbGroup removeGroup(KdbGroup group) {
        this.groups.remove((Object)group);
        group.parent = null;
        return group;
    }

    public List<KdbEntry> getEntries() {
        return new ArrayList<KdbEntry>(this.entries);
    }

    public int getEntriesCount() {
        return this.entries.size();
    }

    public KdbEntry addEntry(KdbEntry entry) {
        KdbGroup entryParent = entry.parent;
        if (entryParent != null) {
            entryParent.removeEntry(entry);
        }
        this.entries.add(entry);
        entry.parent = this;
        return entry;
    }

    public KdbEntry removeEntry(KdbEntry entry) {
        this.entries.remove((Object)entry);
        entry.parent = null;
        return entry;
    }

    int computedLevel() {
        if (this.isRootGroup()) {
            return -1;
        }
        int level = 0;
        KdbGroup currentParent = this.parent;
        if (currentParent == null) {
            return -2;
        }
        while (!currentParent.isRootGroup()) {
            if ((currentParent = currentParent.getParent()) == null) {
                return -3;
            }
            ++level;
        }
        return level;
    }

    public boolean isRootGroup() {
        return this.root;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public KdbGroup getParent() {
        return this.parent;
    }

    public void setParent(KdbGroup parent) {
        parent.addGroup(this);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public KdbIcon getIcon() {
        return this.icon;
    }

    public void setIcon(KdbIcon icon) {
        this.icon = icon;
    }

    public List<KdbGroup> getGroups() {
        return new ArrayList<KdbGroup>(this.groups);
    }

    public int getGroupsCount() {
        return this.groups.size();
    }

    int getFlags() {
        return this.flags;
    }

    void setFlags(int flags) {
        this.flags = flags;
    }

    void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    void setLastModificationTime(Date lastModificationTime) {
        this.lastModificationTime = lastModificationTime;
    }

    void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    void setExpiryTime(Date expiryTime) {
        this.expiryTime = expiryTime;
    }

    void setRoot(boolean root) {
        this.root = root;
    }

    public String toString() {
        String time = KdbDatabase.isoDateFormat.format(this.creationTime);
        return this.getPath() + String.format(" (%s) %s [%d]", this.uuid.toString(), time, this.flags);
    }

    @NotNull
    public KdbDatabase getDatabase() {
        return this.database;
    }

    public boolean isRecycleBin() {
        return false;
    }
}

