/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.spring.boot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.laxture.sbp.spring.boot.SbpProperties;
import org.pf4j.PluginStatusProvider;

public class PropertyPluginStatusProvider
implements PluginStatusProvider {
    private List<String> enabledPlugins;
    private List<String> disabledPlugins;

    public PropertyPluginStatusProvider(SbpProperties sbpProperties) {
        this.enabledPlugins = sbpProperties.getEnabledPlugins() != null ? Arrays.asList(sbpProperties.getEnabledPlugins()) : new ArrayList();
        this.disabledPlugins = sbpProperties.getDisabledPlugins() != null ? Arrays.asList(sbpProperties.getDisabledPlugins()) : new ArrayList();
    }

    public static boolean isPropertySet(SbpProperties sbpProperties) {
        return sbpProperties.getEnabledPlugins() != null && sbpProperties.getEnabledPlugins().length > 0 || sbpProperties.getDisabledPlugins() != null && sbpProperties.getDisabledPlugins().length > 0;
    }

    public boolean isPluginDisabled(String pluginId) {
        if (this.disabledPlugins.contains(pluginId)) {
            return true;
        }
        return !this.enabledPlugins.isEmpty() && !this.enabledPlugins.contains(pluginId);
    }

    public void disablePlugin(String pluginId) {
        if (this.isPluginDisabled(pluginId)) {
            return;
        }
        this.disabledPlugins.add(pluginId);
        this.enabledPlugins.remove(pluginId);
    }

    public void enablePlugin(String pluginId) {
        if (!this.isPluginDisabled(pluginId)) {
            return;
        }
        this.enabledPlugins.add(pluginId);
        this.disabledPlugins.remove(pluginId);
    }
}

