/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.fluent;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.events.EventDefinition;
import io.serverlessworkflow.api.functions.FunctionDefinition;
import io.serverlessworkflow.api.interfaces.State;
import io.serverlessworkflow.api.start.Start;
import io.serverlessworkflow.api.states.DefaultState;
import io.serverlessworkflow.api.workflow.Constants;
import io.serverlessworkflow.api.workflow.Events;
import io.serverlessworkflow.api.workflow.Functions;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.kie.kogito.jackson.utils.JsonObjectUtils;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.fluent.EventDefBuilder;
import org.kie.kogito.serverless.workflow.fluent.FunctionBuilder;
import org.kie.kogito.serverless.workflow.fluent.StateBuilder;
import org.kie.kogito.serverless.workflow.fluent.TransitionBuilder;

public class WorkflowBuilder {
    private static ObjectMapper mapper = ObjectMapperFactory.get();
    private Workflow workflow;
    private List<FunctionDefinition> functions = new LinkedList<FunctionDefinition>();
    private List<EventDefinition> events = new LinkedList<EventDefinition>();
    private List<State> states = new LinkedList<State>();

    public static WorkflowBuilder workflow(String id) {
        return WorkflowBuilder.workflow(id, id, "1_0");
    }

    public static WorkflowBuilder workflow(String id, String name, String version) {
        return new WorkflowBuilder(id, name, version);
    }

    private WorkflowBuilder(String id, String name, String version) {
        this.workflow = new Workflow().withId(id).withName(name).withVersion(version);
    }

    public WorkflowBuilder constant(String name, Object value) {
        Constants constants = this.workflow.getConstants();
        if (constants == null) {
            constants = new Constants((JsonNode)new ObjectMapper().createObjectNode());
            this.workflow.setConstants(constants);
        }
        ((ObjectNode)constants.getConstantsDef()).set(name, JsonObjectUtils.fromValue((Object)value));
        return this;
    }

    public WorkflowBuilder metadata(String name, String value) {
        HashMap<String, String> metadata = this.workflow.getMetadata();
        if (metadata == null) {
            metadata = new HashMap<String, String>();
            this.workflow.setMetadata(metadata);
        }
        metadata.put(name, value);
        return this;
    }

    public TransitionBuilder<WorkflowBuilder> start(StateBuilder<?, ?> stateBuilder) {
        this.addFunctions(stateBuilder.getFunctions());
        this.addEvents(stateBuilder.getEvents());
        Object state = stateBuilder.build();
        this.startState((DefaultState)state);
        return new TransitionBuilder<WorkflowBuilder>(this, this, (DefaultState)state);
    }

    private void startState(DefaultState state) {
        this.states.add((State)state);
        this.workflow.withStart(new Start().withStateName(state.getName()));
    }

    public Workflow build() {
        this.workflow.setStates(this.states);
        this.workflow.withFunctions(new Functions(this.functions));
        this.workflow.withEvents(new Events(this.events));
        return this.workflow;
    }

    public final WorkflowBuilder function(FunctionBuilder functionBuilder) {
        FunctionDefinition function = functionBuilder.build();
        this.functions.add(function);
        return this;
    }

    public final WorkflowBuilder event(EventDefBuilder eventBuilder) {
        EventDefinition event = eventBuilder.build();
        this.events.add(event);
        return this;
    }

    public static ObjectNode jsonObject() {
        return mapper.createObjectNode();
    }

    public static ArrayNode jsonArray() {
        return mapper.createArrayNode();
    }

    void addState(DefaultState state) {
        if (!this.states.contains(state)) {
            this.states.add((State)state);
        }
    }

    void addFunctions(Collection<FunctionBuilder> functions) {
        functions.forEach(this::function);
    }

    void addEvents(Collection<EventDefBuilder> events) {
        events.forEach(this::event);
    }
}

