/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.fluent;

import io.serverlessworkflow.api.functions.FunctionDefinition;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import org.kie.kogito.serverless.workflow.actions.WorkflowLogLevel;
import org.kie.kogito.serverless.workflow.functions.FunctionDefinitionEx;

public class FunctionBuilder {
    private FunctionDefinition functionDefinition;

    public static FunctionBuilder def(String name, FunctionDefinition.Type type, String operation) {
        return new FunctionBuilder(new FunctionDefinition(name).withType(type).withOperation(operation));
    }

    public static FunctionBuilder rest(String name, HttpMethod method, String uri) {
        return new FunctionBuilder(new FunctionDefinition(name).withType(FunctionDefinition.Type.CUSTOM).withOperation("rest:" + method + ":" + uri));
    }

    public static FunctionBuilder expr(String name, String expression) {
        return new FunctionBuilder(new FunctionDefinition(name).withType(FunctionDefinition.Type.EXPRESSION).withOperation(expression));
    }

    public static <T, V> FunctionBuilder java(String funcName, Function<T, V> function) {
        return new FunctionBuilder(new FunctionDefinitionEx(funcName).withFunction(function).withType(FunctionDefinition.Type.CUSTOM).withOperation("java"));
    }

    public static FunctionBuilder java(String funcName, String className, String methodName) {
        return FunctionBuilder.service(funcName, "Java", className, methodName);
    }

    public static FunctionBuilder python(String funcName, String moduleName, String methodName) {
        return FunctionBuilder.service(funcName, "python", moduleName, methodName);
    }

    private static FunctionBuilder service(String name, String langName, String moduleName, String methodName) {
        return new FunctionBuilder(new FunctionDefinition(name).withType(FunctionDefinition.Type.CUSTOM).withOperation("service:" + langName + ":" + moduleName + "::" + methodName));
    }

    public static FunctionBuilder log(String name, WorkflowLogLevel level) {
        return new FunctionBuilder(new FunctionDefinition(name).withType(FunctionDefinition.Type.CUSTOM).withOperation("sysout:" + level));
    }

    private FunctionBuilder(FunctionDefinition functionDefinition) {
        this.functionDefinition = functionDefinition;
    }

    public FunctionBuilder metadata(String key, String value) {
        HashMap<String, String> metadata = this.functionDefinition.getMetadata();
        if (metadata == null) {
            metadata = new HashMap<String, String>();
            this.functionDefinition.withMetadata(metadata);
        }
        metadata.put(key, value);
        return this;
    }

    public FunctionDefinition build() {
        return this.functionDefinition;
    }

    String getName() {
        return this.functionDefinition.getName();
    }

    public int hashCode() {
        return Objects.hash(this.functionDefinition.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FunctionBuilder other = (FunctionBuilder)obj;
        return Objects.equals(this.functionDefinition.getName(), other.functionDefinition.getName());
    }

    public static enum HttpMethod {
        post,
        get,
        put,
        patch,
        delete,
        head,
        trace,
        options,
        connect;

    }
}

