/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.fluent;

import io.serverlessworkflow.api.events.EventDefinition;
import java.util.HashMap;
import java.util.Objects;

public class EventDefBuilder {
    private EventDefinition eventDefinition;

    public static EventDefBuilder eventDef(String type) {
        return new EventDefBuilder(new EventDefinition().withType(type).withName(type));
    }

    public EventDefBuilder metadata(String key, String value) {
        HashMap<String, String> metadata = this.eventDefinition.getMetadata();
        if (metadata == null) {
            metadata = new HashMap<String, String>();
            this.eventDefinition.withMetadata(metadata);
        }
        metadata.put(key, value);
        return this;
    }

    public EventDefBuilder dataOnly(boolean dataOnly) {
        this.eventDefinition.withDataOnly(dataOnly);
        return this;
    }

    public EventDefBuilder source(String source) {
        this.eventDefinition.withSource(source);
        return this;
    }

    private EventDefBuilder(EventDefinition eventDefinition) {
        this.eventDefinition = eventDefinition;
    }

    public EventDefinition build() {
        return this.eventDefinition;
    }

    public String getName() {
        return this.eventDefinition.getName();
    }

    public int hashCode() {
        return Objects.hash(this.eventDefinition);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventDefBuilder other = (EventDefBuilder)obj;
        return Objects.equals(this.eventDefinition.getName(), other.eventDefinition.getName());
    }
}

