/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.kie.kogito.jackson.utils.ObjectMapperFactory;
import org.kie.kogito.serverless.workflow.io.URIContentLoaderFactory;

class JsonSchemaReader {
    JsonSchemaReader() {
    }

    static JsonNode read(URI baseURI, byte[] content) {
        try {
            ObjectNode node = (ObjectNode)ObjectMapperFactory.get().readValue(content, ObjectNode.class);
            JsonNode id = node.get("$id");
            if (id != null) {
                baseURI = URI.create(id.asText());
            }
            Objects.requireNonNull(baseURI, "BaseURI must not be null");
            HashMap<String, JsonSchema> schemas = new HashMap<String, JsonSchema>();
            Counter counter = new Counter();
            JsonSchemaReader.replaceRefsWithDefs((JsonNode)node, baseURI, schemas, counter);
            if (!schemas.isEmpty()) {
                node.set("$defs", JsonSchemaReader.fillDefs(schemas));
            }
            return node;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static JsonNode fillDefs(Map<String, JsonSchema> schemas) {
        ObjectNode node = ObjectMapperFactory.get().createObjectNode();
        schemas.values().stream().collect(Collectors.toMap(v -> v.id, v -> v.node)).forEach((arg_0, arg_1) -> ((ObjectNode)node).set(arg_0, arg_1));
        return node;
    }

    private static void replaceRefsWithDefs(JsonNode node, URI baseURI, Map<String, JsonSchema> schemas, Counter counter) {
        if (node.isArray()) {
            node.elements().forEachRemaining(n -> JsonSchemaReader.replaceRefsWithDefs(n, baseURI, schemas, counter));
        } else if (node.isObject()) {
            ObjectNode objectNode = (ObjectNode)node;
            JsonNode refNode = objectNode.get("$ref");
            if (refNode != null) {
                JsonSchema schema = schemas.computeIfAbsent(refNode.asText(), schemaRef -> JsonSchemaReader.readSchema(schemaRef, baseURI, counter));
                objectNode.put("$ref", "#/$defs/" + schema.id);
            } else {
                objectNode.elements().forEachRemaining(n -> JsonSchemaReader.replaceRefsWithDefs(n, baseURI, schemas, counter));
            }
        }
    }

    private static JsonSchema readSchema(String schemaRef, URI baseURI, Counter counter) {
        try {
            return new JsonSchema((ObjectNode)ObjectMapperFactory.get().readValue(URIContentLoaderFactory.readAllBytes(URIContentLoaderFactory.builder(schemaRef).withBaseURI(baseURI)), ObjectNode.class), counter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class JsonSchema {
        private final String id;
        private final JsonNode node;

        public JsonSchema(ObjectNode node, Counter counter) {
            this.node = node;
            this.id = JsonSchema.getId((JsonNode)node, counter);
        }

        private static String getId(JsonNode schemaContent, Counter counter) {
            JsonNode title = schemaContent.get("title");
            return title != null ? title.asText() + "_" + counter.next() : "nested_" + counter.next();
        }
    }

    private static class Counter {
        private int count;

        private Counter() {
        }

        public int next() {
            return this.count++;
        }
    }
}

