/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.parser;

import io.serverlessworkflow.api.functions.FunctionRef;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import org.kie.kogito.serverless.workflow.parser.FunctionNamespace;

public class FunctionNamespaceFactory {
    private static final FunctionNamespaceFactory INSTANCE = new FunctionNamespaceFactory();
    private static final String NAMESPACE_SEPARATOR = ":";
    private final Map<String, FunctionNamespace> namespaceMap = new HashMap<String, FunctionNamespace>();

    public static FunctionNamespaceFactory instance() {
        return INSTANCE;
    }

    public Optional<FunctionNamespace> getNamespace(FunctionRef functionDef) {
        return Optional.ofNullable(this.namespaceMap.get(FunctionNamespaceFactory.extractNamespace(functionDef)));
    }

    private static String extractNamespace(FunctionRef functionRef) {
        String name = functionRef.getRefName();
        int indexOf = name.lastIndexOf(NAMESPACE_SEPARATOR);
        return indexOf == -1 ? name : name.substring(0, indexOf);
    }

    public static String getFunctionName(FunctionRef functionRef) {
        String name = functionRef.getRefName();
        int indexOf = name.lastIndexOf(NAMESPACE_SEPARATOR);
        return indexOf == -1 ? name : name.substring(indexOf + 1);
    }

    private FunctionNamespaceFactory() {
        ServiceLoader.load(FunctionNamespace.class).forEach(handler -> this.namespaceMap.put(handler.namespace(), (FunctionNamespace)handler));
    }
}

