/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.serverless.workflow.io;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.kie.kogito.serverless.workflow.io.ResourceCache;

public class ResourceCacheFactory {
    private static final AtomicReference<ResourceCache> cache = new AtomicReference<LocalResourceCache>(new LocalResourceCache());

    public static ResourceCache getCache() {
        return cache.get();
    }

    protected static void setResourceCache(ResourceCache newCache) {
        cache.set(newCache);
    }

    private ResourceCacheFactory() {
    }

    private static class LocalResourceCache
    implements ResourceCache {
        private final Map<URI, byte[]> map = Collections.synchronizedMap(new WeakHashMap());

        private LocalResourceCache() {
        }

        @Override
        public byte[] get(URI uri, Function<URI, byte[]> retrieveCall) {
            return this.map.computeIfAbsent(uri, retrieveCall);
        }
    }
}

