/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoKnativeGenerator {
    private static final String YAML_SEPARATOR = "---\n";
    private static final ObjectMapper YAML_MAPPER;
    private static final Logger LOGGER;
    private final List<HasMetadata> resources = new ArrayList<HasMetadata>();

    public KogitoKnativeGenerator addResources(List<? extends HasMetadata> resources) {
        this.resources.addAll(resources);
        return this;
    }

    public KogitoKnativeGenerator addOptionalResource(Optional<? extends HasMetadata> resource) {
        resource.ifPresent(this.resources::add);
        return this;
    }

    public byte[] getResourcesBytes() {
        return this.resources.stream().flatMap(r -> {
            try {
                LOGGER.info("About to generate Kogito Knative resource {} named {}", (Object)r.getKind(), (Object)r.getMetadata().getName());
                return Stream.of(YAML_MAPPER.writeValueAsString(r));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Impossible to generate resource {} named {}", new Object[]{r.getKind(), r.getMetadata().getName(), e});
                return Stream.empty();
            }
        }).map(YAML_SEPARATOR::concat).reduce("", String::concat).getBytes(StandardCharsets.UTF_8);
    }

    static {
        LOGGER = LoggerFactory.getLogger(KogitoKnativeGenerator.class);
        YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS).disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER));
        YAML_MAPPER.configure(SerializationFeature.INDENT_OUTPUT, true);
        YAML_MAPPER.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
        YAML_MAPPER.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
    }
}

