/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.knative.eventing.quarkus.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jbpm.workflow.core.node.AsyncEventNode;
import org.jbpm.workflow.core.node.EventNode;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.StateBasedNode;
import org.jbpm.workflow.core.node.TimerNode;
import org.kie.api.definition.process.Node;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoCloudEventsBuildItem;
import org.kie.kogito.codegen.process.ProcessExecutableModelGenerator;
import org.kie.kogito.codegen.process.ProcessGenerator;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.cloudevents.CloudEventMeta;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.jobs.service.api.utils.ReflectionUtils;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;
import org.kie.kogito.quarkus.addons.common.deployment.OneOfCapabilityKogitoAddOnProcessor;
import org.kie.kogito.quarkus.extensions.spi.deployment.HasWorkflowExtension;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoProcessContainerGeneratorBuildItem;

public class KogitoAddOnJobsKnativeEventingProcessor
extends OneOfCapabilityKogitoAddOnProcessor {
    static final String FEATURE = "kogito-addon-jobs-knative-eventing-extension";
    static final String NOT_STARTED_NOTIFY_PARAMETER = "NotStartedNotify";
    static final String NOT_COMPLETED_NOTIFY_PARAMETER = "NotCompletedNotify";
    static final String NOT_STARTED_REASSIGN_PARAMETER = "NotStartedReassign";
    static final String NOT_COMPLETED_REASSIGN_PARAMETER = "NotCompletedReassign";

    KogitoAddOnJobsKnativeEventingProcessor() {
        super(new KogitoCapability[]{KogitoCapability.PROCESSES, KogitoCapability.SERVERLESS_WORKFLOW});
    }

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public ReflectiveClassBuildItem jobsApiReflection() {
        ArrayList reflectiveClasses = new ArrayList();
        reflectiveClasses.addAll(org.kie.kogito.jobs.api.utils.ReflectionUtils.apiReflectiveClasses());
        reflectiveClasses.addAll(ReflectionUtils.apiReflectiveClasses());
        return new ReflectiveClassBuildItem(true, true, true, reflectiveClasses.toArray(new Class[0]));
    }

    @BuildStep(onlyIfNot={IsTest.class}, onlyIf={HasWorkflowExtension.class})
    public void buildCloudEventsMetadata(List<KogitoProcessContainerGeneratorBuildItem> processContainerBuildItem, BuildProducer<KogitoCloudEventsBuildItem> cloudEventsBuildItemProducer) {
        LinkedHashSet cloudEvents = new LinkedHashSet();
        processContainerBuildItem.stream().flatMap(it -> it.getProcessContainerGenerators().stream()).flatMap(processContainerGenerator -> processContainerGenerator.getProcesses().stream()).map(ProcessGenerator::getProcessExecutable).map(ProcessExecutableModelGenerator::process).filter(KogitoAddOnJobsKnativeEventingProcessor::produceJobEvents).forEach(process -> {
            String eventSource = "/process/" + process.getId();
            cloudEvents.add(new CloudEventMeta("job.create", eventSource, EventKind.PRODUCED));
            cloudEvents.add(new CloudEventMeta("job.delete", eventSource, EventKind.PRODUCED));
        });
        if (!cloudEvents.isEmpty()) {
            cloudEventsBuildItemProducer.produce((BuildItem)new KogitoCloudEventsBuildItem(cloudEvents));
        }
    }

    private static boolean produceJobEvents(KogitoWorkflowProcess process) {
        if (KogitoAddOnJobsKnativeEventingProcessor.hasSlaDueDate(process.getMetaData()) || KogitoAddOnJobsKnativeEventingProcessor.hasProcessDuration(process.getMetaData())) {
            return true;
        }
        return process.getNodesRecursively().stream().anyMatch(KogitoAddOnJobsKnativeEventingProcessor::produceJobEvents);
    }

    private static boolean produceJobEvents(Node node) {
        if (node instanceof TimerNode) {
            return true;
        }
        if (node instanceof AsyncEventNode) {
            return true;
        }
        if (node instanceof EventNode) {
            return KogitoAddOnJobsKnativeEventingProcessor.hasSlaDueDate(node.getMetaData());
        }
        if (node instanceof HumanTaskNode && KogitoAddOnJobsKnativeEventingProcessor.hasDeadlines((HumanTaskNode)node)) {
            return true;
        }
        if (node instanceof StateBasedNode) {
            Map timers = ((StateBasedNode)node).getTimers();
            return timers != null && !timers.isEmpty() || KogitoAddOnJobsKnativeEventingProcessor.hasSlaDueDate(node.getMetaData());
        }
        return false;
    }

    private static boolean hasSlaDueDate(Map<?, ?> metadata) {
        return KogitoAddOnJobsKnativeEventingProcessor.hasMetadataAttribute(metadata, "customSLADueDate");
    }

    private static boolean hasProcessDuration(Map<?, ?> metadata) {
        return KogitoAddOnJobsKnativeEventingProcessor.hasMetadataAttribute(metadata, "processDuration");
    }

    private static boolean hasDeadlines(HumanTaskNode node) {
        return KogitoAddOnJobsKnativeEventingProcessor.hasWorkParameter(node, NOT_STARTED_NOTIFY_PARAMETER) || KogitoAddOnJobsKnativeEventingProcessor.hasWorkParameter(node, NOT_COMPLETED_NOTIFY_PARAMETER) || KogitoAddOnJobsKnativeEventingProcessor.hasWorkParameter(node, NOT_STARTED_REASSIGN_PARAMETER) || KogitoAddOnJobsKnativeEventingProcessor.hasWorkParameter(node, NOT_COMPLETED_REASSIGN_PARAMETER);
    }

    private static boolean hasMetadataAttribute(Map<?, ?> metadata, String attributeName) {
        String value = (String)metadata.get(attributeName);
        return value != null && !value.isEmpty();
    }

    private static boolean hasWorkParameter(HumanTaskNode node, String parameterName) {
        return node.getWork().getParameter(parameterName) != null;
    }
}

